/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantCurve;
import com.opengamma.strata.market.curve.ConstantNodalCurve;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.Curves;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.math.impl.minimization.ParameterLimitsTransform;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import com.opengamma.strata.pricer.option.RawOptionData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class SabrIborCapletFloorletVolatilityCalibrationDefinition
implements IborCapletFloorletVolatilityDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapletFloorletVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(get="optional")
    private final Curve betaCurve;
    @PropertyDefinition(get="optional")
    private final Curve rhoCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve shiftCurve;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<DoubleArray> parameterCurveNodes;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray initialParameters;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator interpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorRight;
    @PropertyDefinition(validate="notNull")
    private final SabrVolatilityFormula sabrVolatilityFormula;
    private static final long serialVersionUID = 1L;

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedBeta(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double beta, double shift, DoubleArray alphaCurveNodes, DoubleArray rhoCurveNodes, DoubleArray nuCurveNodes, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        DoubleArray initialValues = DoubleArray.of((double)0.1, (double)beta, (double)-0.2, (double)0.5);
        return SabrIborCapletFloorletVolatilityCalibrationDefinition.ofFixedBeta(name, index, dayCount, shift, alphaCurveNodes, rhoCurveNodes, nuCurveNodes, initialValues, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedBeta(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double beta, DoubleArray alphaCurveNodes, DoubleArray rhoCurveNodes, DoubleArray nuCurveNodes, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        DoubleArray initialValues = DoubleArray.of((double)0.1, (double)beta, (double)-0.2, (double)0.5);
        return SabrIborCapletFloorletVolatilityCalibrationDefinition.ofFixedBeta(name, index, dayCount, alphaCurveNodes, rhoCurveNodes, nuCurveNodes, initialValues, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedBeta(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double shift, DoubleArray alphaCurveNodes, DoubleArray rhoCurveNodes, DoubleArray nuCurveNodes, DoubleArray initialParameters, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve betaCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Beta"), (DayCount)dayCount, (ValueType)ValueType.SABR_BETA), (double)initialParameters.get(1));
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Shift curve", (double)shift);
        return new SabrIborCapletFloorletVolatilityCalibrationDefinition(name, index, dayCount, (Curve)betaCurve, null, (Curve)shiftCurve, (List<DoubleArray>)ImmutableList.of((Object)alphaCurveNodes, (Object)DoubleArray.of(), (Object)rhoCurveNodes, (Object)nuCurveNodes), initialParameters, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedBeta(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, DoubleArray alphaCurveNodes, DoubleArray rhoCurveNodes, DoubleArray nuCurveNodes, DoubleArray initialParameters, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve betaCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Beta"), (DayCount)dayCount, (ValueType)ValueType.SABR_BETA), (double)initialParameters.get(1));
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Zero shift", (double)0.0);
        return new SabrIborCapletFloorletVolatilityCalibrationDefinition(name, index, dayCount, (Curve)betaCurve, null, (Curve)shiftCurve, (List<DoubleArray>)ImmutableList.of((Object)alphaCurveNodes, (Object)DoubleArray.of(), (Object)rhoCurveNodes, (Object)nuCurveNodes), initialParameters, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedRho(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double rho, double shift, DoubleArray alphaCurveNodes, DoubleArray betaCurveNodes, DoubleArray nuCurveNodes, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        DoubleArray initialParameters = DoubleArray.of((double)0.1, (double)0.7, (double)rho, (double)0.5);
        return SabrIborCapletFloorletVolatilityCalibrationDefinition.ofFixedRho(name, index, dayCount, shift, alphaCurveNodes, betaCurveNodes, nuCurveNodes, initialParameters, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedRho(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double rho, DoubleArray alphaCurveNodes, DoubleArray betaCurveNodes, DoubleArray nuCurveNodes, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        DoubleArray initialParameters = DoubleArray.of((double)0.1, (double)0.7, (double)rho, (double)0.5);
        return SabrIborCapletFloorletVolatilityCalibrationDefinition.ofFixedRho(name, index, dayCount, alphaCurveNodes, betaCurveNodes, nuCurveNodes, initialParameters, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedRho(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double shift, DoubleArray alphaCurveNodes, DoubleArray betaCurveNodes, DoubleArray nuCurveNodes, DoubleArray initialParameters, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve rhoCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Rho"), (DayCount)dayCount, (ValueType)ValueType.SABR_RHO), (double)initialParameters.get(2));
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Shift curve", (double)shift);
        return new SabrIborCapletFloorletVolatilityCalibrationDefinition(name, index, dayCount, null, (Curve)rhoCurve, (Curve)shiftCurve, (List<DoubleArray>)ImmutableList.of((Object)alphaCurveNodes, (Object)betaCurveNodes, (Object)DoubleArray.of(), (Object)nuCurveNodes), initialParameters, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityCalibrationDefinition ofFixedRho(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, DoubleArray alphaCurveNodes, DoubleArray betaCurveNodes, DoubleArray nuCurveNodes, DoubleArray initialParameters, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve rhoCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Rho"), (DayCount)dayCount, (ValueType)ValueType.SABR_RHO), (double)initialParameters.get(2));
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Zero shift", (double)0.0);
        return new SabrIborCapletFloorletVolatilityCalibrationDefinition(name, index, dayCount, null, (Curve)rhoCurve, (Curve)shiftCurve, (List<DoubleArray>)ImmutableList.of((Object)alphaCurveNodes, (Object)betaCurveNodes, (Object)DoubleArray.of(), (Object)nuCurveNodes), initialParameters, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((this.initialParameters.size() == 4 ? 1 : 0) != 0, (String)"The size of initialParameters must be 4");
        ArgChecker.isTrue((this.parameterCurveNodes.size() == 4 ? 1 : 0) != 0, (String)"The size of parameterCurveNodes must be 4");
        ArgChecker.isFalse((boolean)((DoubleArray)this.parameterCurveNodes.get(0)).isEmpty(), (String)"The alpha curve nodes must not be empty");
        ArgChecker.isFalse((boolean)((DoubleArray)this.parameterCurveNodes.get(3)).isEmpty(), (String)"The nu curve nodes must not be empty");
        if (this.betaCurve == null) {
            ArgChecker.isFalse((this.rhoCurve == null ? 1 : 0) != 0, (String)"Either betaCurve or rhoCurve must be set");
            ArgChecker.isFalse((boolean)((DoubleArray)this.parameterCurveNodes.get(1)).isEmpty(), (String)"The beta curve nodes must not be empty");
        } else {
            ArgChecker.isTrue((this.rhoCurve == null ? 1 : 0) != 0, (String)"Only betaCurve or rhoCurve must be set, not both");
            ArgChecker.isFalse((boolean)((DoubleArray)this.parameterCurveNodes.get(2)).isEmpty(), (String)"The rho curve nodes must not be empty");
        }
    }

    @Override
    public SurfaceMetadata createMetadata(RawOptionData capFloorData) {
        SurfaceMetadata metadata;
        if (capFloorData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
            metadata = Surfaces.blackVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
            metadata = Surfaces.normalVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else {
            throw new IllegalArgumentException("Data type not supported");
        }
        return metadata;
    }

    public ImmutableList<CurveMetadata> createSabrParameterMetadata() {
        CurveMetadata alphaMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Alpha"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_ALPHA);
        CurveMetadata betaMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Beta"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_BETA);
        CurveMetadata rhoMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Rho"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_RHO);
        CurveMetadata nuMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Nu"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_NU);
        return ImmutableList.of((Object)alphaMetadata, (Object)betaMetadata, (Object)rhoMetadata, (Object)nuMetadata);
    }

    public List<Curve> createSabrParameterCurve(List<CurveMetadata> metadata, DoubleArray nodeValues) {
        ArrayList<Curve> res = new ArrayList<Curve>();
        int offset = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.isFixed(i)) {
                res.add(this.getBetaCurve().orElse(this.rhoCurve));
                continue;
            }
            int nNodes = ((DoubleArray)this.parameterCurveNodes.get(i)).size();
            int currentOffset = offset;
            if (nNodes > 1) {
                res.add((Curve)InterpolatedNodalCurve.of((CurveMetadata)metadata.get(i), (DoubleArray)((DoubleArray)this.parameterCurveNodes.get(i)), (DoubleArray)DoubleArray.of((int)nNodes, n -> nodeValues.get(n + currentOffset)), (CurveInterpolator)this.interpolator, (CurveExtrapolator)this.extrapolatorLeft, (CurveExtrapolator)this.extrapolatorRight));
            } else {
                res.add((Curve)ConstantNodalCurve.of((CurveMetadata)metadata.get(i), (double)((DoubleArray)this.parameterCurveNodes.get(i)).get(0), (double)nodeValues.get(currentOffset)));
            }
            offset += nNodes;
        }
        return res;
    }

    public ParameterLimitsTransform[] createFullTransform(ParameterLimitsTransform[] transform) {
        ArgChecker.isTrue((transform.length == 4 ? 1 : 0) != 0, (String)"transform must contain transformation defintion for alpha, beta, rho and nu");
        ArrayList<ParameterLimitsTransform> fullTransformList = new ArrayList<ParameterLimitsTransform>();
        int length = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.isFixed(i)) continue;
            int nNodes = ((DoubleArray)this.parameterCurveNodes.get(i)).size();
            fullTransformList.addAll(Collections.nCopies(nNodes, transform[i]));
            length += nNodes;
        }
        return fullTransformList.toArray(new ParameterLimitsTransform[length]);
    }

    public DoubleArray createFullInitialValues() {
        ArrayList<Double> fullInitialValues = new ArrayList<Double>();
        for (int i = 0; i < 4; ++i) {
            if (this.isFixed(i)) continue;
            int nNodes = ((DoubleArray)this.parameterCurveNodes.get(i)).size();
            fullInitialValues.addAll(Collections.nCopies(nNodes, this.initialParameters.get(i)));
        }
        return DoubleArray.copyOf(fullInitialValues);
    }

    private boolean isFixed(int index) {
        return index == 1 && this.getBetaCurve().isPresent() || index == 2 && this.getRhoCurve().isPresent();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SabrIborCapletFloorletVolatilityCalibrationDefinition(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, Curve betaCurve, Curve rhoCurve, Curve shiftCurve, List<DoubleArray> parameterCurveNodes, DoubleArray initialParameters, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)shiftCurve, (String)"shiftCurve");
        JodaBeanUtils.notNull(parameterCurveNodes, (String)"parameterCurveNodes");
        JodaBeanUtils.notNull((Object)initialParameters, (String)"initialParameters");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
        JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
        JodaBeanUtils.notNull((Object)sabrVolatilityFormula, (String)"sabrVolatilityFormula");
        this.name = name;
        this.index = index;
        this.dayCount = dayCount;
        this.betaCurve = betaCurve;
        this.rhoCurve = rhoCurve;
        this.shiftCurve = shiftCurve;
        this.parameterCurveNodes = ImmutableList.copyOf(parameterCurveNodes);
        this.initialParameters = initialParameters;
        this.interpolator = interpolator;
        this.extrapolatorLeft = extrapolatorLeft;
        this.extrapolatorRight = extrapolatorRight;
        this.sabrVolatilityFormula = sabrVolatilityFormula;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public Optional<Curve> getBetaCurve() {
        return Optional.ofNullable(this.betaCurve);
    }

    public Optional<Curve> getRhoCurve() {
        return Optional.ofNullable(this.rhoCurve);
    }

    public Curve getShiftCurve() {
        return this.shiftCurve;
    }

    public ImmutableList<DoubleArray> getParameterCurveNodes() {
        return this.parameterCurveNodes;
    }

    public DoubleArray getInitialParameters() {
        return this.initialParameters;
    }

    public CurveInterpolator getInterpolator() {
        return this.interpolator;
    }

    public CurveExtrapolator getExtrapolatorLeft() {
        return this.extrapolatorLeft;
    }

    public CurveExtrapolator getExtrapolatorRight() {
        return this.extrapolatorRight;
    }

    public SabrVolatilityFormula getSabrVolatilityFormula() {
        return this.sabrVolatilityFormula;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrIborCapletFloorletVolatilityCalibrationDefinition other = (SabrIborCapletFloorletVolatilityCalibrationDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.betaCurve, (Object)other.betaCurve) && JodaBeanUtils.equal((Object)this.rhoCurve, (Object)other.rhoCurve) && JodaBeanUtils.equal((Object)this.shiftCurve, (Object)other.shiftCurve) && JodaBeanUtils.equal(this.parameterCurveNodes, other.parameterCurveNodes) && JodaBeanUtils.equal((Object)this.initialParameters, (Object)other.initialParameters) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.extrapolatorLeft, (Object)other.extrapolatorLeft) && JodaBeanUtils.equal((Object)this.extrapolatorRight, (Object)other.extrapolatorRight) && JodaBeanUtils.equal((Object)this.sabrVolatilityFormula, (Object)other.sabrVolatilityFormula);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.betaCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rhoCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterCurveNodes);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.initialParameters);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorRight);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sabrVolatilityFormula);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(416);
        buf.append("SabrIborCapletFloorletVolatilityCalibrationDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("betaCurve").append('=').append(JodaBeanUtils.toString((Object)this.betaCurve)).append(',').append(' ');
        buf.append("rhoCurve").append('=').append(JodaBeanUtils.toString((Object)this.rhoCurve)).append(',').append(' ');
        buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve)).append(',').append(' ');
        buf.append("parameterCurveNodes").append('=').append(JodaBeanUtils.toString(this.parameterCurveNodes)).append(',').append(' ');
        buf.append("initialParameters").append('=').append(JodaBeanUtils.toString((Object)this.initialParameters)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
        buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight)).append(',').append(' ');
        buf.append("sabrVolatilityFormula").append('=').append(JodaBeanUtils.toString((Object)this.sabrVolatilityFormula));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SabrIborCapletFloorletVolatilityCalibrationDefinition> {
        private IborCapletFloorletVolatilitiesName name;
        private IborIndex index;
        private DayCount dayCount;
        private Curve betaCurve;
        private Curve rhoCurve;
        private Curve shiftCurve;
        private List<DoubleArray> parameterCurveNodes = ImmutableList.of();
        private DoubleArray initialParameters;
        private CurveInterpolator interpolator;
        private CurveExtrapolator extrapolatorLeft;
        private CurveExtrapolator extrapolatorRight;
        private SabrVolatilityFormula sabrVolatilityFormula;

        private Builder() {
        }

        private Builder(SabrIborCapletFloorletVolatilityCalibrationDefinition beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.dayCount = beanToCopy.getDayCount();
            this.betaCurve = beanToCopy.betaCurve;
            this.rhoCurve = beanToCopy.rhoCurve;
            this.shiftCurve = beanToCopy.getShiftCurve();
            this.parameterCurveNodes = beanToCopy.getParameterCurveNodes();
            this.initialParameters = beanToCopy.getInitialParameters();
            this.interpolator = beanToCopy.getInterpolator();
            this.extrapolatorLeft = beanToCopy.getExtrapolatorLeft();
            this.extrapolatorRight = beanToCopy.getExtrapolatorRight();
            this.sabrVolatilityFormula = beanToCopy.getSabrVolatilityFormula();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 1607020767: {
                    return this.betaCurve;
                }
                case -2128671882: {
                    return this.rhoCurve;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
                case -1431162997: {
                    return this.parameterCurveNodes;
                }
                case 1451864142: {
                    return this.initialParameters;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
                case -683564541: {
                    return this.sabrVolatilityFormula;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 1607020767: {
                    this.betaCurve = (Curve)newValue;
                    break;
                }
                case -2128671882: {
                    this.rhoCurve = (Curve)newValue;
                    break;
                }
                case 1908090253: {
                    this.shiftCurve = (Curve)newValue;
                    break;
                }
                case -1431162997: {
                    this.parameterCurveNodes = (List)newValue;
                    break;
                }
                case 1451864142: {
                    this.initialParameters = (DoubleArray)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (CurveInterpolator)newValue;
                    break;
                }
                case 1271703994: {
                    this.extrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 773779145: {
                    this.extrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                case -683564541: {
                    this.sabrVolatilityFormula = (SabrVolatilityFormula)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SabrIborCapletFloorletVolatilityCalibrationDefinition build() {
            return new SabrIborCapletFloorletVolatilityCalibrationDefinition(this.name, this.index, this.dayCount, this.betaCurve, this.rhoCurve, this.shiftCurve, this.parameterCurveNodes, this.initialParameters, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight, this.sabrVolatilityFormula);
        }

        public Builder name(IborCapletFloorletVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder betaCurve(Curve betaCurve) {
            this.betaCurve = betaCurve;
            return this;
        }

        public Builder rhoCurve(Curve rhoCurve) {
            this.rhoCurve = rhoCurve;
            return this;
        }

        public Builder shiftCurve(Curve shiftCurve) {
            JodaBeanUtils.notNull((Object)shiftCurve, (String)"shiftCurve");
            this.shiftCurve = shiftCurve;
            return this;
        }

        public Builder parameterCurveNodes(List<DoubleArray> parameterCurveNodes) {
            JodaBeanUtils.notNull(parameterCurveNodes, (String)"parameterCurveNodes");
            this.parameterCurveNodes = parameterCurveNodes;
            return this;
        }

        public Builder parameterCurveNodes(DoubleArray ... parameterCurveNodes) {
            return this.parameterCurveNodes((List<DoubleArray>)ImmutableList.copyOf((Object[])parameterCurveNodes));
        }

        public Builder initialParameters(DoubleArray initialParameters) {
            JodaBeanUtils.notNull((Object)initialParameters, (String)"initialParameters");
            this.initialParameters = initialParameters;
            return this;
        }

        public Builder interpolator(CurveInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public Builder extrapolatorLeft(CurveExtrapolator extrapolatorLeft) {
            JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
            this.extrapolatorLeft = extrapolatorLeft;
            return this;
        }

        public Builder extrapolatorRight(CurveExtrapolator extrapolatorRight) {
            JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
            this.extrapolatorRight = extrapolatorRight;
            return this;
        }

        public Builder sabrVolatilityFormula(SabrVolatilityFormula sabrVolatilityFormula) {
            JodaBeanUtils.notNull((Object)sabrVolatilityFormula, (String)"sabrVolatilityFormula");
            this.sabrVolatilityFormula = sabrVolatilityFormula;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(416);
            buf.append("SabrIborCapletFloorletVolatilityCalibrationDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("betaCurve").append('=').append(JodaBeanUtils.toString((Object)this.betaCurve)).append(',').append(' ');
            buf.append("rhoCurve").append('=').append(JodaBeanUtils.toString((Object)this.rhoCurve)).append(',').append(' ');
            buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve)).append(',').append(' ');
            buf.append("parameterCurveNodes").append('=').append(JodaBeanUtils.toString(this.parameterCurveNodes)).append(',').append(' ');
            buf.append("initialParameters").append('=').append(JodaBeanUtils.toString((Object)this.initialParameters)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
            buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight)).append(',').append(' ');
            buf.append("sabrVolatilityFormula").append('=').append(JodaBeanUtils.toString((Object)this.sabrVolatilityFormula));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, IborIndex.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, DayCount.class);
        private final MetaProperty<Curve> betaCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"betaCurve", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, Curve.class);
        private final MetaProperty<Curve> rhoCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rhoCurve", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, Curve.class);
        private final MetaProperty<Curve> shiftCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftCurve", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, Curve.class);
        private final MetaProperty<ImmutableList<DoubleArray>> parameterCurveNodes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterCurveNodes", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, ImmutableList.class);
        private final MetaProperty<DoubleArray> initialParameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialParameters", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, DoubleArray.class);
        private final MetaProperty<CurveInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorLeft", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorRight", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, CurveExtrapolator.class);
        private final MetaProperty<SabrVolatilityFormula> sabrVolatilityFormula = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sabrVolatilityFormula", SabrIborCapletFloorletVolatilityCalibrationDefinition.class, SabrVolatilityFormula.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "index", "dayCount", "betaCurve", "rhoCurve", "shiftCurve", "parameterCurveNodes", "initialParameters", "interpolator", "extrapolatorLeft", "extrapolatorRight", "sabrVolatilityFormula"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 1607020767: {
                    return this.betaCurve;
                }
                case -2128671882: {
                    return this.rhoCurve;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
                case -1431162997: {
                    return this.parameterCurveNodes;
                }
                case 1451864142: {
                    return this.initialParameters;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
                case -683564541: {
                    return this.sabrVolatilityFormula;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SabrIborCapletFloorletVolatilityCalibrationDefinition> beanType() {
            return SabrIborCapletFloorletVolatilityCalibrationDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Curve> betaCurve() {
            return this.betaCurve;
        }

        public MetaProperty<Curve> rhoCurve() {
            return this.rhoCurve;
        }

        public MetaProperty<Curve> shiftCurve() {
            return this.shiftCurve;
        }

        public MetaProperty<ImmutableList<DoubleArray>> parameterCurveNodes() {
            return this.parameterCurveNodes;
        }

        public MetaProperty<DoubleArray> initialParameters() {
            return this.initialParameters;
        }

        public MetaProperty<CurveInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorLeft() {
            return this.extrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorRight() {
            return this.extrapolatorRight;
        }

        public MetaProperty<SabrVolatilityFormula> sabrVolatilityFormula() {
            return this.sabrVolatilityFormula;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getName();
                }
                case 100346066: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getIndex();
                }
                case 1905311443: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getDayCount();
                }
                case 1607020767: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).betaCurve;
                }
                case -2128671882: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).rhoCurve;
                }
                case 1908090253: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getShiftCurve();
                }
                case -1431162997: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getParameterCurveNodes();
                }
                case 1451864142: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getInitialParameters();
                }
                case 2096253127: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getInterpolator();
                }
                case 1271703994: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getExtrapolatorLeft();
                }
                case 773779145: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getExtrapolatorRight();
                }
                case -683564541: {
                    return ((SabrIborCapletFloorletVolatilityCalibrationDefinition)bean).getSabrVolatilityFormula();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

