/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSabrSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.SabrParametersIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.impl.rate.ForwardOvernightCompoundedRateComputationFn;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrFormulaData;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrInArrearsVolatilityFunction;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.OvernightInArrearsCapletFloorletPeriod;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;

public class SabrOvernightInArrearsCapletFloorletPeriodPricer {
    private final SabrInArrearsVolatilityFunction sabrInArrearsFunction;
    public static final SabrOvernightInArrearsCapletFloorletPeriodPricer DEFAULT = new SabrOvernightInArrearsCapletFloorletPeriodPricer(SabrInArrearsVolatilityFunction.DEFAULT);
    private static final ForwardOvernightCompoundedRateComputationFn ON_FUNCT = ForwardOvernightCompoundedRateComputationFn.DEFAULT;

    private SabrOvernightInArrearsCapletFloorletPeriodPricer(SabrInArrearsVolatilityFunction sabrInarrearsFunction) {
        this.sabrInArrearsFunction = sabrInarrearsFunction;
    }

    public static SabrOvernightInArrearsCapletFloorletPeriodPricer of(SabrInArrearsVolatilityFunction sabrInarrearsFunction) {
        return new SabrOvernightInArrearsCapletFloorletPeriodPricer(sabrInarrearsFunction);
    }

    public CurrencyAmount presentValue(OvernightInArrearsCapletFloorletPeriod period, RatesProvider ratesProvider, SabrParametersIborCapletFloorletVolatilities sabrVolatilities) {
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        OvernightCompoundedRateComputation onComputation = period.getOvernightRate();
        LocalDate startDate = onComputation.getStartDate();
        LocalDate endDate = onComputation.getEndDate();
        double startTime = sabrVolatilities.relativeTime(startDate.atStartOfDay(ZoneOffset.UTC));
        double endTime = sabrVolatilities.relativeTime(endDate.atStartOfDay(ZoneOffset.UTC));
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double forward = ON_FUNCT.rate(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        if (!ratesProvider.getValuationDate().isBefore(period.getEndDate())) {
            double dfPayment = ratesProvider.discountFactor(currency, period.getPaymentDate());
            return period.payoff(forward).multipliedBy(dfPayment);
        }
        double alpha = sabrVolatilities.alpha(startTime);
        double beta = sabrVolatilities.beta(startTime);
        double rho = sabrVolatilities.rho(startTime);
        double nu = sabrVolatilities.nu(startTime);
        double shift = sabrVolatilities.shift(startTime);
        SabrFormulaData sabr = SabrFormulaData.of(alpha, beta, rho, nu);
        SabrFormulaData sabrAdjusted = this.sabrInArrearsFunction.effectiveSabr(sabr, startTime, endTime);
        double volatility = sabrVolatilities.getParameters().getSabrVolatilityFormula().volatility(forward + shift, strike + shift, endTime, sabrAdjusted.getAlpha(), sabrAdjusted.getBeta(), sabrAdjusted.getRho(), sabrAdjusted.getNu());
        double price = df * period.getYearFraction() * BlackFormulaRepository.price(forward + shift, strike + shift, endTime, volatility, putCall.isCall());
        return CurrencyAmount.of((Currency)currency, (double)(price * period.getNotional()));
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(OvernightInArrearsCapletFloorletPeriod period, RatesProvider ratesProvider, SabrParametersIborCapletFloorletVolatilities sabrVolatilities) {
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        OvernightCompoundedRateComputation onComputation = period.getOvernightRate();
        LocalDate startDate = onComputation.getStartDate();
        LocalDate endDate = onComputation.getEndDate();
        double startTime = sabrVolatilities.relativeTime(startDate.atStartOfDay(ZoneOffset.UTC));
        double endTime = sabrVolatilities.relativeTime(endDate.atStartOfDay(ZoneOffset.UTC));
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double forward = ON_FUNCT.rate(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        if (!ratesProvider.getValuationDate().isBefore(period.getEndDate())) {
            double pvForward;
            double dfPaymentBar = pvForward = period.payoff(forward).getAmount();
            ZeroRateSensitivity ddfPaymentdr = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(period.getPaymentDate());
            return ddfPaymentdr.multipliedBy(dfPaymentBar);
        }
        double alpha = sabrVolatilities.alpha(startTime);
        double beta = sabrVolatilities.beta(startTime);
        double rho = sabrVolatilities.rho(startTime);
        double nu = sabrVolatilities.nu(startTime);
        double shift = sabrVolatilities.shift(startTime);
        SabrFormulaData sabr = SabrFormulaData.of(alpha, beta, rho, nu);
        SabrFormulaData sabrAdjusted = this.sabrInArrearsFunction.effectiveSabr(sabr, startTime, endTime);
        ValueDerivatives volatility = sabrVolatilities.getParameters().getSabrVolatilityFormula().volatilityAdjoint(forward + shift, strike + shift, endTime, sabrAdjusted.getAlpha(), sabrAdjusted.getBeta(), sabrAdjusted.getRho(), sabrAdjusted.getNu());
        ValueDerivatives price = BlackFormulaRepository.priceAdjoint(forward + shift, strike + shift, endTime, volatility.getValue(), putCall.isCall());
        double pv = price.getValue() * df * period.getYearFraction() * period.getNotional();
        double pvBar = 1.0;
        double priceBar = df * period.getYearFraction() * period.getNotional() * pvBar;
        double dfBar = pv / df * pvBar;
        double forwardBar = price.getDerivative(0) * priceBar;
        double volatilityBar = price.getDerivative(3) * priceBar;
        PointSensitivityBuilder dforwarddr = ON_FUNCT.rateSensitivity(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        ZeroRateSensitivity ddfdr = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(period.getPaymentDate());
        return ddfdr.multipliedBy(dfBar).combinedWith(dforwarddr.multipliedBy(forwardBar += volatility.getDerivative(0) * volatilityBar));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(OvernightInArrearsCapletFloorletPeriod period, RatesProvider ratesProvider, SabrParametersIborCapletFloorletVolatilities sabrVolatilities) {
        Currency currency = period.getCurrency();
        if (!ratesProvider.getValuationDate().isBefore(period.getEndDate())) {
            return PointSensitivityBuilder.none();
        }
        OvernightCompoundedRateComputation onComputation = period.getOvernightRate();
        LocalDate startDate = onComputation.getStartDate();
        LocalDate endDate = onComputation.getEndDate();
        double startTime = sabrVolatilities.relativeTime(startDate.atStartOfDay(ZoneOffset.UTC));
        double endTime = sabrVolatilities.relativeTime(endDate.atStartOfDay(ZoneOffset.UTC));
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double forward = ON_FUNCT.rate(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        double alpha = sabrVolatilities.alpha(startTime);
        double beta = sabrVolatilities.beta(startTime);
        double rho = sabrVolatilities.rho(startTime);
        double nu = sabrVolatilities.nu(startTime);
        double shift = sabrVolatilities.shift(startTime);
        SabrFormulaData sabr = SabrFormulaData.of(alpha, beta, rho, nu);
        List<ValueDerivatives> sabrAdjusted = this.sabrInArrearsFunction.effectiveSabrAd(sabr, startTime, endTime);
        ValueDerivatives volatility = sabrVolatilities.getParameters().getSabrVolatilityFormula().volatilityAdjoint(forward + shift, strike + shift, endTime, sabrAdjusted.get(0).getValue(), sabrAdjusted.get(1).getValue(), sabrAdjusted.get(2).getValue(), sabrAdjusted.get(3).getValue());
        ValueDerivatives price = BlackFormulaRepository.priceAdjoint(forward + shift, strike + shift, endTime, volatility.getValue(), putCall.isCall());
        double pvBar = 1.0;
        double priceBar = df * period.getYearFraction() * period.getNotional() * pvBar;
        double volatilityBar = price.getDerivative(3) * priceBar;
        double alphaHatBar = volatility.getDerivative(2) * volatilityBar;
        double betaHatBar = volatility.getDerivative(3) * volatilityBar;
        double rhoHatBar = volatility.getDerivative(4) * volatilityBar;
        double nuHatBar = volatility.getDerivative(5) * volatilityBar;
        DoubleArray paramHat = sabrAdjusted.get(0).getDerivatives().multipliedBy(alphaHatBar);
        paramHat = paramHat.plus(sabrAdjusted.get(1).getDerivatives().multipliedBy(betaHatBar));
        paramHat = paramHat.plus(sabrAdjusted.get(2).getDerivatives().multipliedBy(rhoHatBar));
        paramHat = paramHat.plus(sabrAdjusted.get(3).getDerivatives().multipliedBy(nuHatBar));
        IborCapletFloorletVolatilitiesName name = sabrVolatilities.getName();
        return PointSensitivityBuilder.of((PointSensitivity[])new PointSensitivity[]{IborCapletFloorletSabrSensitivity.of(name, startTime, SabrParameterType.ALPHA, currency, paramHat.get(0)), IborCapletFloorletSabrSensitivity.of(name, startTime, SabrParameterType.BETA, currency, paramHat.get(1)), IborCapletFloorletSabrSensitivity.of(name, startTime, SabrParameterType.RHO, currency, paramHat.get(2)), IborCapletFloorletSabrSensitivity.of(name, startTime, SabrParameterType.NU, currency, paramHat.get(3))});
    }
}

