/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.capfloor.BlackSabrIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSabrSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.model.SabrParameters;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class SabrParametersIborCapletFloorletVolatilities
implements BlackSabrIborCapletFloorletVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapletFloorletVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final SabrParameters parameters;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityAlpha;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityBeta;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityRho;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityNu;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.parameters.getSabrVolatilityFormula().getVolatilityType().equals((Object)ValueType.BLACK_VOLATILITY), (String)"volatility must be of type BLACK_VOLATILITY");
    }

    public static SabrParametersIborCapletFloorletVolatilities of(IborCapletFloorletVolatilitiesName name, IborIndex index, ZonedDateTime valuationDateTime, SabrParameters parameters) {
        return new SabrParametersIborCapletFloorletVolatilities(name, index, valuationDateTime, parameters, null, null, null, null);
    }

    public DayCount getDayCount() {
        return this.getParameters().getDayCount();
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.parameters.getAlphaCurve().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getAlphaCurve()));
        }
        if (this.parameters.getBetaCurve().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getBetaCurve()));
        }
        if (this.parameters.getRhoCurve().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getRhoCurve()));
        }
        if (this.parameters.getNuCurve().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getNuCurve()));
        }
        if (this.parameters.getShiftCurve().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getShiftCurve()));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.parameters.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.parameters.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.parameters.getParameterMetadata(parameterIndex);
    }

    @Override
    public SabrParametersIborCapletFloorletVolatilities withParameter(int parameterIndex, double newValue) {
        SabrParameters updated = this.parameters.withParameter(parameterIndex, newValue);
        return new SabrParametersIborCapletFloorletVolatilities(this.name, this.index, this.valuationDateTime, updated, (List<DoubleArray>)this.dataSensitivityAlpha, (List<DoubleArray>)this.dataSensitivityBeta, (List<DoubleArray>)this.dataSensitivityRho, (List<DoubleArray>)this.dataSensitivityNu);
    }

    @Override
    public SabrParametersIborCapletFloorletVolatilities withPerturbation(ParameterPerturbation perturbation) {
        SabrParameters updated = this.parameters.withPerturbation(perturbation);
        return new SabrParametersIborCapletFloorletVolatilities(this.name, this.index, this.valuationDateTime, updated, (List<DoubleArray>)this.dataSensitivityAlpha, (List<DoubleArray>)this.dataSensitivityBeta, (List<DoubleArray>)this.dataSensitivityRho, (List<DoubleArray>)this.dataSensitivityNu);
    }

    @Override
    public double volatility(double expiry, double strike, double forwardRate) {
        return this.parameters.volatility(expiry, strike, forwardRate);
    }

    @Override
    public ValueDerivatives volatilityAdjoint(double expiry, double strike, double forward) {
        return this.parameters.volatilityAdjoint(expiry, strike, forward);
    }

    @Override
    public double alpha(double expiry) {
        return this.parameters.alpha(expiry);
    }

    @Override
    public double beta(double expiry) {
        return this.parameters.beta(expiry);
    }

    @Override
    public double rho(double expiry) {
        return this.parameters.rho(expiry);
    }

    @Override
    public double nu(double expiry) {
        return this.parameters.nu(expiry);
    }

    @Override
    public double shift(double expiry) {
        return this.parameters.shift(expiry);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            IborCapletFloorletSabrSensitivity pt;
            if (!(point instanceof IborCapletFloorletSabrSensitivity) || !(pt = (IborCapletFloorletSabrSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    private CurrencyParameterSensitivity parameterSensitivity(IborCapletFloorletSabrSensitivity point) {
        Curve curve = this.getCurve(point.getSensitivityType());
        double expiry = point.getExpiry();
        UnitParameterSensitivity unitSens = curve.yValueParameterSensitivity(expiry);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    private Curve getCurve(SabrParameterType type) {
        switch (type) {
            case ALPHA: {
                return this.parameters.getAlphaCurve();
            }
            case BETA: {
                return this.parameters.getBetaCurve();
            }
            case RHO: {
                return this.parameters.getRhoCurve();
            }
            case NU: {
                return this.parameters.getNuCurve();
            }
            case SHIFT: {
                return this.parameters.getShiftCurve();
            }
        }
        throw new IllegalStateException("Invalid enum value");
    }

    @Override
    public double price(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry);
        return BlackFormulaRepository.price(forward + shift, strike + shift, expiry, volatility, putCall.isCall());
    }

    @Override
    public double priceDelta(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry);
        return BlackFormulaRepository.delta(forward + shift, strike + shift, expiry, volatility, putCall.isCall());
    }

    @Override
    public double priceGamma(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry);
        return BlackFormulaRepository.gamma(forward + shift, strike + shift, expiry, volatility);
    }

    @Override
    public double priceTheta(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry);
        return BlackFormulaRepository.driftlessTheta(forward + shift, strike + shift, expiry, volatility);
    }

    @Override
    public double priceVega(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry);
        return BlackFormulaRepository.vega(forward + shift, strike + shift, expiry, volatility);
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.getDayCount().relativeYearFraction(valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SabrParametersIborCapletFloorletVolatilities(IborCapletFloorletVolatilitiesName name, IborIndex index, ZonedDateTime valuationDateTime, SabrParameters parameters, List<DoubleArray> dataSensitivityAlpha, List<DoubleArray> dataSensitivityBeta, List<DoubleArray> dataSensitivityRho, List<DoubleArray> dataSensitivityNu) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        this.name = name;
        this.index = index;
        this.valuationDateTime = valuationDateTime;
        this.parameters = parameters;
        this.dataSensitivityAlpha = dataSensitivityAlpha != null ? ImmutableList.copyOf(dataSensitivityAlpha) : null;
        this.dataSensitivityBeta = dataSensitivityBeta != null ? ImmutableList.copyOf(dataSensitivityBeta) : null;
        this.dataSensitivityRho = dataSensitivityRho != null ? ImmutableList.copyOf(dataSensitivityRho) : null;
        this.dataSensitivityNu = dataSensitivityNu != null ? ImmutableList.copyOf(dataSensitivityNu) : null;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public SabrParameters getParameters() {
        return this.parameters;
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityAlpha() {
        return Optional.ofNullable(this.dataSensitivityAlpha);
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityBeta() {
        return Optional.ofNullable(this.dataSensitivityBeta);
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityRho() {
        return Optional.ofNullable(this.dataSensitivityRho);
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityNu() {
        return Optional.ofNullable(this.dataSensitivityNu);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrParametersIborCapletFloorletVolatilities other = (SabrParametersIborCapletFloorletVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters) && JodaBeanUtils.equal(this.dataSensitivityAlpha, other.dataSensitivityAlpha) && JodaBeanUtils.equal(this.dataSensitivityBeta, other.dataSensitivityBeta) && JodaBeanUtils.equal(this.dataSensitivityRho, other.dataSensitivityRho) && JodaBeanUtils.equal(this.dataSensitivityNu, other.dataSensitivityNu);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityAlpha);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityBeta);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityRho);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityNu);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("SabrParametersIborCapletFloorletVolatilities{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
        buf.append("dataSensitivityAlpha").append('=').append(JodaBeanUtils.toString(this.dataSensitivityAlpha)).append(',').append(' ');
        buf.append("dataSensitivityBeta").append('=').append(JodaBeanUtils.toString(this.dataSensitivityBeta)).append(',').append(' ');
        buf.append("dataSensitivityRho").append('=').append(JodaBeanUtils.toString(this.dataSensitivityRho)).append(',').append(' ');
        buf.append("dataSensitivityNu").append('=').append(JodaBeanUtils.toString(this.dataSensitivityNu));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SabrParametersIborCapletFloorletVolatilities> {
        private IborCapletFloorletVolatilitiesName name;
        private IborIndex index;
        private ZonedDateTime valuationDateTime;
        private SabrParameters parameters;
        private List<DoubleArray> dataSensitivityAlpha;
        private List<DoubleArray> dataSensitivityBeta;
        private List<DoubleArray> dataSensitivityRho;
        private List<DoubleArray> dataSensitivityNu;

        private Builder() {
        }

        private Builder(SabrParametersIborCapletFloorletVolatilities beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.valuationDateTime = beanToCopy.getValuationDateTime();
            this.parameters = beanToCopy.getParameters();
            this.dataSensitivityAlpha = beanToCopy.dataSensitivityAlpha;
            this.dataSensitivityBeta = beanToCopy.dataSensitivityBeta;
            this.dataSensitivityRho = beanToCopy.dataSensitivityRho;
            this.dataSensitivityNu = beanToCopy.dataSensitivityNu;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 458736106: {
                    return this.parameters;
                }
                case 1650101705: {
                    return this.dataSensitivityAlpha;
                }
                case -85295067: {
                    return this.dataSensitivityBeta;
                }
                case 967095332: {
                    return this.dataSensitivityRho;
                }
                case -1077182148: {
                    return this.dataSensitivityNu;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case 458736106: {
                    this.parameters = (SabrParameters)newValue;
                    break;
                }
                case 1650101705: {
                    this.dataSensitivityAlpha = (List)newValue;
                    break;
                }
                case -85295067: {
                    this.dataSensitivityBeta = (List)newValue;
                    break;
                }
                case 967095332: {
                    this.dataSensitivityRho = (List)newValue;
                    break;
                }
                case -1077182148: {
                    this.dataSensitivityNu = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SabrParametersIborCapletFloorletVolatilities build() {
            return new SabrParametersIborCapletFloorletVolatilities(this.name, this.index, this.valuationDateTime, this.parameters, this.dataSensitivityAlpha, this.dataSensitivityBeta, this.dataSensitivityRho, this.dataSensitivityNu);
        }

        public Builder name(IborCapletFloorletVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder valuationDateTime(ZonedDateTime valuationDateTime) {
            JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
            this.valuationDateTime = valuationDateTime;
            return this;
        }

        public Builder parameters(SabrParameters parameters) {
            JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
            this.parameters = parameters;
            return this;
        }

        public Builder dataSensitivityAlpha(List<DoubleArray> dataSensitivityAlpha) {
            this.dataSensitivityAlpha = dataSensitivityAlpha;
            return this;
        }

        public Builder dataSensitivityAlpha(DoubleArray ... dataSensitivityAlpha) {
            return this.dataSensitivityAlpha((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityAlpha));
        }

        public Builder dataSensitivityBeta(List<DoubleArray> dataSensitivityBeta) {
            this.dataSensitivityBeta = dataSensitivityBeta;
            return this;
        }

        public Builder dataSensitivityBeta(DoubleArray ... dataSensitivityBeta) {
            return this.dataSensitivityBeta((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityBeta));
        }

        public Builder dataSensitivityRho(List<DoubleArray> dataSensitivityRho) {
            this.dataSensitivityRho = dataSensitivityRho;
            return this;
        }

        public Builder dataSensitivityRho(DoubleArray ... dataSensitivityRho) {
            return this.dataSensitivityRho((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityRho));
        }

        public Builder dataSensitivityNu(List<DoubleArray> dataSensitivityNu) {
            this.dataSensitivityNu = dataSensitivityNu;
            return this;
        }

        public Builder dataSensitivityNu(DoubleArray ... dataSensitivityNu) {
            return this.dataSensitivityNu((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityNu));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("SabrParametersIborCapletFloorletVolatilities.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
            buf.append("dataSensitivityAlpha").append('=').append(JodaBeanUtils.toString(this.dataSensitivityAlpha)).append(',').append(' ');
            buf.append("dataSensitivityBeta").append('=').append(JodaBeanUtils.toString(this.dataSensitivityBeta)).append(',').append(' ');
            buf.append("dataSensitivityRho").append('=').append(JodaBeanUtils.toString(this.dataSensitivityRho)).append(',').append(' ');
            buf.append("dataSensitivityNu").append('=').append(JodaBeanUtils.toString(this.dataSensitivityNu));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", SabrParametersIborCapletFloorletVolatilities.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", SabrParametersIborCapletFloorletVolatilities.class, IborIndex.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", SabrParametersIborCapletFloorletVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<SabrParameters> parameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameters", SabrParametersIborCapletFloorletVolatilities.class, SabrParameters.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityAlpha = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityAlpha", SabrParametersIborCapletFloorletVolatilities.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityBeta = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityBeta", SabrParametersIborCapletFloorletVolatilities.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityRho = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityRho", SabrParametersIborCapletFloorletVolatilities.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityNu = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityNu", SabrParametersIborCapletFloorletVolatilities.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "index", "valuationDateTime", "parameters", "dataSensitivityAlpha", "dataSensitivityBeta", "dataSensitivityRho", "dataSensitivityNu"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 458736106: {
                    return this.parameters;
                }
                case 1650101705: {
                    return this.dataSensitivityAlpha;
                }
                case -85295067: {
                    return this.dataSensitivityBeta;
                }
                case 967095332: {
                    return this.dataSensitivityRho;
                }
                case -1077182148: {
                    return this.dataSensitivityNu;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SabrParametersIborCapletFloorletVolatilities> beanType() {
            return SabrParametersIborCapletFloorletVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<SabrParameters> parameters() {
            return this.parameters;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityAlpha() {
            return this.dataSensitivityAlpha;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityBeta() {
            return this.dataSensitivityBeta;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityRho() {
            return this.dataSensitivityRho;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityNu() {
            return this.dataSensitivityNu;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).getName();
                }
                case 100346066: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).getIndex();
                }
                case -949589828: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).getValuationDateTime();
                }
                case 458736106: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).getParameters();
                }
                case 1650101705: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).dataSensitivityAlpha;
                }
                case -85295067: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).dataSensitivityBeta;
                }
                case 967095332: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).dataSensitivityRho;
                }
                case -1077182148: {
                    return ((SabrParametersIborCapletFloorletVolatilities)bean).dataSensitivityNu;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

