/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.market.option.SimpleStrike;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.market.surface.interpolator.GridSurfaceInterpolator;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.common.GenericVolatilitySurfacePeriodParameterMetadata;
import com.opengamma.strata.pricer.option.RawOptionData;
import java.io.Serializable;
import java.time.Period;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SurfaceIborCapletFloorletVolatilityBootstrapDefinition
implements IborCapletFloorletVolatilityDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapletFloorletVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final GridSurfaceInterpolator interpolator;
    @PropertyDefinition(get="optional")
    private final Curve shiftCurve;
    private static final long serialVersionUID = 1L;

    public static SurfaceIborCapletFloorletVolatilityBootstrapDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, GridSurfaceInterpolator interpolator) {
        return SurfaceIborCapletFloorletVolatilityBootstrapDefinition.of(name, index, dayCount, interpolator, null);
    }

    public static SurfaceIborCapletFloorletVolatilityBootstrapDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, GridSurfaceInterpolator interpolator, Curve shiftCurve) {
        return new SurfaceIborCapletFloorletVolatilityBootstrapDefinition(name, index, dayCount, interpolator, shiftCurve);
    }

    public static SurfaceIborCapletFloorletVolatilityBootstrapDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, CurveInterpolator timeInterpolator, CurveInterpolator strikeInterpolator) {
        return SurfaceIborCapletFloorletVolatilityBootstrapDefinition.of(name, index, dayCount, timeInterpolator, strikeInterpolator, null);
    }

    public static SurfaceIborCapletFloorletVolatilityBootstrapDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, CurveInterpolator timeInterpolator, CurveInterpolator strikeInterpolator, Curve shiftCurve) {
        GridSurfaceInterpolator gridInterpolator = GridSurfaceInterpolator.of((CurveInterpolator)timeInterpolator, (CurveInterpolator)strikeInterpolator);
        return SurfaceIborCapletFloorletVolatilityBootstrapDefinition.of(name, index, dayCount, gridInterpolator, shiftCurve);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.interpolator.getXExtrapolatorLeft().equals(CurveExtrapolators.FLAT), (String)"x extrapolator left must be flat extrapolator");
        ArgChecker.isTrue((this.interpolator.getXInterpolator().equals(CurveInterpolators.LINEAR) || this.interpolator.getXInterpolator().equals(CurveInterpolators.STEP_UPPER) || this.interpolator.getXInterpolator().equals(CurveInterpolators.TIME_SQUARE) ? 1 : 0) != 0, (String)"x interpolator must be local interpolator");
    }

    @Override
    public SurfaceMetadata createMetadata(RawOptionData capFloorData) {
        SurfaceMetadata metadata;
        ArrayList<GenericVolatilitySurfacePeriodParameterMetadata> list = new ArrayList<GenericVolatilitySurfacePeriodParameterMetadata>();
        ImmutableList<Period> expiries = capFloorData.getExpiries();
        int nExpiries = expiries.size();
        DoubleArray strikes = capFloorData.getStrikes();
        int nStrikes = strikes.size();
        for (int i = 0; i < nExpiries; ++i) {
            for (int j = 0; j < nStrikes; ++j) {
                if (!Double.isFinite(capFloorData.getData().get(i, j))) continue;
                list.add(GenericVolatilitySurfacePeriodParameterMetadata.of((Period)expiries.get(i), (Strike)SimpleStrike.of((double)strikes.get(j))));
            }
        }
        if (capFloorData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
            metadata = Surfaces.blackVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
            metadata = Surfaces.normalVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else {
            throw new IllegalArgumentException("Data type not supported");
        }
        return metadata.withParameterMetadata(list);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SurfaceIborCapletFloorletVolatilityBootstrapDefinition(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, GridSurfaceInterpolator interpolator, Curve shiftCurve) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        this.name = name;
        this.index = index;
        this.dayCount = dayCount;
        this.interpolator = interpolator;
        this.shiftCurve = shiftCurve;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public GridSurfaceInterpolator getInterpolator() {
        return this.interpolator;
    }

    public Optional<Curve> getShiftCurve() {
        return Optional.ofNullable(this.shiftCurve);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SurfaceIborCapletFloorletVolatilityBootstrapDefinition other = (SurfaceIborCapletFloorletVolatilityBootstrapDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.shiftCurve, (Object)other.shiftCurve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftCurve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("SurfaceIborCapletFloorletVolatilityBootstrapDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SurfaceIborCapletFloorletVolatilityBootstrapDefinition> {
        private IborCapletFloorletVolatilitiesName name;
        private IborIndex index;
        private DayCount dayCount;
        private GridSurfaceInterpolator interpolator;
        private Curve shiftCurve;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (GridSurfaceInterpolator)newValue;
                    break;
                }
                case 1908090253: {
                    this.shiftCurve = (Curve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SurfaceIborCapletFloorletVolatilityBootstrapDefinition build() {
            return new SurfaceIborCapletFloorletVolatilityBootstrapDefinition(this.name, this.index, this.dayCount, this.interpolator, this.shiftCurve);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("SurfaceIborCapletFloorletVolatilityBootstrapDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", SurfaceIborCapletFloorletVolatilityBootstrapDefinition.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", SurfaceIborCapletFloorletVolatilityBootstrapDefinition.class, IborIndex.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", SurfaceIborCapletFloorletVolatilityBootstrapDefinition.class, DayCount.class);
        private final MetaProperty<GridSurfaceInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", SurfaceIborCapletFloorletVolatilityBootstrapDefinition.class, GridSurfaceInterpolator.class);
        private final MetaProperty<Curve> shiftCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftCurve", SurfaceIborCapletFloorletVolatilityBootstrapDefinition.class, Curve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "index", "dayCount", "interpolator", "shiftCurve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SurfaceIborCapletFloorletVolatilityBootstrapDefinition> builder() {
            return new Builder();
        }

        public Class<? extends SurfaceIborCapletFloorletVolatilityBootstrapDefinition> beanType() {
            return SurfaceIborCapletFloorletVolatilityBootstrapDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<GridSurfaceInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<Curve> shiftCurve() {
            return this.shiftCurve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((SurfaceIborCapletFloorletVolatilityBootstrapDefinition)bean).getName();
                }
                case 100346066: {
                    return ((SurfaceIborCapletFloorletVolatilityBootstrapDefinition)bean).getIndex();
                }
                case 1905311443: {
                    return ((SurfaceIborCapletFloorletVolatilityBootstrapDefinition)bean).getDayCount();
                }
                case 2096253127: {
                    return ((SurfaceIborCapletFloorletVolatilityBootstrapDefinition)bean).getInterpolator();
                }
                case 1908090253: {
                    return ((SurfaceIborCapletFloorletVolatilityBootstrapDefinition)bean).shiftCurve;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

