/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.surface.InterpolatedNodalSurface;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.market.surface.interpolator.SurfaceInterpolator;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityCalibrationResult;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityCalibrator;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.capfloor.ShiftedBlackIborCapletFloorletExpiryStrikeVolatilities;
import com.opengamma.strata.pricer.capfloor.SurfaceIborCapletFloorletVolatilityBootstrapDefinition;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorLegPricer;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapletFloorletPeriodPricer;
import com.opengamma.strata.pricer.impl.option.GenericImpliedVolatiltySolver;
import com.opengamma.strata.pricer.option.RawOptionData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorLeg;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class SurfaceIborCapletFloorletVolatilityBootstrapper
extends IborCapletFloorletVolatilityCalibrator {
    public static final SurfaceIborCapletFloorletVolatilityBootstrapper DEFAULT = SurfaceIborCapletFloorletVolatilityBootstrapper.of(VolatilityIborCapFloorLegPricer.DEFAULT, ReferenceData.standard());

    public static SurfaceIborCapletFloorletVolatilityBootstrapper of(VolatilityIborCapFloorLegPricer pricer, ReferenceData referenceData) {
        return new SurfaceIborCapletFloorletVolatilityBootstrapper(pricer, referenceData);
    }

    private SurfaceIborCapletFloorletVolatilityBootstrapper(VolatilityIborCapFloorLegPricer pricer, ReferenceData referenceData) {
        super(pricer, referenceData);
    }

    @Override
    public IborCapletFloorletVolatilityCalibrationResult calibrate(IborCapletFloorletVolatilityDefinition definition, ZonedDateTime calibrationDateTime, RawOptionData capFloorData, RatesProvider ratesProvider) {
        ZonedDateTime prevExpiry;
        int start;
        IborCapletFloorletVolatilities vols;
        ArgChecker.isTrue((boolean)ratesProvider.getValuationDate().equals(calibrationDateTime.toLocalDate()), (String)"valuationDate of ratesProvider should be coherent to calibrationDateTime");
        ArgChecker.isTrue((boolean)(definition instanceof SurfaceIborCapletFloorletVolatilityBootstrapDefinition), (String)"definition should be SurfaceIborCapletFloorletVolatilityBootstrapDefinition");
        SurfaceIborCapletFloorletVolatilityBootstrapDefinition bsDefinition = (SurfaceIborCapletFloorletVolatilityBootstrapDefinition)definition;
        IborIndex index = bsDefinition.getIndex();
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        LocalDate baseDate = index.getEffectiveDateOffset().adjust(calibrationDate, this.getReferenceData());
        LocalDate startDate = baseDate.plus((TemporalAmount)index.getTenor());
        Function<Surface, IborCapletFloorletVolatilities> volatilitiesFunction = this.volatilitiesFunction(bsDefinition, calibrationDateTime, capFloorData);
        SurfaceMetadata metadata = bsDefinition.createMetadata(capFloorData);
        ImmutableList<Period> expiries = capFloorData.getExpiries();
        int nExpiries = expiries.size();
        DoubleArray strikes = capFloorData.getStrikes();
        DoubleMatrix errorsMatrix = capFloorData.getError().orElse(DoubleMatrix.filled((int)nExpiries, (int)strikes.size(), (double)1.0));
        ArrayList<Double> timeList = new ArrayList<Double>();
        ArrayList<Double> strikeList = new ArrayList<Double>();
        ArrayList<Double> volList = new ArrayList<Double>();
        ArrayList<ResolvedIborCapFloorLeg> capList = new ArrayList<ResolvedIborCapFloorLeg>();
        ArrayList<Double> priceList = new ArrayList<Double>();
        ArrayList<Double> errorList = new ArrayList<Double>();
        int[] startIndex = new int[nExpiries + 1];
        for (int i = 0; i < nExpiries; ++i) {
            LocalDate endDate = baseDate.plus((TemporalAmount)expiries.get(i));
            DoubleArray volatilityData = capFloorData.getData().row(i);
            DoubleArray errors = errorsMatrix.row(i);
            this.reduceRawData(bsDefinition, ratesProvider, strikes, volatilityData, errors, startDate, endDate, metadata, volatilitiesFunction, timeList, strikeList, volList, capList, priceList, errorList);
            startIndex[i + 1] = volList.size();
            ArgChecker.isTrue((startIndex[i + 1] > startIndex[i] ? 1 : 0) != 0, (String)"no valid option data for {}", (Object[])new Object[]{expiries.get(i)});
        }
        int nTotal = startIndex[nExpiries];
        DoubleArray initialVol = DoubleArray.copyOf(volList);
        if (bsDefinition.getShiftCurve().isPresent()) {
            Curve shiftCurve = bsDefinition.getShiftCurve().get();
            DoubleArray strikeShifted = DoubleArray.of((int)nTotal, n -> (Double)strikeList.get(n) + shiftCurve.yValue(((Double)timeList.get(n)).doubleValue()));
            if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
                metadata = Surfaces.blackVolatilityByExpiryStrike((String)bsDefinition.getName().getName(), (DayCount)bsDefinition.getDayCount()).withParameterMetadata((List)metadata.getParameterMetadata().get());
                initialVol = DoubleArray.of((int)nTotal, n -> (Double)volList.get(n) / (ratesProvider.iborIndexRates(index).rate(((ResolvedIborCapFloorLeg)capList.get(n)).getFinalPeriod().getIborRate().getObservation()) + shiftCurve.yValue(((Double)timeList.get(n)).doubleValue())));
            }
            InterpolatedNodalSurface surface = InterpolatedNodalSurface.of((SurfaceMetadata)metadata, (DoubleArray)DoubleArray.copyOf(timeList), (DoubleArray)strikeShifted, (DoubleArray)initialVol, (SurfaceInterpolator)bsDefinition.getInterpolator());
            vols = ShiftedBlackIborCapletFloorletExpiryStrikeVolatilities.of(index, calibrationDateTime, (Surface)surface, bsDefinition.getShiftCurve().get());
            start = 0;
            prevExpiry = calibrationDateTime.minusDays(1L);
        } else {
            InterpolatedNodalSurface surface = InterpolatedNodalSurface.of((SurfaceMetadata)metadata, (DoubleArray)DoubleArray.copyOf(timeList), (DoubleArray)DoubleArray.copyOf(strikeList), (DoubleArray)initialVol, (SurfaceInterpolator)bsDefinition.getInterpolator());
            vols = volatilitiesFunction.apply((Surface)surface);
            start = 1;
            prevExpiry = ((ResolvedIborCapFloorLeg)capList.get(startIndex[1] - 1)).getFinalFixingDateTime();
        }
        for (int i = start; i < nExpiries; ++i) {
            for (int j = startIndex[i]; j < startIndex[i + 1]; ++j) {
                Function<Double, double[]> func = this.getValueVegaFunction((ResolvedIborCapFloorLeg)capList.get(j), ratesProvider, vols, prevExpiry, j);
                GenericImpliedVolatiltySolver solver = new GenericImpliedVolatiltySolver(func);
                double priceFixed = i == 0 ? 0.0 : this.priceFixed((ResolvedIborCapFloorLeg)capList.get(j), ratesProvider, vols, prevExpiry);
                double capletVol = solver.impliedVolatility((Double)priceList.get(j) - priceFixed, initialVol.get(j));
                vols = vols.withParameter(j, capletVol);
            }
            prevExpiry = ((ResolvedIborCapFloorLeg)capList.get(startIndex[i + 1] - 1)).getFinalFixingDateTime();
        }
        return IborCapletFloorletVolatilityCalibrationResult.ofRootFind(vols);
    }

    private Function<Double, double[]> getValueVegaFunction(final ResolvedIborCapFloorLeg cap, final RatesProvider ratesProvider, final IborCapletFloorletVolatilities vols, final ZonedDateTime prevExpiry, final int nodeIndex) {
        final VolatilityIborCapletFloorletPeriodPricer periodPricer = this.getLegPricer().getPeriodPricer();
        Function<Double, double[]> priceAndVegaFunction = new Function<Double, double[]>(){

            @Override
            public double[] apply(Double x) {
                IborCapletFloorletVolatilities newVols = vols.withParameter(nodeIndex, x);
                double price = cap.getCapletFloorletPeriods().stream().filter(p -> p.getFixingDateTime().isAfter(prevExpiry)).mapToDouble(p -> periodPricer.presentValue((IborCapletFloorletPeriod)p, ratesProvider, newVols).getAmount()).sum();
                PointSensitivities point = cap.getCapletFloorletPeriods().stream().filter(p -> p.getFixingDateTime().isAfter(prevExpiry)).map(p -> periodPricer.presentValueSensitivityModelParamsVolatility((IborCapletFloorletPeriod)p, ratesProvider, newVols)).reduce((c1, c2) -> c1.combinedWith(c2)).get().build();
                CurrencyParameterSensitivities sensi = newVols.parameterSensitivity(point);
                double vega = ((CurrencyParameterSensitivity)sensi.getSensitivities().get(0)).getSensitivity().get(nodeIndex);
                return new double[]{price, vega};
            }
        };
        return priceAndVegaFunction;
    }

    private double priceFixed(ResolvedIborCapFloorLeg cap, RatesProvider ratesProvider, IborCapletFloorletVolatilities vols, ZonedDateTime prevExpiry) {
        VolatilityIborCapletFloorletPeriodPricer periodPricer = this.getLegPricer().getPeriodPricer();
        return cap.getCapletFloorletPeriods().stream().filter(p -> !p.getFixingDateTime().isAfter(prevExpiry)).mapToDouble(p -> periodPricer.presentValue((IborCapletFloorletPeriod)p, ratesProvider, vols).getAmount()).sum();
    }
}

