/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.SabrOvernightInArrearsCapletFloorletPeriodPricer;
import com.opengamma.strata.pricer.capfloor.SabrParametersIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.OvernightInArrearsCapletFloorletBinaryPeriod;
import com.opengamma.strata.product.capfloor.OvernightInArrearsCapletFloorletPeriod;
import com.opengamma.strata.product.common.PutCall;

public class VerticalSpreadSabrOvernightInArrearsCapletFloorletBinaryPeriodPricer {
    private static final double DEFAULT_SPREAD = 1.0E-4;
    public static final VerticalSpreadSabrOvernightInArrearsCapletFloorletBinaryPeriodPricer DEFAULT = new VerticalSpreadSabrOvernightInArrearsCapletFloorletBinaryPeriodPricer(SabrOvernightInArrearsCapletFloorletPeriodPricer.DEFAULT, 1.0E-4);
    private final SabrOvernightInArrearsCapletFloorletPeriodPricer capletPricer;
    private final double spread;

    public VerticalSpreadSabrOvernightInArrearsCapletFloorletBinaryPeriodPricer(SabrOvernightInArrearsCapletFloorletPeriodPricer capletPricer, double spread) {
        this.capletPricer = (SabrOvernightInArrearsCapletFloorletPeriodPricer)ArgChecker.notNull((Object)capletPricer, (String)"capletPricer");
        this.spread = ArgChecker.notNegativeOrZero((double)spread, (String)"spread");
    }

    SabrOvernightInArrearsCapletFloorletPeriodPricer getVanillaOptionProductPricer() {
        return this.capletPricer;
    }

    double getSpread() {
        return this.spread;
    }

    public CurrencyAmount presentValue(OvernightInArrearsCapletFloorletBinaryPeriod period, RatesProvider ratesProvider, SabrParametersIborCapletFloorletVolatilities sabrVolatilities) {
        Pair<OvernightInArrearsCapletFloorletPeriod, OvernightInArrearsCapletFloorletPeriod> callSpread = this.vanillaOptionVerticalSpreadPair(period);
        CurrencyAmount firstOptionPv = this.capletPricer.presentValue((OvernightInArrearsCapletFloorletPeriod)callSpread.getFirst(), ratesProvider, sabrVolatilities);
        CurrencyAmount secondOptionPv = this.capletPricer.presentValue((OvernightInArrearsCapletFloorletPeriod)callSpread.getSecond(), ratesProvider, sabrVolatilities);
        return firstOptionPv.plus(secondOptionPv).multipliedBy(Math.signum(period.getAmount()));
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(OvernightInArrearsCapletFloorletBinaryPeriod period, RatesProvider ratesProvider, SabrParametersIborCapletFloorletVolatilities sabrVolatilities) {
        Pair<OvernightInArrearsCapletFloorletPeriod, OvernightInArrearsCapletFloorletPeriod> callSpread = this.vanillaOptionVerticalSpreadPair(period);
        PointSensitivityBuilder firstOptionPts = this.capletPricer.presentValueSensitivityRatesStickyModel((OvernightInArrearsCapletFloorletPeriod)callSpread.getFirst(), ratesProvider, sabrVolatilities);
        PointSensitivityBuilder secondOptionPts = this.capletPricer.presentValueSensitivityRatesStickyModel((OvernightInArrearsCapletFloorletPeriod)callSpread.getSecond(), ratesProvider, sabrVolatilities);
        return firstOptionPts.combinedWith(secondOptionPts).multipliedBy(Math.signum(period.getAmount()));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(OvernightInArrearsCapletFloorletBinaryPeriod period, RatesProvider ratesProvider, SabrParametersIborCapletFloorletVolatilities sabrVolatilities) {
        Pair<OvernightInArrearsCapletFloorletPeriod, OvernightInArrearsCapletFloorletPeriod> callSpread = this.vanillaOptionVerticalSpreadPair(period);
        PointSensitivityBuilder firstOptionPts = this.capletPricer.presentValueSensitivityModelParamsSabr((OvernightInArrearsCapletFloorletPeriod)callSpread.getFirst(), ratesProvider, sabrVolatilities);
        PointSensitivityBuilder secondOptionPts = this.capletPricer.presentValueSensitivityModelParamsSabr((OvernightInArrearsCapletFloorletPeriod)callSpread.getSecond(), ratesProvider, sabrVolatilities);
        return firstOptionPts.combinedWith(secondOptionPts).multipliedBy(Math.signum(period.getAmount()));
    }

    public Pair<OvernightInArrearsCapletFloorletPeriod, OvernightInArrearsCapletFloorletPeriod> vanillaOptionVerticalSpreadPair(OvernightInArrearsCapletFloorletBinaryPeriod binary) {
        double capFloorInd = binary.getPutCall().equals((Object)PutCall.CALL) ? 1.0 : -1.0;
        double adjStrikeLow = binary.getStrike() - this.spread;
        double adjStrikeHigh = binary.getStrike() + this.spread;
        double amount = Math.abs(binary.getAmount());
        double rescaledNotional = amount / (2.0 * this.spread) * capFloorInd;
        OvernightInArrearsCapletFloorletPeriod.Builder optionLong = OvernightInArrearsCapletFloorletPeriod.builder().currency(binary.getCurrency()).notional(rescaledNotional).startDate(binary.getStartDate()).endDate(binary.getEndDate()).yearFraction(binary.getYearFraction()).paymentDate(binary.getPaymentDate()).overnightRate(binary.getOvernightRate());
        OvernightInArrearsCapletFloorletPeriod.Builder optionShort = OvernightInArrearsCapletFloorletPeriod.builder().currency(binary.getCurrency()).notional(-rescaledNotional).startDate(binary.getStartDate()).endDate(binary.getEndDate()).yearFraction(binary.getYearFraction()).paymentDate(binary.getPaymentDate()).overnightRate(binary.getOvernightRate());
        if (binary.getPutCall().equals((Object)PutCall.CALL)) {
            return Pair.of((Object)optionLong.caplet(Double.valueOf(adjStrikeLow)).build(), (Object)optionShort.caplet(Double.valueOf(adjStrikeHigh)).build());
        }
        return Pair.of((Object)optionLong.floorlet(Double.valueOf(adjStrikeLow)).build(), (Object)optionShort.floorlet(Double.valueOf(adjStrikeHigh)).build());
    }
}

