/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletPeriodAmounts;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletPeriodCurrencyAmounts;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapletFloorletPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorLeg;
import java.util.Collection;
import java.util.Map;

public class VolatilityIborCapFloorLegPricer {
    public static final VolatilityIborCapFloorLegPricer DEFAULT = new VolatilityIborCapFloorLegPricer(VolatilityIborCapletFloorletPeriodPricer.DEFAULT);
    private final VolatilityIborCapletFloorletPeriodPricer periodPricer;

    public VolatilityIborCapFloorLegPricer(VolatilityIborCapletFloorletPeriodPricer periodPricer) {
        this.periodPricer = (VolatilityIborCapletFloorletPeriodPricer)ArgChecker.notNull((Object)periodPricer, (String)"periodPricer");
    }

    public VolatilityIborCapletFloorletPeriodPricer getPeriodPricer() {
        return this.periodPricer;
    }

    public CurrencyAmount presentValue(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValue((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.plus(c2)).get();
    }

    public IborCapletFloorletPeriodCurrencyAmounts presentValueCapletFloorletPeriods(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        ImmutableMap periodPresentValues = MapStream.of((Collection)capFloorLeg.getCapletFloorletPeriods()).mapValues(period -> this.periodPricer.presentValue((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).toMap();
        return IborCapletFloorletPeriodCurrencyAmounts.of((Map<IborCapletFloorletPeriod, CurrencyAmount>)periodPresentValues);
    }

    public CurrencyAmount presentValueDelta(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueDelta((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.plus(c2)).get();
    }

    public CurrencyAmount presentValueGamma(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueGamma((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.plus(c2)).get();
    }

    public CurrencyAmount presentValueTheta(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueTheta((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.plus(c2)).get();
    }

    public PointSensitivityBuilder presentValueSensitivityRates(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueSensitivityRates((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((p1, p2) -> p1.combinedWith(p2)).get();
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueSensitivityModelParamsVolatility((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.combinedWith(c2)).get();
    }

    public CurrencyAmount currentCash(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().filter(period -> period.getPaymentDate().equals(ratesProvider.getValuationDate())).map(period -> this.periodPricer.presentValue((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.plus(c2)).orElse(CurrencyAmount.zero((Currency)capFloorLeg.getCurrency()));
    }

    public IborCapletFloorletPeriodAmounts forwardRates(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider) {
        ImmutableMap forwardRates = MapStream.of((Collection)capFloorLeg.getCapletFloorletPeriods()).filterKeys(period -> !ratesProvider.getValuationDate().isAfter(period.getFixingDate())).mapValues(period -> this.periodPricer.forwardRate((IborCapletFloorletPeriod)period, ratesProvider)).toMap();
        return IborCapletFloorletPeriodAmounts.of((Map<IborCapletFloorletPeriod, Double>)forwardRates);
    }

    public IborCapletFloorletPeriodAmounts impliedVolatilities(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        ImmutableMap impliedVolatilities = MapStream.of((Collection)capFloorLeg.getCapletFloorletPeriods()).filterKeys(period -> volatilities.relativeTime(period.getFixingDateTime()) >= 0.0).mapValues(period -> this.periodPricer.impliedVolatility((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).toMap();
        return IborCapletFloorletPeriodAmounts.of((Map<IborCapletFloorletPeriod, Double>)impliedVolatilities);
    }

    protected void validate(RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        ArgChecker.isTrue((boolean)volatilities.getValuationDate().equals(ratesProvider.getValuationDate()), (String)"volatility and rate data must be for the same date");
    }
}

