/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletPeriodAmounts;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletPeriodCurrencyAmounts;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorLegPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapLegPricer;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloor;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;

public class VolatilityIborCapFloorProductPricer {
    public static final VolatilityIborCapFloorProductPricer DEFAULT = new VolatilityIborCapFloorProductPricer(VolatilityIborCapFloorLegPricer.DEFAULT, DiscountingSwapLegPricer.DEFAULT);
    private final VolatilityIborCapFloorLegPricer capFloorLegPricer;
    private final DiscountingSwapLegPricer payLegPricer;

    public VolatilityIborCapFloorProductPricer(VolatilityIborCapFloorLegPricer capFloorLegPricer, DiscountingSwapLegPricer payLegPricer) {
        this.capFloorLegPricer = (VolatilityIborCapFloorLegPricer)ArgChecker.notNull((Object)capFloorLegPricer, (String)"capFloorLegPricer");
        this.payLegPricer = (DiscountingSwapLegPricer)ArgChecker.notNull((Object)payLegPricer, (String)"payLegPricer");
    }

    protected DiscountingSwapLegPricer getPayLegPricer() {
        return this.payLegPricer;
    }

    public MultiCurrencyAmount presentValue(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        CurrencyAmount pvCapFloorLeg = this.capFloorLegPricer.presentValue(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        if (!capFloor.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCapFloorLeg});
        }
        CurrencyAmount pvPayLeg = this.payLegPricer.presentValue((ResolvedSwapLeg)capFloor.getPayLeg().get(), ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCapFloorLeg}).plus(pvPayLeg);
    }

    public IborCapletFloorletPeriodCurrencyAmounts presentValueCapletFloorletPeriods(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.capFloorLegPricer.presentValueCapletFloorletPeriods(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
    }

    public MultiCurrencyAmount presentValueDelta(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        CurrencyAmount pvCapFloorLeg = this.capFloorLegPricer.presentValueDelta(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCapFloorLeg});
    }

    public MultiCurrencyAmount presentValueGamma(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        CurrencyAmount pvCapFloorLeg = this.capFloorLegPricer.presentValueGamma(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCapFloorLeg});
    }

    public MultiCurrencyAmount presentValueTheta(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        CurrencyAmount pvCapFloorLeg = this.capFloorLegPricer.presentValueTheta(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCapFloorLeg});
    }

    public PointSensitivityBuilder presentValueSensitivityRates(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        PointSensitivityBuilder pvSensiCapFloorLeg = this.capFloorLegPricer.presentValueSensitivityRates(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        if (!capFloor.getPayLeg().isPresent()) {
            return pvSensiCapFloorLeg;
        }
        PointSensitivityBuilder pvSensiPayLeg = this.payLegPricer.presentValueSensitivity((ResolvedSwapLeg)capFloor.getPayLeg().get(), ratesProvider);
        return pvSensiCapFloorLeg.combinedWith(pvSensiPayLeg);
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.capFloorLegPricer.presentValueSensitivityModelParamsVolatility(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        CurrencyAmount ceCapFloorLeg = this.capFloorLegPricer.presentValue(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        if (!capFloor.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ceCapFloorLeg});
        }
        MultiCurrencyAmount cePayLeg = this.payLegPricer.currencyExposure((ResolvedSwapLeg)capFloor.getPayLeg().get(), ratesProvider);
        return cePayLeg.plus(ceCapFloorLeg);
    }

    public MultiCurrencyAmount currentCash(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        CurrencyAmount ccCapFloorLeg = this.capFloorLegPricer.currentCash(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        if (!capFloor.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ccCapFloorLeg});
        }
        CurrencyAmount ccPayLeg = this.payLegPricer.currentCash((ResolvedSwapLeg)capFloor.getPayLeg().get(), ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ccPayLeg}).plus(ccCapFloorLeg);
    }

    public IborCapletFloorletPeriodAmounts forwardRates(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider) {
        return this.capFloorLegPricer.forwardRates(capFloor.getCapFloorLeg(), ratesProvider);
    }

    public IborCapletFloorletPeriodAmounts impliedVolatilities(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.capFloorLegPricer.impliedVolatilities(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
    }
}

