/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletPeriodAmounts;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletPeriodCurrencyAmounts;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorTrade;

public class VolatilityIborCapFloorTradePricer {
    public static final VolatilityIborCapFloorTradePricer DEFAULT = new VolatilityIborCapFloorTradePricer(VolatilityIborCapFloorProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final VolatilityIborCapFloorProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public VolatilityIborCapFloorTradePricer(VolatilityIborCapFloorProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (VolatilityIborCapFloorProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    protected DiscountingPaymentPricer getPaymentPricer() {
        return this.paymentPricer;
    }

    public MultiCurrencyAmount presentValue(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        MultiCurrencyAmount pvProduct = this.productPricer.presentValue(trade.getProduct(), ratesProvider, volatilities);
        if (!trade.getPremium().isPresent()) {
            return pvProduct;
        }
        CurrencyAmount pvPremium = this.paymentPricer.presentValue((Payment)trade.getPremium().get(), ratesProvider);
        return pvProduct.plus(pvPremium);
    }

    public IborCapletFloorletPeriodCurrencyAmounts presentValueCapletFloorletPeriods(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.productPricer.presentValueCapletFloorletPeriods(trade.getProduct(), ratesProvider, volatilities);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        PointSensitivityBuilder pvSensiProduct = this.productPricer.presentValueSensitivityRates(trade.getProduct(), ratesProvider, volatilities);
        if (!trade.getPremium().isPresent()) {
            return pvSensiProduct.build();
        }
        PointSensitivityBuilder pvSensiPremium = this.paymentPricer.presentValueSensitivity((Payment)trade.getPremium().get(), ratesProvider);
        return pvSensiProduct.combinedWith(pvSensiPremium).build();
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.productPricer.presentValueSensitivityModelParamsVolatility(trade.getProduct(), ratesProvider, volatilities);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        MultiCurrencyAmount ceProduct = this.productPricer.currencyExposure(trade.getProduct(), ratesProvider, volatilities);
        if (!trade.getPremium().isPresent()) {
            return ceProduct;
        }
        CurrencyAmount pvPremium = this.paymentPricer.presentValue((Payment)trade.getPremium().get(), ratesProvider);
        return ceProduct.plus(pvPremium);
    }

    public MultiCurrencyAmount currentCash(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        MultiCurrencyAmount ccProduct = this.productPricer.currentCash(trade.getProduct(), ratesProvider, volatilities);
        if (!trade.getPremium().isPresent()) {
            return ccProduct;
        }
        Payment premium = (Payment)trade.getPremium().get();
        if (premium.getDate().equals(ratesProvider.getValuationDate())) {
            ccProduct = ccProduct.plus(premium.getCurrency(), premium.getAmount());
        }
        return ccProduct;
    }

    public IborCapletFloorletPeriodAmounts forwardRates(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.forwardRates(trade.getProduct(), ratesProvider);
    }

    public IborCapletFloorletPeriodAmounts impliedVolatilities(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.productPricer.impliedVolatilities(trade.getProduct(), ratesProvider, volatilities);
    }
}

