/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.impl.rate.ForwardOvernightCompoundedRateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.OvernightInArrearsCapletFloorletPeriod;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import java.time.LocalDate;
import java.time.ZoneOffset;

public class VolatilityOvernightInArrearsCapletFloorletPeriodPricer {
    public static final VolatilityOvernightInArrearsCapletFloorletPeriodPricer DEFAULT = new VolatilityOvernightInArrearsCapletFloorletPeriodPricer();
    private static final ForwardOvernightCompoundedRateComputationFn ON_FUNCT = ForwardOvernightCompoundedRateComputationFn.DEFAULT;

    public CurrencyAmount presentValue(OvernightInArrearsCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        OvernightCompoundedRateComputation onComputation = period.getOvernightRate();
        LocalDate startDate = onComputation.getStartDate();
        LocalDate endDate = onComputation.getEndDate();
        double startTime = volatilities.relativeTime(startDate.atStartOfDay(ZoneOffset.UTC));
        double endTime = volatilities.relativeTime(endDate.atStartOfDay(ZoneOffset.UTC));
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double forward = ON_FUNCT.rate(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        if (!ratesProvider.getValuationDate().isBefore(period.getEndDate())) {
            double dfPayment = ratesProvider.discountFactor(currency, period.getPaymentDate());
            return period.payoff(forward).multipliedBy(dfPayment);
        }
        double volatility = volatilities.volatility(endTime, strike, forward);
        double adjustedVolatility = this.adjustedVolatility(startTime, endTime, volatility);
        double price = df * period.getYearFraction() * volatilities.price(endTime, putCall, strike, forward, adjustedVolatility);
        return CurrencyAmount.of((Currency)currency, (double)(price * period.getNotional()));
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyStrike(OvernightInArrearsCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        OvernightCompoundedRateComputation onComputation = period.getOvernightRate();
        LocalDate startDate = onComputation.getStartDate();
        LocalDate endDate = onComputation.getEndDate();
        double startTime = volatilities.relativeTime(startDate.atStartOfDay(ZoneOffset.UTC));
        double endTime = volatilities.relativeTime(endDate.atStartOfDay(ZoneOffset.UTC));
        double dfPayment = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double forward = ON_FUNCT.rate(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        if (!ratesProvider.getValuationDate().isBefore(period.getEndDate())) {
            double pvForward;
            double dfPaymentBar = pvForward = period.payoff(forward).getAmount();
            ZeroRateSensitivity ddfPaymentdr = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(period.getPaymentDate());
            return ddfPaymentdr.multipliedBy(dfPaymentBar);
        }
        double volatility = volatilities.volatility(endTime, strike, forward);
        double adjustedVolatility = this.adjustedVolatility(startTime, endTime, volatility);
        double price = volatilities.price(endTime, putCall, strike, forward, adjustedVolatility);
        double pv = dfPayment * period.getYearFraction() * price * period.getNotional();
        double pvBar = 1.0;
        double priceBar = dfPayment * period.getYearFraction() * period.getNotional() * pvBar;
        double dfPaymentBar = pv / dfPayment * pvBar;
        double priceDelta = volatilities.priceDelta(endTime, putCall, strike, forward, adjustedVolatility);
        double forwardBar = priceDelta * priceBar;
        PointSensitivityBuilder dforwarddr = ON_FUNCT.rateSensitivity(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        ZeroRateSensitivity ddfPaymentdr = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(period.getPaymentDate());
        return ddfPaymentdr.multipliedBy(dfPaymentBar).combinedWith(dforwarddr.multipliedBy(forwardBar));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(OvernightInArrearsCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        Currency currency = period.getCurrency();
        if (!ratesProvider.getValuationDate().isBefore(period.getEndDate())) {
            return PointSensitivityBuilder.none();
        }
        OvernightCompoundedRateComputation onComputation = period.getOvernightRate();
        LocalDate startDate = onComputation.getStartDate();
        LocalDate endDate = onComputation.getEndDate();
        double startTime = volatilities.relativeTime(startDate.atStartOfDay(ZoneOffset.UTC));
        double endTime = volatilities.relativeTime(endDate.atStartOfDay(ZoneOffset.UTC));
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double forward = ON_FUNCT.rate(onComputation, onComputation.getStartDate(), onComputation.getEndDate(), ratesProvider);
        double volatility = volatilities.volatility(endTime, strike, forward);
        double adjustedVolatility = this.adjustedVolatility(startTime, endTime, volatility);
        double price = volatilities.price(endTime, putCall, strike, forward, adjustedVolatility);
        double pv = df * period.getYearFraction() * price * period.getNotional();
        double pvBar = 1.0;
        double priceBar = pv / price * pvBar;
        double priceVega = volatilities.priceVega(endTime, putCall, strike, forward, adjustedVolatility);
        double adjustedVolatilityBar = priceVega * priceBar;
        double volatilityBar = adjustedVolatility / volatility * adjustedVolatilityBar;
        return IborCapletFloorletSensitivity.of(volatilities.getName(), endTime, strike, forward, currency, volatilityBar);
    }

    public double adjustedVolatility(double startTime, double endTime, double volatility) {
        if (startTime > 0.0) {
            return volatility * Math.sqrt(0.3333333333333333 + 0.6666666666666666 * startTime / endTime);
        }
        return volatility * endTime / (endTime - startTime) / Math.sqrt(3.0);
    }
}

