/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.cms.DiscountingCmsLegPricer;
import com.opengamma.strata.pricer.impl.cms.DiscountingCmsPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.cms.ResolvedCms;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;

public class DiscountingCmsProductPricer {
    public static final DiscountingCmsProductPricer DEFAULT = new DiscountingCmsProductPricer(DiscountingSwapProductPricer.DEFAULT);
    private final DiscountingSwapProductPricer swapPricer;
    private final DiscountingCmsLegPricer cmsLegPricer;

    public DiscountingCmsProductPricer(DiscountingSwapProductPricer swapPricer) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
        this.cmsLegPricer = new DiscountingCmsLegPricer(new DiscountingCmsPeriodPricer(swapPricer));
    }

    public MultiCurrencyAmount presentValue(ResolvedCms cms, RatesProvider ratesProvider) {
        CurrencyAmount pvCmsLeg = this.cmsLegPricer.presentValue(cms.getCmsLeg(), ratesProvider);
        if (!cms.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCmsLeg});
        }
        CurrencyAmount pvPayLeg = this.swapPricer.getLegPricer().presentValue((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCmsLeg}).plus(pvPayLeg);
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedCms cms, RatesProvider ratesProvider) {
        PointSensitivityBuilder pvSensiCmsLeg = this.cmsLegPricer.presentValueSensitivity(cms.getCmsLeg(), ratesProvider);
        if (!cms.getPayLeg().isPresent()) {
            return pvSensiCmsLeg;
        }
        PointSensitivityBuilder pvSensiPayLeg = this.swapPricer.getLegPricer().presentValueSensitivity((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return pvSensiCmsLeg.combinedWith(pvSensiPayLeg);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCms cms, RatesProvider ratesProvider) {
        return this.presentValue(cms, ratesProvider);
    }

    public MultiCurrencyAmount currentCash(ResolvedCms cms, RatesProvider ratesProvider) {
        CurrencyAmount ccCmsLeg = this.cmsLegPricer.currentCash(cms.getCmsLeg(), ratesProvider);
        if (!cms.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ccCmsLeg});
        }
        CurrencyAmount ccPayLeg = this.swapPricer.getLegPricer().currentCash((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ccPayLeg}).plus(ccCmsLeg);
    }
}

