/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.cms.ResolvedCmsLeg;
import java.util.stream.Collectors;

public class SabrExtrapolationReplicationCmsLegPricer {
    private final SabrExtrapolationReplicationCmsPeriodPricer cmsPeriodPricer;

    public SabrExtrapolationReplicationCmsLegPricer(SabrExtrapolationReplicationCmsPeriodPricer cmsPeriodPricer) {
        this.cmsPeriodPricer = (SabrExtrapolationReplicationCmsPeriodPricer)ArgChecker.notNull((Object)cmsPeriodPricer, (String)"cmsPeriodPricer");
    }

    public CurrencyAmount presentValue(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(ratesProvider, swaptionVolatilities);
        return cmsLeg.getCmsPeriods().stream().map(cmsPeriod -> this.cmsPeriodPricer.presentValue((CmsPeriod)cmsPeriod, ratesProvider, swaptionVolatilities)).reduce((c1, c2) -> c1.plus(c2)).get();
    }

    public ExplainMap explainPresentValue(ResolvedCmsLeg cmsLeg, RatesProvider provider, SabrSwaptionVolatilities volatilities) {
        ExplainMapBuilder builder = ExplainMap.builder();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"CmsLeg");
        builder.put(ExplainKey.PAY_RECEIVE, (Object)cmsLeg.getPayReceive());
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)cmsLeg.getCurrency());
        builder.put(ExplainKey.START_DATE, (Object)cmsLeg.getStartDate());
        builder.put(ExplainKey.END_DATE, (Object)cmsLeg.getEndDate());
        builder.put(ExplainKey.INDEX, (Object)cmsLeg.getIndex());
        for (CmsPeriod period : cmsLeg.getCmsPeriods()) {
            builder.addListEntry(ExplainKey.PAYMENT_PERIODS, child -> this.cmsPeriodPricer.explainPresentValue(period, provider, volatilities, (ExplainMapBuilder)child));
        }
        builder.put(ExplainKey.PRESENT_VALUE, (Object)this.presentValue(cmsLeg, provider, volatilities));
        return builder.build();
    }

    public PointSensitivityBuilder presentValueSensitivityRates(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(ratesProvider, swaptionVolatilities);
        return cmsLeg.getCmsPeriods().stream().map(cmsPeriod -> this.cmsPeriodPricer.presentValueSensitivityRates((CmsPeriod)cmsPeriod, ratesProvider, swaptionVolatilities)).reduce((p1, p2) -> p1.combinedWith(p2)).get();
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(ratesProvider, swaptionVolatilities);
        return cmsLeg.getCmsPeriods().stream().map(cmsPeriod -> this.cmsPeriodPricer.presentValueSensitivityModelParamsSabr((CmsPeriod)cmsPeriod, ratesProvider, swaptionVolatilities)).reduce(PointSensitivityBuilder.none(), PointSensitivityBuilder::combinedWith).normalize();
    }

    public double presentValueSensitivityStrike(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(ratesProvider, swaptionVolatilities);
        return cmsLeg.getCmsPeriods().stream().map(cmsPeriod -> this.cmsPeriodPricer.presentValueSensitivityStrike((CmsPeriod)cmsPeriod, ratesProvider, swaptionVolatilities)).collect(Collectors.summingDouble(Double::doubleValue));
    }

    public CurrencyAmount currentCash(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(ratesProvider, swaptionVolatilities);
        return cmsLeg.getCmsPeriods().stream().filter(x -> x.getPaymentDate().equals(ratesProvider.getValuationDate())).map(x -> this.cmsPeriodPricer.presentValue((CmsPeriod)x, ratesProvider, swaptionVolatilities)).reduce((c1, c2) -> c1.plus(c2)).orElse(CurrencyAmount.zero((Currency)cmsLeg.getCurrency()));
    }

    private void validate(RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        ArgChecker.isTrue((boolean)swaptionVolatilities.getValuationDate().equals(ratesProvider.getValuationDate()), (String)"volatility and rate data must be for the same date");
    }
}

