/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.integration.RungeKuttaIntegrator1D;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.impl.option.SabrExtrapolationRightFunction;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrFormulaData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionSabrSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.cms.CmsPeriodType;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapIndex;
import com.opengamma.strata.product.swap.SwapLegType;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.OptionalDouble;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SabrExtrapolationReplicationCmsPeriodPricer {
    private static final Logger log = LoggerFactory.getLogger(SabrExtrapolationReplicationCmsPeriodPricer.class);
    private static final int NUM_ITER = 10;
    private static final double REL_TOL = 1.0E-10;
    private static final double ABS_TOL = 1.0E-8;
    private static final double REL_TOL_STRIKE = 1.0E-5;
    private static final double REL_TOL_VEGA = 0.001;
    private static final int MAX_COUNT = 10;
    private static final double ZERO_SHIFT = 1.0E-6;
    private static final double MIN_TIME = 1.0E-4;
    private final DiscountingSwapProductPricer swapPricer;
    private final double cutOffStrike;
    private final double mu;

    public static SabrExtrapolationReplicationCmsPeriodPricer of(DiscountingSwapProductPricer swapPricer, double cutOffStrike, double mu) {
        return new SabrExtrapolationReplicationCmsPeriodPricer(swapPricer, cutOffStrike, mu);
    }

    public static SabrExtrapolationReplicationCmsPeriodPricer of(double cutOffStrike, double mu) {
        return SabrExtrapolationReplicationCmsPeriodPricer.of(DiscountingSwapProductPricer.DEFAULT, cutOffStrike, mu);
    }

    public DiscountingSwapProductPricer getSwapPricer() {
        return this.swapPricer;
    }

    public double getMu() {
        return this.mu;
    }

    public double getCutOffStrike() {
        return this.cutOffStrike;
    }

    private SabrExtrapolationReplicationCmsPeriodPricer(DiscountingSwapProductPricer swapPricer, double cutOffStrike, double mu) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
        this.cutOffStrike = cutOffStrike;
        this.mu = ArgChecker.notNegativeOrZero((double)mu, (String)"mu");
    }

    public CurrencyAmount presentValue(CmsPeriod cmsPeriod, RatesProvider provider, SabrSwaptionVolatilities swaptionVolatilities) {
        double strikeCpn;
        Currency ccy = cmsPeriod.getCurrency();
        if (provider.getValuationDate().isAfter(cmsPeriod.getPaymentDate())) {
            return CurrencyAmount.zero((Currency)ccy);
        }
        SwapIndex index = cmsPeriod.getIndex();
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        ZonedDateTime valuationDate = swaptionVolatilities.getValuationDateTime();
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        double expiryTime = swaptionVolatilities.relativeTime(fixingDate.atTime(index.getFixingTime()).atZone(index.getFixingZone()));
        double tenor = swaptionVolatilities.tenor(swap.getStartDate(), swap.getEndDate());
        double shift = swaptionVolatilities.shift(expiryTime, tenor);
        double d = strikeCpn = cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON) ? -shift : cmsPeriod.getStrike();
        if (!fixingDate.isAfter(valuationDate.toLocalDate())) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                double payoff = this.payOff(cmsPeriod.getCmsPeriodType(), strikeCpn, fixedRate.getAsDouble());
                return CurrencyAmount.of((Currency)ccy, (double)(dfPayment * payoff * cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
            }
            if (fixingDate.isBefore(valuationDate.toLocalDate())) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        double forward = this.swapPricer.parRate(swap, provider);
        if (expiryTime < 1.0E-4) {
            double payoff = this.payOff(cmsPeriod.getCmsPeriodType(), strikeCpn, forward);
            return CurrencyAmount.of((Currency)ccy, (double)(dfPayment * payoff * cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
        }
        double eta = index.getTemplate().getConvention().getFixedLeg().getDayCount().relativeYearFraction(cmsPeriod.getPaymentDate(), swap.getStartDate());
        CmsIntegrantProvider intProv = new CmsIntegrantProvider(cmsPeriod, swap, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor, this.cutOffStrike, eta);
        double factor = dfPayment / intProv.h(forward) * intProv.g(forward);
        double strikePart = factor * intProv.k(strikeCpn) * intProv.bs(strikeCpn);
        RungeKuttaIntegrator1D integrator = new RungeKuttaIntegrator1D(1.0E-8, 1.0E-10, 10);
        double integralPart = 0.0;
        Function<Double, Double> integrant = intProv.integrant();
        try {
            integralPart = intProv.getPutCall().isCall() ? dfPayment * this.integrateCall(integrator, integrant, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor) : -dfPayment * integrator.integrate(integrant, Double.valueOf(-shift + 1.0E-6), Double.valueOf(strikeCpn));
        }
        catch (Exception e) {
            throw new MathException((Throwable)e);
        }
        double priceCMS = strikePart + integralPart;
        if (cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON)) {
            priceCMS -= dfPayment * shift;
        }
        return CurrencyAmount.of((Currency)ccy, (double)(priceCMS *= cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
    }

    public double adjustedForwardRate(CmsPeriod cmsPeriod, RatesProvider provider, SabrSwaptionVolatilities swaptionVolatilities) {
        CmsPeriod coupon = cmsPeriod.toCouponEquivalent();
        Currency ccy = cmsPeriod.getCurrency();
        double dfPayment = provider.discountFactor(ccy, coupon.getPaymentDate());
        double pv = this.presentValue(coupon, provider, swaptionVolatilities).getAmount();
        return pv / (coupon.getNotional() * coupon.getYearFraction() * dfPayment);
    }

    public double adjustmentToForwardRate(CmsPeriod cmsPeriod, RatesProvider provider, SabrSwaptionVolatilities swaptionVolatilities) {
        CmsPeriod coupon = cmsPeriod.toCouponEquivalent();
        double adjustedForwardRate = this.adjustedForwardRate(coupon, provider, swaptionVolatilities);
        double forward = this.swapPricer.parRate(coupon.getUnderlyingSwap(), provider);
        return adjustedForwardRate - forward;
    }

    public PointSensitivityBuilder presentValueSensitivityRates(CmsPeriod cmsPeriod, RatesProvider provider, SabrSwaptionVolatilities swaptionVolatilities) {
        double strikeCpn;
        Currency ccy = cmsPeriod.getCurrency();
        if (provider.getValuationDate().isAfter(cmsPeriod.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        SwapIndex index = cmsPeriod.getIndex();
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        ZonedDateTime valuationDate = swaptionVolatilities.getValuationDateTime();
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        double expiryTime = swaptionVolatilities.relativeTime(fixingDate.atTime(index.getFixingTime()).atZone(index.getFixingZone()));
        double tenor = swaptionVolatilities.tenor(swap.getStartDate(), swap.getEndDate());
        double shift = swaptionVolatilities.shift(expiryTime, tenor);
        double d = strikeCpn = cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON) ? -shift : cmsPeriod.getStrike();
        if (!fixingDate.isAfter(valuationDate.toLocalDate())) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                double payoff = this.payOff(cmsPeriod.getCmsPeriodType(), strikeCpn, fixedRate.getAsDouble());
                return provider.discountFactors(ccy).zeroRatePointSensitivity(cmsPeriod.getPaymentDate()).multipliedBy(payoff * cmsPeriod.getNotional() * cmsPeriod.getYearFraction());
            }
            if (fixingDate.isBefore(valuationDate.toLocalDate())) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        double forward = this.swapPricer.parRate(swap, provider);
        double eta = index.getTemplate().getConvention().getFixedLeg().getDayCount().relativeYearFraction(cmsPeriod.getPaymentDate(), swap.getStartDate());
        CmsDeltaIntegrantProvider intProv = new CmsDeltaIntegrantProvider(cmsPeriod, swap, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor, this.cutOffStrike, eta);
        RungeKuttaIntegrator1D integrator = new RungeKuttaIntegrator1D(1.0E-8, 1.0E-10, 10);
        double[] bs = intProv.bsbsp(strikeCpn);
        double[] n = intProv.getNnp();
        double strikePartPrice = intProv.k(strikeCpn) * n[0] * bs[0];
        double integralPartPrice = 0.0;
        double integralPart = 0.0;
        Function<Double, Double> integrant = intProv.integrant();
        Function<Double, Double> integrantDelta = intProv.integrantDelta();
        try {
            if (intProv.getPutCall().isCall()) {
                integralPartPrice = this.integrateCall(integrator, integrant, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor);
                integralPart = dfPayment * this.integrateCall(integrator, integrantDelta, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor);
            } else {
                integralPartPrice = -integrator.integrate(integrant, Double.valueOf(-shift + 1.0E-6), Double.valueOf(strikeCpn)).doubleValue();
                integralPart = -dfPayment * integrator.integrate(integrantDelta, Double.valueOf(-shift), Double.valueOf(strikeCpn));
            }
        }
        catch (Exception e) {
            throw new MathException((Throwable)e);
        }
        double deltaPD = strikePartPrice + integralPartPrice;
        if (cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON)) {
            deltaPD -= shift;
        }
        double strikePart = dfPayment * intProv.k(strikeCpn) * (n[1] * bs[0] + n[0] * bs[1]);
        double deltaFwd = (strikePart + integralPart) * cmsPeriod.getNotional() * cmsPeriod.getYearFraction();
        PointSensitivityBuilder sensiFwd = this.swapPricer.parRateSensitivity(swap, provider).multipliedBy(deltaFwd);
        ZeroRateSensitivity sensiDf = provider.discountFactors(ccy).zeroRatePointSensitivity(cmsPeriod.getPaymentDate()).multipliedBy(deltaPD *= cmsPeriod.getNotional() * cmsPeriod.getYearFraction());
        return sensiFwd.combinedWith((PointSensitivityBuilder)sensiDf);
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(CmsPeriod cmsPeriod, RatesProvider provider, SabrSwaptionVolatilities swaptionVolatilities) {
        Currency ccy = cmsPeriod.getCurrency();
        SwapIndex index = cmsPeriod.getIndex();
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        ZonedDateTime valuationDate = swaptionVolatilities.getValuationDateTime();
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        ZonedDateTime expiryDate = fixingDate.atTime(index.getFixingTime()).atZone(index.getFixingZone());
        double tenor = swaptionVolatilities.tenor(swap.getStartDate(), swap.getEndDate());
        if (provider.getValuationDate().isAfter(cmsPeriod.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        if (!fixingDate.isAfter(valuationDate.toLocalDate())) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                return PointSensitivityBuilder.none();
            }
            if (fixingDate.isBefore(valuationDate.toLocalDate())) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        double expiryTime = swaptionVolatilities.relativeTime(expiryDate);
        double shift = swaptionVolatilities.shift(expiryTime, tenor);
        double strikeCpn = cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON) ? -shift : cmsPeriod.getStrike();
        double forward = this.swapPricer.parRate(swap, provider);
        double eta = index.getTemplate().getConvention().getFixedLeg().getDayCount().relativeYearFraction(cmsPeriod.getPaymentDate(), swap.getStartDate());
        CmsIntegrantProvider intProv = new CmsIntegrantProvider(cmsPeriod, swap, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor, this.cutOffStrike, eta);
        double factor = dfPayment / intProv.h(forward) * intProv.g(forward);
        double factor2 = factor * intProv.k(strikeCpn);
        double[] strikePartPrice = intProv.getSabrExtrapolation().priceAdjointSabr(Math.max(0.0, strikeCpn + shift), intProv.getPutCall()).getDerivatives().multipliedBy(factor2).toArray();
        RungeKuttaIntegrator1D integrator = new RungeKuttaIntegrator1D(1.0E-8, 0.001, 10);
        double[] totalSensi = new double[4];
        for (int loopparameter = 0; loopparameter < 4; ++loopparameter) {
            double integralPart = 0.0;
            Function<Double, Double> integrant = intProv.integrantVega(loopparameter);
            try {
                integralPart = intProv.getPutCall().isCall() ? dfPayment * this.integrateCall(integrator, integrant, swaptionVolatilities, forward, strikeCpn, expiryTime, tenor) : -dfPayment * integrator.integrate(integrant, Double.valueOf(-shift + 1.0E-6), Double.valueOf(strikeCpn));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            totalSensi[loopparameter] = (strikePartPrice[loopparameter] + integralPart) * cmsPeriod.getNotional() * cmsPeriod.getYearFraction();
        }
        SwaptionVolatilitiesName name = swaptionVolatilities.getName();
        return PointSensitivityBuilder.of((PointSensitivity[])new PointSensitivity[]{SwaptionSabrSensitivity.of(name, expiryTime, tenor, SabrParameterType.ALPHA, ccy, totalSensi[0]), SwaptionSabrSensitivity.of(name, expiryTime, tenor, SabrParameterType.BETA, ccy, totalSensi[1]), SwaptionSabrSensitivity.of(name, expiryTime, tenor, SabrParameterType.RHO, ccy, totalSensi[2]), SwaptionSabrSensitivity.of(name, expiryTime, tenor, SabrParameterType.NU, ccy, totalSensi[3])});
    }

    public double presentValueSensitivityStrike(CmsPeriod cmsPeriod, RatesProvider provider, SabrSwaptionVolatilities swaptionVolatilities) {
        double thirdPart;
        double firstPart;
        ArgChecker.isFalse((boolean)cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON), (String)"presentValueSensitivityStrike is not relevant for CMS coupon");
        Currency ccy = cmsPeriod.getCurrency();
        SwapIndex index = cmsPeriod.getIndex();
        if (provider.getValuationDate().isAfter(cmsPeriod.getPaymentDate())) {
            return 0.0;
        }
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        ZonedDateTime valuationDate = swaptionVolatilities.getValuationDateTime();
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        double tenor = swaptionVolatilities.tenor(swap.getStartDate(), swap.getEndDate());
        ZonedDateTime expiryDate = fixingDate.atTime(index.getFixingTime()).atZone(index.getFixingZone());
        double expiryTime = swaptionVolatilities.relativeTime(expiryDate);
        double strike = cmsPeriod.getStrike();
        double shift = swaptionVolatilities.shift(expiryTime, tenor);
        if (!fixingDate.isAfter(valuationDate.toLocalDate())) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                double payoff = 0.0;
                switch (cmsPeriod.getCmsPeriodType()) {
                    case CAPLET: {
                        payoff = fixedRate.getAsDouble() >= strike ? -1.0 : 0.0;
                        break;
                    }
                    case FLOORLET: {
                        payoff = fixedRate.getAsDouble() < strike ? 1.0 : 0.0;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported CMS type");
                    }
                }
                return payoff * cmsPeriod.getNotional() * cmsPeriod.getYearFraction() * dfPayment;
            }
            if (fixingDate.isBefore(valuationDate.toLocalDate())) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        double forward = this.swapPricer.parRate(swap, provider);
        double eta = index.getTemplate().getConvention().getFixedLeg().getDayCount().relativeYearFraction(cmsPeriod.getPaymentDate(), swap.getStartDate());
        CmsIntegrantProvider intProv = new CmsIntegrantProvider(cmsPeriod, swap, swaptionVolatilities, forward, strike, expiryTime, tenor, this.cutOffStrike, eta);
        double factor = dfPayment * intProv.g(forward) / intProv.h(forward);
        RungeKuttaIntegrator1D integrator = new RungeKuttaIntegrator1D(1.0E-8, 1.0E-5, 10);
        double[] kpkpp = intProv.kpkpp(strike);
        Function<Double, Double> integrant = intProv.integrantDualDelta();
        if (intProv.getPutCall().isCall()) {
            firstPart = -kpkpp[0] * intProv.bs(strike);
            thirdPart = this.integrateCall(integrator, integrant, swaptionVolatilities, forward, strike, expiryTime, tenor);
        } else {
            firstPart = -kpkpp[0] * intProv.bs(strike);
            thirdPart = -integrator.integrate(integrant, Double.valueOf(-shift + 1.0E-6), Double.valueOf(strike)).doubleValue();
        }
        double secondPart = intProv.k(strike) * intProv.getSabrExtrapolation().priceDerivativeStrike(strike + shift, intProv.getPutCall());
        return cmsPeriod.getNotional() * cmsPeriod.getYearFraction() * factor * (firstPart + secondPart + thirdPart);
    }

    private double payOff(CmsPeriodType cmsPeriodType, double strikeCpn, Double fixedRate) {
        double payoff = 0.0;
        switch (cmsPeriodType) {
            case CAPLET: {
                payoff = Math.max(fixedRate - strikeCpn, 0.0);
                break;
            }
            case FLOORLET: {
                payoff = Math.max(strikeCpn - fixedRate, 0.0);
                break;
            }
            case COUPON: {
                payoff = fixedRate;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported CMS type");
            }
        }
        return payoff;
    }

    private double integrateCall(RungeKuttaIntegrator1D integrator, Function<Double, Double> integrant, SabrSwaptionVolatilities swaptionVolatilities, double forward, double strike, double expiryTime, double tenor) {
        double vol = swaptionVolatilities.volatility(expiryTime, tenor, forward, forward);
        double upper0 = Math.max(forward * Math.exp(6.0 * vol * Math.sqrt(expiryTime)), Math.max(this.cutOffStrike, 2.0 * strike));
        double upper = Math.min(upper0, 1.0);
        double res = integrator.integrate(integrant, Double.valueOf(strike), Double.valueOf(upper));
        double reminder = integrant.apply(upper) * upper;
        double error = reminder / res;
        int count = 0;
        while (Math.abs(error) > integrator.getRelativeTolerance() && count < 10) {
            reminder = integrant.apply(upper *= 2.0) * upper;
            error = reminder / (res += integrator.integrate(integrant, Double.valueOf(upper), Double.valueOf(2.0 * upper)).doubleValue());
            if (++count != 10) continue;
            log.info("Maximum iteration count, 10, has been reached. Relative error is greater than " + integrator.getRelativeTolerance());
        }
        return res;
    }

    public void explainPresentValue(CmsPeriod period, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities, ExplainMapBuilder builder) {
        String type = period.getCmsPeriodType().toString();
        Currency ccy = period.getCurrency();
        LocalDate paymentDate = period.getPaymentDate();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)("Cms" + type + "Period"));
        builder.put(ExplainKey.STRIKE_VALUE, (Object)period.getStrike());
        builder.put(ExplainKey.NOTIONAL, (Object)CurrencyAmount.of((Currency)ccy, (double)period.getNotional()));
        builder.put(ExplainKey.PAYMENT_DATE, (Object)period.getPaymentDate());
        builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)ratesProvider.discountFactor(ccy, paymentDate));
        builder.put(ExplainKey.START_DATE, (Object)period.getStartDate());
        builder.put(ExplainKey.END_DATE, (Object)period.getEndDate());
        builder.put(ExplainKey.FIXING_DATE, (Object)period.getFixingDate());
        builder.put(ExplainKey.ACCRUAL_YEAR_FRACTION, (Object)period.getYearFraction());
        builder.put(ExplainKey.PRESENT_VALUE, (Object)this.presentValue(period, ratesProvider, swaptionVolatilities));
        builder.put(ExplainKey.FORWARD_RATE, (Object)this.swapPricer.parRate(period.getUnderlyingSwap(), ratesProvider));
        builder.put(ExplainKey.CONVEXITY_ADJUSTED_RATE, (Object)this.adjustedForwardRate(period, ratesProvider, swaptionVolatilities));
    }

    private class CmsDeltaIntegrantProvider
    extends CmsIntegrantProvider {
        private final double[] nnp;

        public CmsDeltaIntegrantProvider(CmsPeriod cmsPeriod, ResolvedSwap swap, SabrSwaptionVolatilities swaptionVolatilities, double forward, double strike, double timeToExpiry, double tenor, double cutOffStrike, double eta) {
            super(cmsPeriod, swap, swaptionVolatilities, forward, strike, timeToExpiry, tenor, cutOffStrike, eta);
            this.nnp = this.nnp(forward);
        }

        public double[] getNnp() {
            return this.nnp;
        }

        Function<Double, Double> integrantDelta() {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    double[] kD = CmsDeltaIntegrantProvider.this.kpkpp(x);
                    double[] bs = CmsDeltaIntegrantProvider.this.bsbsp(x);
                    return (kD[1] * (x - CmsDeltaIntegrantProvider.this.getStrike()) + 2.0 * kD[0]) * (CmsDeltaIntegrantProvider.this.nnp[1] * bs[0] + CmsDeltaIntegrantProvider.this.nnp[0] * bs[1]);
                }
            };
        }

        private double[] bsbsp(double strike) {
            double[] result = new double[2];
            double strikeShifted = Math.max(strike + this.getShift(), 0.0);
            result[0] = this.getSabrExtrapolation().price(strikeShifted, this.getPutCall());
            result[1] = this.getSabrExtrapolation().priceDerivativeForward(strikeShifted, this.getPutCall());
            return result;
        }

        private double[] nnp(double x) {
            double[] result = new double[2];
            double[] ggpgpp = this.ggpgpp(x);
            double[] hhp = this.hhp(x);
            result[0] = ggpgpp[0] / hhp[0];
            result[1] = ggpgpp[1] / hhp[0] - ggpgpp[0] * hhp[1] / (hhp[0] * hhp[0]);
            return result;
        }

        private double[] hhp(double x) {
            double[] result;
            result = new double[]{Math.pow(1.0 + this.getTau() * x, this.getEta()), this.getEta() * this.getTau() * result[0] / (1.0 + x * this.getTau())};
            return result;
        }
    }

    private class CmsIntegrantProvider {
        protected static final double EPS = 1.0E-4;
        private final int nbFixedPeriod;
        private final int nbFixedPaymentYear;
        private final double tau;
        private final double eta;
        private final double strike;
        private final double shift;
        private final double factor;
        private final SabrExtrapolationRightFunction sabrExtrapolation;
        private final PutCall putCall;
        private final double[] g0;

        public double getTau() {
            return this.tau;
        }

        public double getEta() {
            return this.eta;
        }

        public PutCall getPutCall() {
            return this.putCall;
        }

        protected double getStrike() {
            return this.strike;
        }

        protected double getShift() {
            return this.shift;
        }

        public SabrExtrapolationRightFunction getSabrExtrapolation() {
            return this.sabrExtrapolation;
        }

        public CmsIntegrantProvider(CmsPeriod cmsPeriod, ResolvedSwap swap, SabrSwaptionVolatilities swaptionVolatilities, double forward, double strike, double timeToExpiry, double tenor, double cutOffStrike, double eta) {
            ResolvedSwapLeg fixedLeg = (ResolvedSwapLeg)swap.getLegs(SwapLegType.FIXED).get(0);
            this.nbFixedPeriod = fixedLeg.getPaymentPeriods().size();
            this.nbFixedPaymentYear = (int)Math.round(1.0 / ((RateAccrualPeriod)((RatePaymentPeriod)fixedLeg.getPaymentPeriods().get(0)).getAccrualPeriods().get(0)).getYearFraction());
            this.tau = 1.0 / (double)this.nbFixedPaymentYear;
            this.eta = eta;
            SabrFormulaData sabrPoint = SabrFormulaData.of(swaptionVolatilities.alpha(timeToExpiry, tenor), swaptionVolatilities.beta(timeToExpiry, tenor), swaptionVolatilities.rho(timeToExpiry, tenor), swaptionVolatilities.nu(timeToExpiry, tenor));
            this.shift = swaptionVolatilities.shift(timeToExpiry, tenor);
            this.sabrExtrapolation = SabrExtrapolationRightFunction.of(forward + this.shift, timeToExpiry, sabrPoint, cutOffStrike + this.shift, SabrExtrapolationReplicationCmsPeriodPricer.this.mu);
            this.putCall = cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.FLOORLET) ? PutCall.PUT : PutCall.CALL;
            this.strike = strike;
            this.g0 = new double[4];
            this.g0[0] = (double)this.nbFixedPeriod * this.tau;
            this.g0[1] = -0.5 * (double)this.nbFixedPeriod * ((double)this.nbFixedPeriod + 1.0) * this.tau * this.tau;
            this.g0[2] = -0.6666666666666666 * this.g0[1] * ((double)this.nbFixedPeriod + 2.0) * this.tau;
            this.g0[3] = -0.75 * this.g0[2] * ((double)this.nbFixedPeriod + 2.0) * this.tau;
            this.factor = this.g(forward) / this.h(forward);
        }

        Function<Double, Double> integrant() {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    double[] kD = CmsIntegrantProvider.this.kpkpp(x);
                    return CmsIntegrantProvider.this.factor * (kD[1] * (x - CmsIntegrantProvider.this.strike) + 2.0 * kD[0]) * CmsIntegrantProvider.this.bs(x);
                }
            };
        }

        Function<Double, Double> integrantVega(final int i) {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    double[] kD = CmsIntegrantProvider.this.kpkpp(x);
                    double xShifted = Math.max(x + CmsIntegrantProvider.this.shift, 0.0);
                    DoubleArray priceDerivativeSabr = CmsIntegrantProvider.this.getSabrExtrapolation().priceAdjointSabr(xShifted, CmsIntegrantProvider.this.putCall).getDerivatives();
                    return priceDerivativeSabr.get(i) * (CmsIntegrantProvider.this.factor * (kD[1] * (x - CmsIntegrantProvider.this.strike) + 2.0 * kD[0]));
                }
            };
        }

        Function<Double, Double> integrantDualDelta() {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    double[] kD = CmsIntegrantProvider.this.kpkpp(x);
                    return -kD[1] * CmsIntegrantProvider.this.bs(x);
                }
            };
        }

        double h(double x) {
            return Math.pow(1.0 + this.tau * x, this.eta);
        }

        double g(double x) {
            if (Math.abs(x) >= 1.0E-4) {
                double periodFactor = 1.0 + x / (double)this.nbFixedPaymentYear;
                double nPeriodDiscount = Math.pow(periodFactor, -this.nbFixedPeriod);
                return (1.0 - nPeriodDiscount) / x;
            }
            return this.g0[0] + this.g0[1] * x + 0.5 * this.g0[2] * x * x + this.g0[3] * x * x * x / 6.0;
        }

        double[] ggpgpp(double x) {
            if (Math.abs(x) >= 1.0E-4) {
                double[] ggpgpp;
                double periodFactor = 1.0 + x / (double)this.nbFixedPaymentYear;
                double nPeriodDiscount = Math.pow(periodFactor, -this.nbFixedPeriod);
                ggpgpp = new double[]{(1.0 - nPeriodDiscount) / x, -ggpgpp[0] / x + (double)this.nbFixedPeriod * nPeriodDiscount / (x * (double)this.nbFixedPaymentYear * periodFactor), 2.0 / (x * x) * ggpgpp[0] - 2.0 * (double)this.nbFixedPeriod * nPeriodDiscount / (x * x * (double)this.nbFixedPaymentYear * periodFactor) - ((double)this.nbFixedPeriod + 1.0) * (double)this.nbFixedPeriod * nPeriodDiscount / (x * (double)this.nbFixedPaymentYear * (double)this.nbFixedPaymentYear * periodFactor * periodFactor)};
                return ggpgpp;
            }
            return new double[]{this.g0[0] + this.g0[1] * x + 0.5 * this.g0[2] * x * x + this.g0[3] * x * x * x / 6.0, this.g0[1] + this.g0[2] * x + 0.5 * this.g0[3] * x * x, this.g0[2] + this.g0[3] * x};
        }

        double k(double x) {
            double g = this.g(x);
            double h = Math.pow(1.0 + this.tau * x, this.eta);
            return h / g;
        }

        protected double[] kpkpp(double x) {
            double periodFactor = 1.0 + x / (double)this.nbFixedPaymentYear;
            double[] ggpgpp = this.ggpgpp(x);
            double h = Math.pow(1.0 + this.tau * x, this.eta);
            double hp = this.eta * this.tau * h / periodFactor;
            double hpp = (this.eta - 1.0) * this.tau * hp / periodFactor;
            double kp = hp / ggpgpp[0] - h * ggpgpp[1] / (ggpgpp[0] * ggpgpp[0]);
            double kpp = hpp / ggpgpp[0] - 2.0 * hp * ggpgpp[1] / (ggpgpp[0] * ggpgpp[0]) - h * (ggpgpp[2] / (ggpgpp[0] * ggpgpp[0]) - 2.0 * (ggpgpp[1] * ggpgpp[1]) / (ggpgpp[0] * ggpgpp[0] * ggpgpp[0]));
            return new double[]{kp, kpp};
        }

        double bs(double strike) {
            double strikeShifted = Math.max(strike + this.getShift(), 0.0);
            return this.sabrExtrapolation.price(strikeShifted, this.putCall);
        }
    }
}

