/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsLegPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapLegPricer;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.product.cms.ResolvedCms;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import java.util.ArrayList;

public class SabrExtrapolationReplicationCmsProductPricer {
    private final SabrExtrapolationReplicationCmsLegPricer cmsLegPricer;
    private final DiscountingSwapLegPricer payLegPricer;

    public SabrExtrapolationReplicationCmsProductPricer(SabrExtrapolationReplicationCmsLegPricer cmsLegPricer) {
        this(cmsLegPricer, DiscountingSwapLegPricer.DEFAULT);
    }

    public SabrExtrapolationReplicationCmsProductPricer(SabrExtrapolationReplicationCmsLegPricer cmsLegPricer, DiscountingSwapLegPricer payLegPricer) {
        this.cmsLegPricer = (SabrExtrapolationReplicationCmsLegPricer)ArgChecker.notNull((Object)cmsLegPricer, (String)"cmsLegPricer");
        this.payLegPricer = (DiscountingSwapLegPricer)ArgChecker.notNull((Object)payLegPricer, (String)"payLegPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        CurrencyAmount pvCmsLeg = this.cmsLegPricer.presentValue(cms.getCmsLeg(), ratesProvider, swaptionVolatilities);
        if (!cms.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCmsLeg});
        }
        CurrencyAmount pvPayLeg = this.payLegPricer.presentValue((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvCmsLeg}).plus(pvPayLeg);
    }

    public ExplainMap explainPresentValue(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        ExplainMapBuilder builder = ExplainMap.builder();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"CmsSwap");
        ArrayList<ExplainMap> legsExplain = new ArrayList<ExplainMap>();
        legsExplain.add(this.cmsLegPricer.explainPresentValue(cms.getCmsLeg(), ratesProvider, swaptionVolatilities));
        if (cms.getPayLeg().isPresent()) {
            legsExplain.add(this.payLegPricer.explainPresentValue((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider));
        }
        builder.put(ExplainKey.LEGS, legsExplain);
        return builder.build();
    }

    public PointSensitivityBuilder presentValueSensitivityRates(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        PointSensitivityBuilder pvSensiCmsLeg = this.cmsLegPricer.presentValueSensitivityRates(cms.getCmsLeg(), ratesProvider, swaptionVolatilities);
        if (!cms.getPayLeg().isPresent()) {
            return pvSensiCmsLeg;
        }
        PointSensitivityBuilder pvSensiPayLeg = this.payLegPricer.presentValueSensitivity((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return pvSensiCmsLeg.combinedWith(pvSensiPayLeg);
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        return this.cmsLegPricer.presentValueSensitivityModelParamsSabr(cms.getCmsLeg(), ratesProvider, swaptionVolatilities);
    }

    public double presentValueSensitivityStrike(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        return this.cmsLegPricer.presentValueSensitivityStrike(cms.getCmsLeg(), ratesProvider, swaptionVolatilities);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        CurrencyAmount ceCmsLeg = this.cmsLegPricer.presentValue(cms.getCmsLeg(), ratesProvider, swaptionVolatilities);
        if (!cms.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ceCmsLeg});
        }
        MultiCurrencyAmount cePayLeg = this.payLegPricer.currencyExposure((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return cePayLeg.plus(ceCmsLeg);
    }

    public MultiCurrencyAmount currentCash(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        CurrencyAmount ccCmsLeg = this.cmsLegPricer.currentCash(cms.getCmsLeg(), ratesProvider, swaptionVolatilities);
        if (!cms.getPayLeg().isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ccCmsLeg});
        }
        CurrencyAmount ccPayLeg = this.payLegPricer.currentCash((ResolvedSwapLeg)cms.getPayLeg().get(), ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{ccPayLeg}).plus(ccCmsLeg);
    }
}

