/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.product.cms.ResolvedCms;
import com.opengamma.strata.product.cms.ResolvedCmsTrade;

public class SabrExtrapolationReplicationCmsTradePricer {
    private final SabrExtrapolationReplicationCmsProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public SabrExtrapolationReplicationCmsTradePricer(SabrExtrapolationReplicationCmsProductPricer cmsProductPricer) {
        this(cmsProductPricer, DiscountingPaymentPricer.DEFAULT);
    }

    public SabrExtrapolationReplicationCmsTradePricer(SabrExtrapolationReplicationCmsProductPricer cmsProductPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (SabrExtrapolationReplicationCmsProductPricer)ArgChecker.notNull((Object)cmsProductPricer, (String)"cmsProductPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedCmsTrade trade, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        MultiCurrencyAmount pvCms = this.productPricer.presentValue(trade.getProduct(), ratesProvider, swaptionVolatilities);
        if (!trade.getPremium().isPresent()) {
            return pvCms;
        }
        CurrencyAmount pvPremium = this.paymentPricer.presentValue((Payment)trade.getPremium().get(), ratesProvider);
        return pvCms.plus(pvPremium);
    }

    public ExplainMap explainPresentValue(ResolvedCms cms, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        return this.productPricer.explainPresentValue(cms, ratesProvider, swaptionVolatilities);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedCmsTrade trade, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        PointSensitivityBuilder pvSensiCms = this.productPricer.presentValueSensitivityRates(trade.getProduct(), ratesProvider, swaptionVolatilities);
        if (!trade.getPremium().isPresent()) {
            return pvSensiCms.build();
        }
        PointSensitivityBuilder pvSensiPremium = this.paymentPricer.presentValueSensitivity((Payment)trade.getPremium().get(), ratesProvider);
        return pvSensiCms.combinedWith(pvSensiPremium).build();
    }

    public PointSensitivities presentValueSensitivityModelParamsSabr(ResolvedCmsTrade trade, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        return this.productPricer.presentValueSensitivityModelParamsSabr(trade.getProduct(), ratesProvider, swaptionVolatilities).build();
    }

    public double presentValueSensitivityStrike(ResolvedCmsTrade trade, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        return this.productPricer.presentValueSensitivityStrike(trade.getProduct(), ratesProvider, swaptionVolatilities);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCmsTrade trade, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        MultiCurrencyAmount ceCms = this.productPricer.currencyExposure(trade.getProduct(), ratesProvider, swaptionVolatilities);
        if (!trade.getPremium().isPresent()) {
            return ceCms;
        }
        CurrencyAmount pvPremium = this.paymentPricer.presentValue((Payment)trade.getPremium().get(), ratesProvider);
        return ceCms.plus(pvPremium);
    }

    public MultiCurrencyAmount currentCash(ResolvedCmsTrade trade, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        MultiCurrencyAmount ccCms = this.productPricer.currentCash(trade.getProduct(), ratesProvider, swaptionVolatilities);
        if (!trade.getPremium().isPresent()) {
            return ccCms;
        }
        Payment premium = (Payment)trade.getPremium().get();
        if (premium.getDate().equals(ratesProvider.getValuationDate())) {
            ccCms = ccCms.plus(premium.getCurrency(), premium.getAmount());
        }
        return ccCms;
    }
}

