/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.common;

import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class GenericVolatilitySurfacePeriodParameterMetadata
implements ParameterMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final Period period;
    @PropertyDefinition(validate="notNull")
    private final Strike strike;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static GenericVolatilitySurfacePeriodParameterMetadata of(Period period, Strike strike) {
        String label = Pair.of((Object)period, (Object)strike.getLabel()).toString();
        return new GenericVolatilitySurfacePeriodParameterMetadata(period, strike, label);
    }

    public static GenericVolatilitySurfacePeriodParameterMetadata of(Period period, Strike strike, String label) {
        return new GenericVolatilitySurfacePeriodParameterMetadata(period, strike, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null && builder.strike != null) {
            builder.label = Pair.of((Object)builder.period, (Object)builder.strike.getLabel()).toString();
        }
    }

    public Pair<Period, Strike> getIdentifier() {
        return Pair.of((Object)this.period, (Object)this.strike);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private GenericVolatilitySurfacePeriodParameterMetadata(Period period, Strike strike, String label) {
        JodaBeanUtils.notNull((Object)strike, (String)"strike");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.period = period;
        this.strike = strike;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Strike getStrike() {
        return this.strike;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GenericVolatilitySurfacePeriodParameterMetadata other = (GenericVolatilitySurfacePeriodParameterMetadata)obj;
            return JodaBeanUtils.equal((Object)this.period, (Object)other.period) && JodaBeanUtils.equal((Object)this.strike, (Object)other.strike) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.period);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("GenericVolatilitySurfacePeriodParameterMetadata{");
        buf.append("period").append('=').append(JodaBeanUtils.toString((Object)this.period)).append(',').append(' ');
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<GenericVolatilitySurfacePeriodParameterMetadata> {
        private Period period;
        private Strike strike;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    return this.period;
                }
                case -891985998: {
                    return this.strike;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    this.period = (Period)newValue;
                    break;
                }
                case -891985998: {
                    this.strike = (Strike)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public GenericVolatilitySurfacePeriodParameterMetadata build() {
            GenericVolatilitySurfacePeriodParameterMetadata.preBuild(this);
            return new GenericVolatilitySurfacePeriodParameterMetadata(this.period, this.strike, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("GenericVolatilitySurfacePeriodParameterMetadata.Builder{");
            buf.append("period").append('=').append(JodaBeanUtils.toString((Object)this.period)).append(',').append(' ');
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Period> period = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"period", GenericVolatilitySurfacePeriodParameterMetadata.class, Period.class);
        private final MetaProperty<Strike> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", GenericVolatilitySurfacePeriodParameterMetadata.class, Strike.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", GenericVolatilitySurfacePeriodParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"period", "strike", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    return this.period;
                }
                case -891985998: {
                    return this.strike;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends GenericVolatilitySurfacePeriodParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends GenericVolatilitySurfacePeriodParameterMetadata> beanType() {
            return GenericVolatilitySurfacePeriodParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Period> period() {
            return this.period;
        }

        public MetaProperty<Strike> strike() {
            return this.strike;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    return ((GenericVolatilitySurfacePeriodParameterMetadata)bean).getPeriod();
                }
                case -891985998: {
                    return ((GenericVolatilitySurfacePeriodParameterMetadata)bean).getStrike();
                }
                case 102727412: {
                    return ((GenericVolatilitySurfacePeriodParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

