/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.common;

import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class GenericVolatilitySurfaceYearFractionParameterMetadata
implements ParameterMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double yearFraction;
    @PropertyDefinition(get="optional")
    private final Tenor yearFractionTenor;
    @PropertyDefinition(validate="notNull")
    private final Strike strike;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static GenericVolatilitySurfaceYearFractionParameterMetadata of(double yearFraction, Strike strike) {
        String label = Pair.of((Object)yearFraction, (Object)strike.getLabel()).toString();
        return new GenericVolatilitySurfaceYearFractionParameterMetadata(yearFraction, null, strike, label);
    }

    public static GenericVolatilitySurfaceYearFractionParameterMetadata of(double yearFraction, Tenor yearFractionTenor, Strike strike) {
        String label = Pair.of((Object)yearFraction, (Object)strike.getLabel()).toString();
        return new GenericVolatilitySurfaceYearFractionParameterMetadata(yearFraction, yearFractionTenor, strike, label);
    }

    public static GenericVolatilitySurfaceYearFractionParameterMetadata of(double yearFraction, Strike strike, String label) {
        return new GenericVolatilitySurfaceYearFractionParameterMetadata(yearFraction, null, strike, label);
    }

    public static GenericVolatilitySurfaceYearFractionParameterMetadata of(double yearFraction, Tenor yearFractionTenor, Strike strike, String label) {
        return new GenericVolatilitySurfaceYearFractionParameterMetadata(yearFraction, yearFractionTenor, strike, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null && builder.strike != null) {
            builder.label = Pair.of((Object)builder.yearFraction, (Object)builder.strike.getLabel()).toString();
        }
    }

    public Pair<Double, Strike> getIdentifier() {
        return Pair.of((Object)this.yearFraction, (Object)this.strike);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private GenericVolatilitySurfaceYearFractionParameterMetadata(double yearFraction, Tenor yearFractionTenor, Strike strike, String label) {
        JodaBeanUtils.notNull((Object)strike, (String)"strike");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.yearFraction = yearFraction;
        this.yearFractionTenor = yearFractionTenor;
        this.strike = strike;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public Optional<Tenor> getYearFractionTenor() {
        return Optional.ofNullable(this.yearFractionTenor);
    }

    public Strike getStrike() {
        return this.strike;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GenericVolatilitySurfaceYearFractionParameterMetadata other = (GenericVolatilitySurfaceYearFractionParameterMetadata)obj;
            return JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.yearFractionTenor, (Object)other.yearFractionTenor) && JodaBeanUtils.equal((Object)this.strike, (Object)other.strike) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yearFractionTenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("GenericVolatilitySurfaceYearFractionParameterMetadata{");
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("yearFractionTenor").append('=').append(JodaBeanUtils.toString((Object)this.yearFractionTenor)).append(',').append(' ');
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<GenericVolatilitySurfaceYearFractionParameterMetadata> {
        private double yearFraction;
        private Tenor yearFractionTenor;
        private Strike strike;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return this.yearFraction;
                }
                case -1032770399: {
                    return this.yearFractionTenor;
                }
                case -891985998: {
                    return this.strike;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case -1032770399: {
                    this.yearFractionTenor = (Tenor)newValue;
                    break;
                }
                case -891985998: {
                    this.strike = (Strike)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public GenericVolatilitySurfaceYearFractionParameterMetadata build() {
            GenericVolatilitySurfaceYearFractionParameterMetadata.preBuild(this);
            return new GenericVolatilitySurfaceYearFractionParameterMetadata(this.yearFraction, this.yearFractionTenor, this.strike, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("GenericVolatilitySurfaceYearFractionParameterMetadata.Builder{");
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("yearFractionTenor").append('=').append(JodaBeanUtils.toString((Object)this.yearFractionTenor)).append(',').append(' ');
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", GenericVolatilitySurfaceYearFractionParameterMetadata.class, Double.TYPE);
        private final MetaProperty<Tenor> yearFractionTenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFractionTenor", GenericVolatilitySurfaceYearFractionParameterMetadata.class, Tenor.class);
        private final MetaProperty<Strike> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", GenericVolatilitySurfaceYearFractionParameterMetadata.class, Strike.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", GenericVolatilitySurfaceYearFractionParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"yearFraction", "yearFractionTenor", "strike", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return this.yearFraction;
                }
                case -1032770399: {
                    return this.yearFractionTenor;
                }
                case -891985998: {
                    return this.strike;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends GenericVolatilitySurfaceYearFractionParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends GenericVolatilitySurfaceYearFractionParameterMetadata> beanType() {
            return GenericVolatilitySurfaceYearFractionParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Tenor> yearFractionTenor() {
            return this.yearFractionTenor;
        }

        public MetaProperty<Strike> strike() {
            return this.strike;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return ((GenericVolatilitySurfaceYearFractionParameterMetadata)bean).getYearFraction();
                }
                case -1032770399: {
                    return ((GenericVolatilitySurfaceYearFractionParameterMetadata)bean).yearFractionTenor;
                }
                case -891985998: {
                    return ((GenericVolatilitySurfaceYearFractionParameterMetadata)bean).getStrike();
                }
                case 102727412: {
                    return ((GenericVolatilitySurfaceYearFractionParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

