/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ConstantRecoveryRates
implements RecoveryRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final StandardId legalEntityId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition
    private final double recoveryRate;
    private static final long serialVersionUID = 1L;

    public static ConstantRecoveryRates of(StandardId legalEntityId, LocalDate valuationDate, double recoveryRate) {
        return new ConstantRecoveryRates(legalEntityId, valuationDate, recoveryRate);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inRangeInclusive((double)this.recoveryRate, (double)0.0, (double)1.0, (String)"recoveryRate");
    }

    @Override
    public double recoveryRate(LocalDate date) {
        return this.recoveryRate;
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return Optional.empty();
    }

    public int getParameterCount() {
        return 1;
    }

    public double getParameter(int parameterIndex) {
        ArgChecker.isTrue((parameterIndex == 0 ? 1 : 0) != 0, (String)"Only one parameter for ConstantRecoveryRates");
        return this.recoveryRate;
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return ParameterMetadata.empty();
    }

    @Override
    public ConstantRecoveryRates withParameter(int parameterIndex, double newValue) {
        ArgChecker.isTrue((parameterIndex == 0 ? 1 : 0) != 0, (String)"Only one parameter for ConstantRecoveryRates");
        return new ConstantRecoveryRates(this.legalEntityId, this.valuationDate, newValue);
    }

    @Override
    public ConstantRecoveryRates withPerturbation(ParameterPerturbation perturbation) {
        double perturbedValue = perturbation.perturbParameter(0, this.recoveryRate, this.getParameterMetadata(0));
        return new ConstantRecoveryRates(this.legalEntityId, this.valuationDate, perturbedValue);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ConstantRecoveryRates(StandardId legalEntityId, LocalDate valuationDate, double recoveryRate) {
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
        this.legalEntityId = legalEntityId;
        this.valuationDate = valuationDate;
        this.recoveryRate = recoveryRate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public StandardId getLegalEntityId() {
        return this.legalEntityId;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public double getRecoveryRate() {
        return this.recoveryRate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ConstantRecoveryRates other = (ConstantRecoveryRates)obj;
            return JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((double)this.recoveryRate, (double)other.recoveryRate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.recoveryRate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ConstantRecoveryRates{");
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("recoveryRate").append('=').append(JodaBeanUtils.toString((Object)this.recoveryRate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ConstantRecoveryRates> {
        private StandardId legalEntityId;
        private LocalDate valuationDate;
        private double recoveryRate;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 2002873877: {
                    return this.recoveryRate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    this.legalEntityId = (StandardId)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case 2002873877: {
                    this.recoveryRate = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ConstantRecoveryRates build() {
            return new ConstantRecoveryRates(this.legalEntityId, this.valuationDate, this.recoveryRate);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ConstantRecoveryRates.Builder{");
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("recoveryRate").append('=').append(JodaBeanUtils.toString((Object)this.recoveryRate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<StandardId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", ConstantRecoveryRates.class, StandardId.class);
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", ConstantRecoveryRates.class, LocalDate.class);
        private final MetaProperty<Double> recoveryRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"recoveryRate", ConstantRecoveryRates.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"legalEntityId", "valuationDate", "recoveryRate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 2002873877: {
                    return this.recoveryRate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ConstantRecoveryRates> builder() {
            return new Builder();
        }

        public Class<? extends ConstantRecoveryRates> beanType() {
            return ConstantRecoveryRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<StandardId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<Double> recoveryRate() {
            return this.recoveryRate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return ((ConstantRecoveryRates)bean).getLegalEntityId();
                }
                case 113107279: {
                    return ((ConstantRecoveryRates)bean).getValuationDate();
                }
                case 2002873877: {
                    return ((ConstantRecoveryRates)bean).getRecoveryRate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

