/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CreditCurveZeroRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final StandardId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final ZeroRateSensitivity zeroRateSensitivity;
    private static final long serialVersionUID = 1L;

    public static CreditCurveZeroRateSensitivity of(StandardId legalEntityId, Currency currency, double yearFraction, double sensitivity) {
        ZeroRateSensitivity zeroRateSensitivity = ZeroRateSensitivity.of(currency, yearFraction, sensitivity);
        return new CreditCurveZeroRateSensitivity(legalEntityId, zeroRateSensitivity);
    }

    public static CreditCurveZeroRateSensitivity of(StandardId legalEntityId, Currency curveCurrency, double yearFraction, Currency sensitivityCurrency, double sensitivity) {
        ZeroRateSensitivity zeroRateSensitivity = ZeroRateSensitivity.of(curveCurrency, yearFraction, sensitivityCurrency, sensitivity);
        return new CreditCurveZeroRateSensitivity(legalEntityId, zeroRateSensitivity);
    }

    public static CreditCurveZeroRateSensitivity of(StandardId legalEntityId, ZeroRateSensitivity zeroRateSensitivity) {
        return new CreditCurveZeroRateSensitivity(legalEntityId, zeroRateSensitivity);
    }

    public Currency getCurrency() {
        return this.zeroRateSensitivity.getCurrency();
    }

    public double getSensitivity() {
        return this.zeroRateSensitivity.getSensitivity();
    }

    public Currency getCurveCurrency() {
        return this.zeroRateSensitivity.getCurveCurrency();
    }

    public double getYearFraction() {
        return this.zeroRateSensitivity.getYearFraction();
    }

    public CreditCurveZeroRateSensitivity withCurrency(Currency currency) {
        if (this.zeroRateSensitivity.getCurrency().equals((Object)currency)) {
            return this;
        }
        return new CreditCurveZeroRateSensitivity(this.legalEntityId, this.zeroRateSensitivity.withCurrency(currency));
    }

    public CreditCurveZeroRateSensitivity withSensitivity(double sensitivity) {
        return new CreditCurveZeroRateSensitivity(this.legalEntityId, this.zeroRateSensitivity.withSensitivity(sensitivity));
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof CreditCurveZeroRateSensitivity) {
            CreditCurveZeroRateSensitivity otherZero = (CreditCurveZeroRateSensitivity)other;
            return ComparisonChain.start().compare(this.zeroRateSensitivity.getYearFraction(), otherZero.zeroRateSensitivity.getYearFraction()).compare((Comparable)this.zeroRateSensitivity.getCurrency(), (Comparable)otherZero.zeroRateSensitivity.getCurrency()).compare((Comparable)this.zeroRateSensitivity.getCurveCurrency(), (Comparable)otherZero.zeroRateSensitivity.getCurveCurrency()).compare((Comparable)this.legalEntityId, (Comparable)otherZero.legalEntityId).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public CreditCurveZeroRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return new CreditCurveZeroRateSensitivity(this.legalEntityId, this.zeroRateSensitivity.convertedTo(resultCurrency, rateProvider));
    }

    public CreditCurveZeroRateSensitivity multipliedBy(double factor) {
        return new CreditCurveZeroRateSensitivity(this.legalEntityId, this.zeroRateSensitivity.multipliedBy(factor));
    }

    public CreditCurveZeroRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new CreditCurveZeroRateSensitivity(this.legalEntityId, this.zeroRateSensitivity.mapSensitivity(operator));
    }

    public CreditCurveZeroRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public CreditCurveZeroRateSensitivity cloned() {
        return this;
    }

    public ZeroRateSensitivity toZeroRateSensitivity() {
        return this.zeroRateSensitivity;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CreditCurveZeroRateSensitivity(StandardId legalEntityId, ZeroRateSensitivity zeroRateSensitivity) {
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)zeroRateSensitivity, (String)"zeroRateSensitivity");
        this.legalEntityId = legalEntityId;
        this.zeroRateSensitivity = zeroRateSensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public StandardId getLegalEntityId() {
        return this.legalEntityId;
    }

    public ZeroRateSensitivity getZeroRateSensitivity() {
        return this.zeroRateSensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CreditCurveZeroRateSensitivity other = (CreditCurveZeroRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.zeroRateSensitivity, (Object)other.zeroRateSensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.zeroRateSensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CreditCurveZeroRateSensitivity{");
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("zeroRateSensitivity").append('=').append(JodaBeanUtils.toString((Object)this.zeroRateSensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CreditCurveZeroRateSensitivity> {
        private StandardId legalEntityId;
        private ZeroRateSensitivity zeroRateSensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case 1232683479: {
                    return this.zeroRateSensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    this.legalEntityId = (StandardId)newValue;
                    break;
                }
                case 1232683479: {
                    this.zeroRateSensitivity = (ZeroRateSensitivity)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CreditCurveZeroRateSensitivity build() {
            return new CreditCurveZeroRateSensitivity(this.legalEntityId, this.zeroRateSensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CreditCurveZeroRateSensitivity.Builder{");
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("zeroRateSensitivity").append('=').append(JodaBeanUtils.toString((Object)this.zeroRateSensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<StandardId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", CreditCurveZeroRateSensitivity.class, StandardId.class);
        private final MetaProperty<ZeroRateSensitivity> zeroRateSensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"zeroRateSensitivity", CreditCurveZeroRateSensitivity.class, ZeroRateSensitivity.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"legalEntityId", "zeroRateSensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case 1232683479: {
                    return this.zeroRateSensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CreditCurveZeroRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends CreditCurveZeroRateSensitivity> beanType() {
            return CreditCurveZeroRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<StandardId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<ZeroRateSensitivity> zeroRateSensitivity() {
            return this.zeroRateSensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return ((CreditCurveZeroRateSensitivity)bean).getLegalEntityId();
                }
                case 1232683479: {
                    return ((CreditCurveZeroRateSensitivity)bean).getZeroRateSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

