/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.SpreadSensitivityCalculator;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class FiniteDifferenceSpreadSensitivityCalculator
extends SpreadSensitivityCalculator {
    public static final FiniteDifferenceSpreadSensitivityCalculator DEFAULT = new FiniteDifferenceSpreadSensitivityCalculator(AccrualOnDefaultFormula.ORIGINAL_ISDA, 1.0E-4);
    private final double bumpAmount;

    public FiniteDifferenceSpreadSensitivityCalculator(AccrualOnDefaultFormula formula, double bumpAmount) {
        super(formula);
        this.bumpAmount = ArgChecker.notZero((double)bumpAmount, (double)1.0E-10, (String)"bumpAmount");
    }

    @Override
    public CurrencyAmount parallelCs01(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds, CreditRatesProvider ratesProvider, ReferenceData refData) {
        this.checkCdsBucket(trade, bucketCds);
        ResolvedCds product = trade.getProduct();
        Currency currency = product.getCurrency();
        StandardId legalEntityId = product.getLegalEntityId();
        LocalDate valuationDate = ratesProvider.getValuationDate();
        ImmutableCreditRatesProvider immutableRatesProvider = ratesProvider.toImmutableCreditRatesProvider();
        int nBucket = bucketCds.size();
        DoubleArray impSp = this.impliedSpread(bucketCds, ratesProvider, refData);
        NodalCurve creditCurveBase = this.getCalibrator().calibrate(bucketCds, impSp, DoubleArray.filled((int)nBucket), CurveName.of((String)"baseImpliedCreditCurve"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
        Pair lePair = Pair.of((Object)legalEntityId, (Object)currency);
        IsdaCreditDiscountFactors df = IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurveBase);
        ImmutableCreditRatesProvider ratesProviderBase = immutableRatesProvider.toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)lePair, (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, df))).build();
        CurrencyAmount pvBase = this.getPricer().presentValueOnSettle(trade, ratesProviderBase, PriceType.DIRTY, refData);
        DoubleArray bumpedSp = DoubleArray.of((int)nBucket, i -> impSp.get(i) + this.bumpAmount);
        NodalCurve creditCurveBump = this.getCalibrator().calibrate(bucketCds, bumpedSp, DoubleArray.filled((int)nBucket), CurveName.of((String)"bumpedImpliedCreditCurve"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
        IsdaCreditDiscountFactors dfBump = IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurveBump);
        ImmutableCreditRatesProvider ratesProviderBump = immutableRatesProvider.toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)lePair, (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, dfBump))).build();
        CurrencyAmount pvBumped = this.getPricer().presentValueOnSettle(trade, ratesProviderBump, PriceType.DIRTY, refData);
        return CurrencyAmount.of((Currency)currency, (double)((pvBumped.getAmount() - pvBase.getAmount()) / this.bumpAmount));
    }

    @Override
    DoubleArray computedBucketedCs01(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds, CreditRatesProvider ratesProvider, ReferenceData refData) {
        this.checkCdsBucket(trade, bucketCds);
        ResolvedCds product = trade.getProduct();
        Currency currency = product.getCurrency();
        StandardId legalEntityId = product.getLegalEntityId();
        LocalDate valuationDate = ratesProvider.getValuationDate();
        ImmutableCreditRatesProvider immutableRatesProvider = ratesProvider.toImmutableCreditRatesProvider();
        int nBucket = bucketCds.size();
        double[] res = new double[nBucket];
        DoubleArray impSp = this.impliedSpread(bucketCds, ratesProvider, refData);
        NodalCurve creditCurveBase = this.getCalibrator().calibrate(bucketCds, impSp, DoubleArray.filled((int)nBucket), CurveName.of((String)"baseImpliedCreditCurve"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
        Pair lePair = Pair.of((Object)legalEntityId, (Object)currency);
        IsdaCreditDiscountFactors df = IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurveBase);
        ImmutableCreditRatesProvider ratesProviderBase = immutableRatesProvider.toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)lePair, (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, df))).build();
        double pvBase = this.getPricer().presentValueOnSettle(trade, ratesProviderBase, PriceType.DIRTY, refData).getAmount();
        for (int i = 0; i < nBucket; ++i) {
            double[] bumpedSp = impSp.toArray();
            int n = i;
            bumpedSp[n] = bumpedSp[n] + this.bumpAmount;
            NodalCurve creditCurveBump = this.getCalibrator().calibrate(bucketCds, DoubleArray.ofUnsafe((double[])bumpedSp), DoubleArray.filled((int)nBucket), CurveName.of((String)"bumpedImpliedCreditCurve"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
            IsdaCreditDiscountFactors dfBump = IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurveBump);
            ImmutableCreditRatesProvider ratesProviderBump = immutableRatesProvider.toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)lePair, (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, dfBump))).build();
            double pvBumped = this.getPricer().presentValueOnSettle(trade, ratesProviderBump, PriceType.DIRTY, refData).getAmount();
            res[i] = (pvBumped - pvBase) / this.bumpAmount;
        }
        return DoubleArray.ofUnsafe((double[])res);
    }
}

