/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableCreditRatesProvider
implements CreditRatesProvider,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities> creditCurves;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableMap<Currency, CreditDiscountFactors> discountCurves;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableMap<StandardId, RecoveryRates> recoveryRateCurves;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        for (Map.Entry entry : this.creditCurves.entrySet()) {
            if (((LegalEntitySurvivalProbabilities)entry.getValue()).getValuationDate().isEqual(this.valuationDate)) continue;
            throw new IllegalArgumentException("Invalid valuation date for the credit curve: " + entry.getValue());
        }
        for (Map.Entry entry : this.discountCurves.entrySet()) {
            if (((CreditDiscountFactors)entry.getValue()).getValuationDate().isEqual(this.valuationDate)) continue;
            throw new IllegalArgumentException("Invalid valuation date for the discount curve: " + entry.getValue());
        }
        for (Map.Entry entry : this.recoveryRateCurves.entrySet()) {
            if (((RecoveryRates)entry.getValue()).getValuationDate().isEqual(this.valuationDate)) continue;
            throw new IllegalArgumentException("Invalid valuation date for the recovery rate curve: " + entry.getValue());
        }
    }

    @Override
    public LegalEntitySurvivalProbabilities survivalProbabilities(StandardId legalEntityId, Currency currency) {
        LegalEntitySurvivalProbabilities survivalProbabilities = (LegalEntitySurvivalProbabilities)this.creditCurves.get((Object)Pair.of((Object)legalEntityId, (Object)currency));
        if (survivalProbabilities == null) {
            throw new IllegalArgumentException("Unable to find credit curve: " + legalEntityId + ", " + currency);
        }
        return survivalProbabilities;
    }

    @Override
    public CreditDiscountFactors discountFactors(Currency currency) {
        CreditDiscountFactors discountFactors = (CreditDiscountFactors)this.discountCurves.get((Object)currency);
        if (discountFactors == null) {
            throw new IllegalArgumentException("Unable to find discount curve: " + currency);
        }
        return discountFactors;
    }

    @Override
    public RecoveryRates recoveryRates(StandardId legalEntityId) {
        RecoveryRates recoveryRates = (RecoveryRates)this.recoveryRateCurves.get((Object)legalEntityId);
        if (recoveryRates == null) {
            throw new IllegalArgumentException("Unable to find recovery rate curve: " + legalEntityId);
        }
        return recoveryRates;
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            Object factors;
            PointSensitivityBuilder pt;
            if (point instanceof CreditCurveZeroRateSensitivity) {
                pt = (CreditCurveZeroRateSensitivity)point;
                factors = this.survivalProbabilities(pt.getLegalEntityId(), pt.getCurveCurrency());
                sens = sens.combinedWith(((LegalEntitySurvivalProbabilities)factors).parameterSensitivity((CreditCurveZeroRateSensitivity)pt));
                continue;
            }
            if (!(point instanceof ZeroRateSensitivity)) continue;
            pt = (ZeroRateSensitivity)point;
            factors = this.discountFactors(pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity((ZeroRateSensitivity)pt));
        }
        return sens;
    }

    @Override
    public CurrencyParameterSensitivity singleCreditCurveParameterSensitivity(PointSensitivities pointSensitivities, StandardId legalEntityId, Currency currency) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            CreditCurveZeroRateSensitivity pt;
            if (!(point instanceof CreditCurveZeroRateSensitivity) || !(pt = (CreditCurveZeroRateSensitivity)point).getLegalEntityId().equals((Object)legalEntityId) || !pt.getCurrency().equals((Object)currency)) continue;
            LegalEntitySurvivalProbabilities factors = this.survivalProbabilities(pt.getLegalEntityId(), pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity(pt));
        }
        ArgChecker.isTrue((sens.size() == 1 ? 1 : 0) != 0, (String)"sensitivity must be unique");
        return (CurrencyParameterSensitivity)sens.getSensitivities().get(0);
    }

    @Override
    public CurrencyParameterSensitivity singleDiscountCurveParameterSensitivity(PointSensitivities pointSensitivities, Currency currency) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            ZeroRateSensitivity pt;
            if (!(point instanceof ZeroRateSensitivity) || !(pt = (ZeroRateSensitivity)point).getCurveCurrency().equals((Object)currency)) continue;
            CreditDiscountFactors factors = this.discountFactors(pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity(pt));
        }
        ArgChecker.isTrue((sens.size() == 1 ? 1 : 0) != 0, (String)"sensitivity must be unique");
        return (CurrencyParameterSensitivity)sens.getSensitivities().get(0);
    }

    @Override
    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (name instanceof CurveName) {
            return Stream.concat(this.discountCurves.values().stream(), this.creditCurves.values().stream().map(cc -> cc.getSurvivalProbabilities())).map(df -> df.findData(name)).filter(op -> op.isPresent()).map(op -> op.get()).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public ImmutableCreditRatesProvider toImmutableCreditRatesProvider() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableCreditRatesProvider(LocalDate valuationDate, Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities> creditCurves, Map<Currency, CreditDiscountFactors> discountCurves, Map<StandardId, RecoveryRates> recoveryRateCurves) {
        JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
        JodaBeanUtils.notNull(creditCurves, (String)"creditCurves");
        JodaBeanUtils.notEmpty(discountCurves, (String)"discountCurves");
        JodaBeanUtils.notEmpty(recoveryRateCurves, (String)"recoveryRateCurves");
        this.valuationDate = valuationDate;
        this.creditCurves = ImmutableMap.copyOf(creditCurves);
        this.discountCurves = ImmutableMap.copyOf(discountCurves);
        this.recoveryRateCurves = ImmutableMap.copyOf(recoveryRateCurves);
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public ImmutableMap<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities> getCreditCurves() {
        return this.creditCurves;
    }

    public ImmutableMap<Currency, CreditDiscountFactors> getDiscountCurves() {
        return this.discountCurves;
    }

    public ImmutableMap<StandardId, RecoveryRates> getRecoveryRateCurves() {
        return this.recoveryRateCurves;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableCreditRatesProvider other = (ImmutableCreditRatesProvider)obj;
            return JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal(this.creditCurves, other.creditCurves) && JodaBeanUtils.equal(this.discountCurves, other.discountCurves) && JodaBeanUtils.equal(this.recoveryRateCurves, other.recoveryRateCurves);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.creditCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.discountCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.recoveryRateCurves);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ImmutableCreditRatesProvider{");
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("creditCurves").append('=').append(JodaBeanUtils.toString(this.creditCurves)).append(',').append(' ');
        buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
        buf.append("recoveryRateCurves").append('=').append(JodaBeanUtils.toString(this.recoveryRateCurves));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableCreditRatesProvider> {
        private LocalDate valuationDate;
        private Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities> creditCurves = ImmutableMap.of();
        private Map<Currency, CreditDiscountFactors> discountCurves = ImmutableMap.of();
        private Map<StandardId, RecoveryRates> recoveryRateCurves = ImmutableMap.of();

        private Builder() {
        }

        private Builder(ImmutableCreditRatesProvider beanToCopy) {
            this.valuationDate = beanToCopy.getValuationDate();
            this.creditCurves = beanToCopy.getCreditCurves();
            this.discountCurves = beanToCopy.getDiscountCurves();
            this.recoveryRateCurves = beanToCopy.getRecoveryRateCurves();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -1612130883: {
                    return this.creditCurves;
                }
                case -624113147: {
                    return this.discountCurves;
                }
                case 1744098265: {
                    return this.recoveryRateCurves;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case -1612130883: {
                    this.creditCurves = (Map)newValue;
                    break;
                }
                case -624113147: {
                    this.discountCurves = (Map)newValue;
                    break;
                }
                case 1744098265: {
                    this.recoveryRateCurves = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableCreditRatesProvider build() {
            return new ImmutableCreditRatesProvider(this.valuationDate, this.creditCurves, this.discountCurves, this.recoveryRateCurves);
        }

        public Builder valuationDate(LocalDate valuationDate) {
            JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
            this.valuationDate = valuationDate;
            return this;
        }

        public Builder creditCurves(Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities> creditCurves) {
            JodaBeanUtils.notNull(creditCurves, (String)"creditCurves");
            this.creditCurves = creditCurves;
            return this;
        }

        public Builder discountCurves(Map<Currency, CreditDiscountFactors> discountCurves) {
            JodaBeanUtils.notEmpty(discountCurves, (String)"discountCurves");
            this.discountCurves = discountCurves;
            return this;
        }

        public Builder recoveryRateCurves(Map<StandardId, RecoveryRates> recoveryRateCurves) {
            JodaBeanUtils.notEmpty(recoveryRateCurves, (String)"recoveryRateCurves");
            this.recoveryRateCurves = recoveryRateCurves;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableCreditRatesProvider.Builder{");
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("creditCurves").append('=').append(JodaBeanUtils.toString(this.creditCurves)).append(',').append(' ');
            buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
            buf.append("recoveryRateCurves").append('=').append(JodaBeanUtils.toString(this.recoveryRateCurves));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", ImmutableCreditRatesProvider.class, LocalDate.class);
        private final MetaProperty<ImmutableMap<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>> creditCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"creditCurves", ImmutableCreditRatesProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Currency, CreditDiscountFactors>> discountCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountCurves", ImmutableCreditRatesProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<StandardId, RecoveryRates>> recoveryRateCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"recoveryRateCurves", ImmutableCreditRatesProvider.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"valuationDate", "creditCurves", "discountCurves", "recoveryRateCurves"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -1612130883: {
                    return this.creditCurves;
                }
                case -624113147: {
                    return this.discountCurves;
                }
                case 1744098265: {
                    return this.recoveryRateCurves;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableCreditRatesProvider> beanType() {
            return ImmutableCreditRatesProvider.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<ImmutableMap<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>> creditCurves() {
            return this.creditCurves;
        }

        public MetaProperty<ImmutableMap<Currency, CreditDiscountFactors>> discountCurves() {
            return this.discountCurves;
        }

        public MetaProperty<ImmutableMap<StandardId, RecoveryRates>> recoveryRateCurves() {
            return this.recoveryRateCurves;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return ((ImmutableCreditRatesProvider)bean).getValuationDate();
                }
                case -1612130883: {
                    return ((ImmutableCreditRatesProvider)bean).getCreditCurves();
                }
                case -624113147: {
                    return ((ImmutableCreditRatesProvider)bean).getDiscountCurves();
                }
                case 1744098265: {
                    return ((ImmutableCreditRatesProvider)bean).getRecoveryRateCurves();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

