/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCdsProductPricer;
import com.opengamma.strata.pricer.credit.JumpToDefault;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.time.LocalDate;

public class IsdaCdsTradePricer {
    public static final IsdaCdsTradePricer DEFAULT = new IsdaCdsTradePricer();
    private final IsdaCdsProductPricer productPricer;
    private final DiscountingPaymentPricer upfrontPricer;

    public IsdaCdsTradePricer() {
        this.productPricer = IsdaCdsProductPricer.DEFAULT;
        this.upfrontPricer = DiscountingPaymentPricer.DEFAULT;
    }

    public IsdaCdsTradePricer(AccrualOnDefaultFormula formula) {
        this.productPricer = new IsdaCdsProductPricer(formula);
        this.upfrontPricer = DiscountingPaymentPricer.DEFAULT;
    }

    public AccrualOnDefaultFormula getAccrualOnDefaultFormula() {
        return this.productPricer.getAccrualOnDefaultFormula();
    }

    public double price(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        return this.price(trade, ratesProvider, trade.getProduct().getFixedRate(), priceType, refData);
    }

    double price(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, double fractionalSpread, PriceType priceType, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.price(trade.getProduct(), ratesProvider, fractionalSpread, settlementDate, priceType, refData);
    }

    public PointSensitivities priceSensitivity(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider, settlementDate, refData).build();
    }

    public double parSpread(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.parSpread(trade.getProduct(), ratesProvider, settlementDate, refData);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), ratesProvider, settlementDate, refData).build();
    }

    public CurrencyAmount presentValue(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        CurrencyAmount pvProduct = this.productPricer.presentValue(trade.getProduct(), ratesProvider, ratesProvider.getValuationDate(), priceType, refData);
        if (!trade.getUpfrontFee().isPresent()) {
            return pvProduct;
        }
        Payment upfront = (Payment)trade.getUpfrontFee().get();
        CurrencyAmount pvUpfront = this.upfrontPricer.presentValue(upfront, ratesProvider.discountFactors(upfront.getCurrency()).toDiscountFactors());
        return pvProduct.plus(pvUpfront);
    }

    public PointSensitivities presentValueSensitivity(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivityBuilder pvSensiProduct = this.productPricer.presentValueSensitivity(trade.getProduct(), ratesProvider, ratesProvider.getValuationDate(), refData);
        if (!trade.getUpfrontFee().isPresent()) {
            return pvSensiProduct.build();
        }
        Payment upfront = (Payment)trade.getUpfrontFee().get();
        PointSensitivityBuilder pvUpfront = this.upfrontPricer.presentValueSensitivity(upfront, ratesProvider.discountFactors(upfront.getCurrency()).toDiscountFactors());
        return pvSensiProduct.combinedWith(pvUpfront).build();
    }

    public CurrencyAmount presentValueOnSettle(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.presentValue(trade.getProduct(), ratesProvider, settlementDate, priceType, refData);
    }

    public PointSensitivities presentValueOnSettleSensitivity(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.presentValueSensitivity(trade.getProduct(), ratesProvider, settlementDate, refData).build();
    }

    public CurrencyAmount rpv01OnSettle(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.rpv01(trade.getProduct(), ratesProvider, settlementDate, priceType, refData);
    }

    public CurrencyAmount recovery01OnSettle(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.recovery01(trade.getProduct(), ratesProvider, settlementDate, refData);
    }

    public JumpToDefault jumpToDefault(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.jumpToDefault(trade.getProduct(), ratesProvider, settlementDate, refData);
    }

    public CurrencyAmount expectedLoss(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider) {
        return this.productPricer.expectedLoss(trade.getProduct(), ratesProvider);
    }

    private LocalDate calculateSettlementDate(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return trade.getInfo().getSettlementDate().orElse(trade.getProduct().calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData));
    }
}

