/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveParameterSize;
import com.opengamma.strata.market.curve.IsdaCreditCurveDefinition;
import com.opengamma.strata.market.curve.JacobianCalibrationMatrix;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.node.CdsIsdaCreditCurveNode;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ResolvedTradeParameterMetadata;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.ArbitrageHandling;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCdsTradePricer;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.credit.CdsCalibrationTrade;
import com.opengamma.strata.product.credit.CdsQuote;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import com.opengamma.strata.product.credit.type.CdsQuoteConvention;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class IsdaCompliantCreditCurveCalibrator {
    private static final ArbitrageHandling DEFAULT_ARBITRAGE_HANDLING = ArbitrageHandling.IGNORE;
    private static final AccrualOnDefaultFormula DEFAULT_FORMULA = AccrualOnDefaultFormula.ORIGINAL_ISDA;
    private static final MatrixAlgebra MATRIX_ALGEBRA = new CommonsMatrixAlgebra();
    private final ArbitrageHandling arbHandling;
    private final AccrualOnDefaultFormula formula;
    private final IsdaCdsTradePricer tradePricer;

    protected IsdaCompliantCreditCurveCalibrator() {
        this(DEFAULT_FORMULA, DEFAULT_ARBITRAGE_HANDLING);
    }

    protected IsdaCompliantCreditCurveCalibrator(AccrualOnDefaultFormula formula) {
        this(formula, DEFAULT_ARBITRAGE_HANDLING);
    }

    protected IsdaCompliantCreditCurveCalibrator(AccrualOnDefaultFormula formula, ArbitrageHandling arbHandling) {
        this.arbHandling = (ArbitrageHandling)((Object)ArgChecker.notNull((Object)((Object)arbHandling), (String)"arbHandling"));
        this.formula = (AccrualOnDefaultFormula)((Object)ArgChecker.notNull((Object)((Object)formula), (String)"formula"));
        this.tradePricer = new IsdaCdsTradePricer(formula);
    }

    protected ArbitrageHandling getArbitrageHandling() {
        return this.arbHandling;
    }

    protected AccrualOnDefaultFormula getAccrualOnDefaultFormula() {
        return this.formula;
    }

    protected IsdaCdsTradePricer getTradePricer() {
        return this.tradePricer;
    }

    public LegalEntitySurvivalProbabilities calibrate(IsdaCreditCurveDefinition curveDefinition, MarketData marketData, ImmutableCreditRatesProvider ratesProvider, ReferenceData refData) {
        ArgChecker.isTrue((boolean)curveDefinition.getCurveValuationDate().equals(ratesProvider.getValuationDate()), (String)"ratesProvider and curveDefinition must be based on the same valuation date");
        ImmutableList curveNodes = (ImmutableList)curveDefinition.getCurveNodes().stream().filter(n -> n instanceof CdsIsdaCreditCurveNode).map(n -> (CdsIsdaCreditCurveNode)n).collect(Guavate.toImmutableList());
        return this.calibrate((List<CdsIsdaCreditCurveNode>)curveNodes, curveDefinition.getName(), marketData, ratesProvider, curveDefinition.getDayCount(), curveDefinition.getCurrency(), curveDefinition.isComputeJacobian(), curveDefinition.isStoreNodeTrade(), refData);
    }

    LegalEntitySurvivalProbabilities calibrate(List<CdsIsdaCreditCurveNode> curveNodes, CurveName name, MarketData marketData, ImmutableCreditRatesProvider ratesProvider, DayCount definitionDayCount, Currency definitionCurrency, boolean computeJacobian, boolean storeTrade, ReferenceData refData) {
        Iterator legalEntities = curveNodes.stream().map(CdsIsdaCreditCurveNode::getLegalEntityId).collect(Collectors.toSet()).iterator();
        StandardId legalEntityId = (StandardId)legalEntities.next();
        ArgChecker.isFalse((boolean)legalEntities.hasNext(), (String)"legal entity must be common to curve nodes");
        Iterator currencies = curveNodes.stream().map(n -> n.getTemplate().getConvention().getCurrency()).collect(Collectors.toSet()).iterator();
        Currency currency = (Currency)currencies.next();
        ArgChecker.isFalse((boolean)currencies.hasNext(), (String)"currency must be common to curve nodes");
        ArgChecker.isTrue((boolean)definitionCurrency.equals((Object)currency), (String)"curve definition currency must be the same as the currency of CDS");
        Iterator quoteConventions = curveNodes.stream().map(n -> n.getQuoteConvention()).collect(Collectors.toSet()).iterator();
        CdsQuoteConvention quoteConvention = (CdsQuoteConvention)quoteConventions.next();
        ArgChecker.isFalse((boolean)quoteConventions.hasNext(), (String)"quote convention must be common to curve nodes");
        LocalDate valuationDate = marketData.getValuationDate();
        ArgChecker.isTrue((boolean)valuationDate.equals(marketData.getValuationDate()), (String)"ratesProvider and marketDate must be based on the same valuation date");
        CreditDiscountFactors discountFactors = ratesProvider.discountFactors(currency);
        ArgChecker.isTrue((boolean)definitionDayCount.equals(discountFactors.getDayCount()), (String)"credit curve and discount curve must be based on the same day count convention");
        RecoveryRates recoveryRates = ratesProvider.recoveryRates(legalEntityId);
        int nNodes = curveNodes.size();
        double[] coupons = new double[nNodes];
        double[] pufs = new double[nNodes];
        double[][] diag = new double[nNodes][nNodes];
        ImmutableList.Builder tradesBuilder = ImmutableList.builder();
        for (int i2 = 0; i2 < nNodes; ++i2) {
            CdsCalibrationTrade tradeCalibration = curveNodes.get(i2).trade(1.0, marketData, refData);
            ResolvedCdsTrade trade = tradeCalibration.getUnderlyingTrade().resolve(refData);
            tradesBuilder.add((Object)trade);
            double[] temp = this.getStandardQuoteForm(trade, tradeCalibration.getQuote(), valuationDate, discountFactors, recoveryRates, computeJacobian, refData);
            coupons[i2] = temp[0];
            pufs[i2] = temp[1];
            diag[i2][i2] = temp[2];
        }
        ImmutableList trades = tradesBuilder.build();
        NodalCurve nodalCurve = this.calibrate((List<ResolvedCdsTrade>)trades, DoubleArray.ofUnsafe((double[])coupons), DoubleArray.ofUnsafe((double[])pufs), name, valuationDate, discountFactors, recoveryRates, refData);
        if (computeJacobian) {
            LegalEntitySurvivalProbabilities creditCurve = LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, nodalCurve));
            ImmutableCreditRatesProvider ratesProviderNew = ratesProvider.toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)Pair.of((Object)legalEntityId, (Object)currency), (Object)creditCurve)).build();
            Function<ResolvedCdsTrade, DoubleArray> sensiFunc = quoteConvention.equals((Object)CdsQuoteConvention.PAR_SPREAD) ? this.getParSpreadSensitivityFunction(ratesProviderNew, name, currency, refData) : this.getPointsUpfrontSensitivityFunction(ratesProviderNew, name, currency, refData);
            DoubleMatrix sensi = DoubleMatrix.ofArrayObjects((int)nNodes, (int)nNodes, i -> (DoubleArray)sensiFunc.apply((ResolvedCdsTrade)trades.get(i)));
            sensi = (DoubleMatrix)MATRIX_ALGEBRA.multiply((Matrix)DoubleMatrix.ofUnsafe((double[][])diag), (Matrix)sensi);
            JacobianCalibrationMatrix jacobian = JacobianCalibrationMatrix.of((List)ImmutableList.of((Object)CurveParameterSize.of((CurveName)name, (int)nNodes)), (DoubleMatrix)MATRIX_ALGEBRA.getInverse((Matrix)sensi));
            nodalCurve = nodalCurve.withMetadata((CurveMetadata)nodalCurve.getMetadata().withInfo(CurveInfoType.JACOBIAN, (Object)jacobian));
        }
        ImmutableList parameterMetadata = storeTrade ? (ImmutableList)IntStream.range(0, nNodes).mapToObj(n -> ResolvedTradeParameterMetadata.of((ResolvedTrade)((ResolvedTrade)trades.get(n)), (String)((CdsIsdaCreditCurveNode)curveNodes.get(n)).getLabel())).collect(Guavate.toImmutableList()) : (ImmutableList)IntStream.range(0, nNodes).mapToObj(n -> ((CdsIsdaCreditCurveNode)curveNodes.get(n)).metadata(((ResolvedCdsTrade)trades.get(n)).getProduct().getProtectionEndDate())).collect(Guavate.toImmutableList());
        nodalCurve = nodalCurve.withMetadata(nodalCurve.getMetadata().withParameterMetadata((List)parameterMetadata));
        return LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, nodalCurve));
    }

    private Function<ResolvedCdsTrade, DoubleArray> getPointsUpfrontSensitivityFunction(final CreditRatesProvider ratesProvider, final CurveName curveName, final Currency currency, final ReferenceData refData) {
        Function<ResolvedCdsTrade, DoubleArray> func = new Function<ResolvedCdsTrade, DoubleArray>(){

            @Override
            public DoubleArray apply(ResolvedCdsTrade trade) {
                PointSensitivities point = IsdaCompliantCreditCurveCalibrator.this.tradePricer.priceSensitivity(trade, ratesProvider, refData);
                return ratesProvider.parameterSensitivity(point).getSensitivity((MarketDataName)curveName, currency).getSensitivity();
            }
        };
        return func;
    }

    private Function<ResolvedCdsTrade, DoubleArray> getParSpreadSensitivityFunction(final CreditRatesProvider ratesProvider, final CurveName curveName, final Currency currency, final ReferenceData refData) {
        Function<ResolvedCdsTrade, DoubleArray> func = new Function<ResolvedCdsTrade, DoubleArray>(){

            @Override
            public DoubleArray apply(ResolvedCdsTrade trade) {
                PointSensitivities point = IsdaCompliantCreditCurveCalibrator.this.tradePricer.parSpreadSensitivity(trade, ratesProvider, refData);
                return ratesProvider.parameterSensitivity(point).getSensitivity((MarketDataName)curveName, currency).getSensitivity();
            }
        };
        return func;
    }

    public abstract NodalCurve calibrate(List<ResolvedCdsTrade> var1, DoubleArray var2, DoubleArray var3, CurveName var4, LocalDate var5, CreditDiscountFactors var6, RecoveryRates var7, ReferenceData var8);

    private double[] getStandardQuoteForm(ResolvedCdsTrade calibrationCds, CdsQuote marketQuote, LocalDate valuationDate, CreditDiscountFactors discountFactors, RecoveryRates recoveryRates, boolean computeJacobian, ReferenceData refData) {
        double[] res = new double[3];
        res[2] = 1.0;
        if (marketQuote.getQuoteConvention().equals((Object)CdsQuoteConvention.PAR_SPREAD)) {
            res[0] = marketQuote.getQuotedValue();
        } else if (marketQuote.getQuoteConvention().equals((Object)CdsQuoteConvention.QUOTED_SPREAD)) {
            double qSpread = marketQuote.getQuotedValue();
            CurveName curveName = CurveName.of((String)"quoteConvertCurve");
            NodalCurve tempCreditCurve = this.calibrate((List<ResolvedCdsTrade>)ImmutableList.of((Object)calibrationCds), DoubleArray.of((double)qSpread), DoubleArray.of((double)0.0), curveName, valuationDate, discountFactors, recoveryRates, refData);
            Currency currency = calibrationCds.getProduct().getCurrency();
            StandardId legalEntityId = calibrationCds.getProduct().getLegalEntityId();
            ImmutableCreditRatesProvider rates = ImmutableCreditRatesProvider.builder().valuationDate(valuationDate).discountCurves((Map<Currency, CreditDiscountFactors>)ImmutableMap.of((Object)currency, (Object)discountFactors)).recoveryRateCurves((Map<StandardId, RecoveryRates>)ImmutableMap.of((Object)legalEntityId, (Object)recoveryRates)).creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)Pair.of((Object)legalEntityId, (Object)currency), (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, tempCreditCurve)))).build();
            res[0] = calibrationCds.getProduct().getFixedRate();
            res[1] = this.tradePricer.price(calibrationCds, rates, PriceType.CLEAN, refData);
            if (computeJacobian) {
                CurrencyParameterSensitivities pufSensi = rates.parameterSensitivity(this.tradePricer.priceSensitivity(calibrationCds, rates, refData));
                CurrencyParameterSensitivities spSensi = rates.parameterSensitivity(this.tradePricer.parSpreadSensitivity(calibrationCds, rates, refData));
                res[2] = spSensi.getSensitivity((MarketDataName)curveName, currency).getSensitivity().get(0) / pufSensi.getSensitivity((MarketDataName)curveName, currency).getSensitivity().get(0);
            }
        } else if (marketQuote.getQuoteConvention().equals((Object)CdsQuoteConvention.POINTS_UPFRONT)) {
            res[0] = calibrationCds.getProduct().getFixedRate();
            res[1] = marketQuote.getQuotedValue();
        } else {
            throw new IllegalArgumentException("Unknown CDSQuoteConvention type " + marketQuote.getClass());
        }
        return res;
    }
}

