/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class LegalEntitySurvivalProbabilities
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final StandardId legalEntityId;
    @PropertyDefinition(validate="notNull")
    private final CreditDiscountFactors survivalProbabilities;
    private static final long serialVersionUID = 1L;

    public static LegalEntitySurvivalProbabilities of(StandardId legalEntityId, CreditDiscountFactors survivalProbabilities) {
        return new LegalEntitySurvivalProbabilities(legalEntityId, survivalProbabilities);
    }

    public Currency getCurrency() {
        return this.survivalProbabilities.getCurrency();
    }

    public LocalDate getValuationDate() {
        return this.survivalProbabilities.getValuationDate();
    }

    public DoubleArray getParameterKeys() {
        return this.survivalProbabilities.getParameterKeys();
    }

    public double survivalProbability(LocalDate date) {
        return this.survivalProbabilities.discountFactor(date);
    }

    public double zeroRate(double yearFraction) {
        return this.survivalProbabilities.zeroRate(yearFraction);
    }

    public CreditCurveZeroRateSensitivity zeroRatePointSensitivity(LocalDate date) {
        return this.zeroRatePointSensitivity(date, this.getCurrency());
    }

    public CreditCurveZeroRateSensitivity zeroRatePointSensitivity(double yearFraction) {
        return this.zeroRatePointSensitivity(yearFraction, this.getCurrency());
    }

    public CreditCurveZeroRateSensitivity zeroRatePointSensitivity(LocalDate date, Currency sensitivityCurrency) {
        ZeroRateSensitivity zeroRateSensitivity = this.survivalProbabilities.zeroRatePointSensitivity(date, sensitivityCurrency);
        return CreditCurveZeroRateSensitivity.of(this.legalEntityId, zeroRateSensitivity);
    }

    public CreditCurveZeroRateSensitivity zeroRatePointSensitivity(double yearFraction, Currency sensitivityCurrency) {
        ZeroRateSensitivity zeroRateSensitivity = this.survivalProbabilities.zeroRatePointSensitivity(yearFraction, sensitivityCurrency);
        return CreditCurveZeroRateSensitivity.of(this.legalEntityId, zeroRateSensitivity);
    }

    public CurrencyParameterSensitivities parameterSensitivity(CreditCurveZeroRateSensitivity pointSensitivity) {
        return this.survivalProbabilities.parameterSensitivity(pointSensitivity.toZeroRateSensitivity());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private LegalEntitySurvivalProbabilities(StandardId legalEntityId, CreditDiscountFactors survivalProbabilities) {
        JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
        JodaBeanUtils.notNull((Object)survivalProbabilities, (String)"survivalProbabilities");
        this.legalEntityId = legalEntityId;
        this.survivalProbabilities = survivalProbabilities;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public StandardId getLegalEntityId() {
        return this.legalEntityId;
    }

    public CreditDiscountFactors getSurvivalProbabilities() {
        return this.survivalProbabilities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            LegalEntitySurvivalProbabilities other = (LegalEntitySurvivalProbabilities)obj;
            return JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.survivalProbabilities, (Object)other.survivalProbabilities);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.survivalProbabilities);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("LegalEntitySurvivalProbabilities{");
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("survivalProbabilities").append('=').append(JodaBeanUtils.toString((Object)this.survivalProbabilities));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<LegalEntitySurvivalProbabilities> {
        private StandardId legalEntityId;
        private CreditDiscountFactors survivalProbabilities;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case -2020275979: {
                    return this.survivalProbabilities;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    this.legalEntityId = (StandardId)newValue;
                    break;
                }
                case -2020275979: {
                    this.survivalProbabilities = (CreditDiscountFactors)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public LegalEntitySurvivalProbabilities build() {
            return new LegalEntitySurvivalProbabilities(this.legalEntityId, this.survivalProbabilities);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("LegalEntitySurvivalProbabilities.Builder{");
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("survivalProbabilities").append('=').append(JodaBeanUtils.toString((Object)this.survivalProbabilities));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<StandardId> legalEntityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityId", LegalEntitySurvivalProbabilities.class, StandardId.class);
        private final MetaProperty<CreditDiscountFactors> survivalProbabilities = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"survivalProbabilities", LegalEntitySurvivalProbabilities.class, CreditDiscountFactors.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"legalEntityId", "survivalProbabilities"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case -2020275979: {
                    return this.survivalProbabilities;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends LegalEntitySurvivalProbabilities> builder() {
            return new Builder();
        }

        public Class<? extends LegalEntitySurvivalProbabilities> beanType() {
            return LegalEntitySurvivalProbabilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<StandardId> legalEntityId() {
            return this.legalEntityId;
        }

        public MetaProperty<CreditDiscountFactors> survivalProbabilities() {
            return this.survivalProbabilities;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return ((LegalEntitySurvivalProbabilities)bean).getLegalEntityId();
                }
                case -2020275979: {
                    return ((LegalEntitySurvivalProbabilities)bean).getSurvivalProbabilities();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

