/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal")
public final class NodalRecoveryRates
implements RecoveryRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final StandardId legalEntityId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final NodalCurve curve;
    private final transient DayCount dayCount;
    private static final TypedMetaBean<NodalRecoveryRates> META_BEAN = MinimalMetaBean.of(NodalRecoveryRates.class, (String[])new String[]{"legalEntityId", "valuationDate", "curve"}, () -> new Builder(), (Function[])new Function[]{b -> b.getLegalEntityId(), b -> b.getValuationDate(), b -> b.getCurve()});
    private static final long serialVersionUID = 1L;

    public static NodalRecoveryRates of(StandardId legalEntityId, LocalDate valuationDate, NodalCurve curve) {
        return new NodalRecoveryRates(legalEntityId, valuationDate, curve);
    }

    @ImmutableConstructor
    private NodalRecoveryRates(StandardId legalEntityId, LocalDate valuationDate, NodalCurve curve) {
        ArgChecker.notNull((Object)legalEntityId, (String)"legalEntityId");
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        ArgChecker.notNull((Object)curve, (String)"curve");
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for recovery rate curve");
        curve.getMetadata().getYValueType().checkEquals(ValueType.RECOVERY_RATE, "Incorrect y-value type for recovery rate curve");
        DayCount dayCount = (DayCount)curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        this.legalEntityId = legalEntityId;
        this.valuationDate = valuationDate;
        this.curve = curve;
        this.dayCount = dayCount;
    }

    @Override
    public double recoveryRate(LocalDate date) {
        double yearFraction = this.dayCount.relativeYearFraction(this.valuationDate, date);
        return this.curve.yValue(yearFraction);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    @Override
    public NodalRecoveryRates withParameter(int parameterIndex, double newValue) {
        return this.withCurve(this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public NodalRecoveryRates withPerturbation(ParameterPerturbation perturbation) {
        return this.withCurve(this.curve.withPerturbation(perturbation));
    }

    public NodalRecoveryRates withCurve(NodalCurve curve) {
        return new NodalRecoveryRates(this.legalEntityId, this.valuationDate, curve);
    }

    public static TypedMetaBean<NodalRecoveryRates> meta() {
        return META_BEAN;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TypedMetaBean<NodalRecoveryRates> metaBean() {
        return META_BEAN;
    }

    @Override
    public StandardId getLegalEntityId() {
        return this.legalEntityId;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public NodalCurve getCurve() {
        return this.curve;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NodalRecoveryRates other = (NodalRecoveryRates)obj;
            return JodaBeanUtils.equal((Object)this.legalEntityId, (Object)other.legalEntityId) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("NodalRecoveryRates{");
        buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<NodalRecoveryRates> {
        private StandardId legalEntityId;
        private LocalDate valuationDate;
        private NodalCurve curve;

        private Builder() {
        }

        private Builder(NodalRecoveryRates beanToCopy) {
            this.legalEntityId = beanToCopy.getLegalEntityId();
            this.valuationDate = beanToCopy.getValuationDate();
            this.curve = beanToCopy.getCurve();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    return this.legalEntityId;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 866287159: {
                    this.legalEntityId = (StandardId)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (NodalCurve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public NodalRecoveryRates build() {
            return new NodalRecoveryRates(this.legalEntityId, this.valuationDate, this.curve);
        }

        public Builder legalEntityId(StandardId legalEntityId) {
            JodaBeanUtils.notNull((Object)legalEntityId, (String)"legalEntityId");
            this.legalEntityId = legalEntityId;
            return this;
        }

        public Builder valuationDate(LocalDate valuationDate) {
            JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
            this.valuationDate = valuationDate;
            return this;
        }

        public Builder curve(NodalCurve curve) {
            JodaBeanUtils.notNull((Object)curve, (String)"curve");
            this.curve = curve;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("NodalRecoveryRates.Builder{");
            buf.append("legalEntityId").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityId)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
            buf.append('}');
            return buf.toString();
        }
    }
}

