/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.CurveParameterSize;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.UnitParameterSensitivities;
import com.opengamma.strata.pricer.curve.CalibrationMeasure;
import com.opengamma.strata.pricer.curve.MarketQuoteMeasure;
import com.opengamma.strata.pricer.curve.PresentValueCalibrationMeasure;
import com.opengamma.strata.pricer.curve.TradeCalibrationMeasure;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.ResolvedTrade;
import java.util.List;

public final class CalibrationMeasures {
    public static final CalibrationMeasures PAR_SPREAD = CalibrationMeasures.of("ParSpread", TradeCalibrationMeasure.FRA_PAR_SPREAD, TradeCalibrationMeasure.FX_SWAP_PAR_SPREAD, TradeCalibrationMeasure.IBOR_FIXING_DEPOSIT_PAR_SPREAD, TradeCalibrationMeasure.IBOR_FUTURE_PAR_SPREAD, TradeCalibrationMeasure.OVERNIGHT_FUTURE_PAR_SPREAD, TradeCalibrationMeasure.SWAP_PAR_SPREAD, TradeCalibrationMeasure.TERM_DEPOSIT_PAR_SPREAD);
    public static final CalibrationMeasures MARKET_QUOTE = CalibrationMeasures.of("MarketQuote", MarketQuoteMeasure.FRA_MQ, MarketQuoteMeasure.IBOR_FIXING_DEPOSIT_MQ, MarketQuoteMeasure.IBOR_FUTURE_MQ, MarketQuoteMeasure.OVERNIGHT_FUTURE_MQ, MarketQuoteMeasure.SWAP_MQ, MarketQuoteMeasure.TERM_DEPOSIT_MQ);
    public static final CalibrationMeasures PRESENT_VALUE = CalibrationMeasures.of("PresentValue", PresentValueCalibrationMeasure.FRA_PV, PresentValueCalibrationMeasure.IBOR_FIXING_DEPOSIT_PV, PresentValueCalibrationMeasure.IBOR_FUTURE_PV, PresentValueCalibrationMeasure.OVERNIGHT_FUTURE_PV, PresentValueCalibrationMeasure.SWAP_PV, PresentValueCalibrationMeasure.TERM_DEPOSIT_PV);
    private final String name;
    private final ImmutableMap<Class<?>, CalibrationMeasure<? extends ResolvedTrade>> measuresByTrade;

    public static CalibrationMeasures of(String name, List<? extends CalibrationMeasure<? extends ResolvedTrade>> measures) {
        return new CalibrationMeasures(name, measures);
    }

    @SafeVarargs
    public static CalibrationMeasures of(String name, CalibrationMeasure<? extends ResolvedTrade> ... measures) {
        return new CalibrationMeasures(name, (List<? extends CalibrationMeasure<? extends ResolvedTrade>>)ImmutableList.copyOf((Object[])measures));
    }

    private CalibrationMeasures(String name, List<? extends CalibrationMeasure<? extends ResolvedTrade>> measures) {
        this.name = ArgChecker.notEmpty((String)name, (String)"name");
        this.measuresByTrade = (ImmutableMap)measures.stream().collect(Guavate.toImmutableMap(CalibrationMeasure::getTradeType, m -> m));
    }

    public String getName() {
        return this.name;
    }

    public ImmutableSet<Class<?>> getTradeTypes() {
        return this.measuresByTrade.keySet();
    }

    public double value(ResolvedTrade trade, RatesProvider provider) {
        CalibrationMeasure<ResolvedTrade> measure = this.getMeasure(trade);
        return measure.value(trade, provider);
    }

    public DoubleArray derivative(ResolvedTrade trade, RatesProvider provider, List<CurveParameterSize> curveOrder) {
        UnitParameterSensitivities unitSens = this.extractSensitivities(trade, provider);
        DoubleArray result = DoubleArray.EMPTY;
        for (CurveParameterSize curveParams : curveOrder) {
            DoubleArray sens = unitSens.findSensitivity((MarketDataName)curveParams.getName()).map(s -> s.getSensitivity()).orElseGet(() -> DoubleArray.filled((int)curveParams.getParameterCount()));
            result = result.concat(sens);
        }
        return result;
    }

    private UnitParameterSensitivities extractSensitivities(ResolvedTrade trade, RatesProvider provider) {
        CalibrationMeasure<ResolvedTrade> measure = this.getMeasure(trade);
        CurrencyParameterSensitivities paramSens = measure.sensitivities(trade, provider);
        UnitParameterSensitivities unitSens = UnitParameterSensitivities.empty();
        for (CurrencyParameterSensitivity ccySens : paramSens.getSensitivities()) {
            unitSens = unitSens.combinedWith(ccySens.toUnitParameterSensitivity());
        }
        return unitSens;
    }

    private <T extends ResolvedTrade> CalibrationMeasure<ResolvedTrade> getMeasure(ResolvedTrade trade) {
        Class<?> tradeType = trade.getClass();
        CalibrationMeasure measure = (CalibrationMeasure)this.measuresByTrade.get(tradeType);
        if (measure == null) {
            throw new IllegalArgumentException(Messages.format((String)"Trade type '{}' is not supported for calibration", (Object)tradeType.getSimpleName()));
        }
        return measure;
    }

    public String toString() {
        return this.name;
    }
}

