/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.JacobianCalibrationMatrix;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupEntry;
import com.opengamma.strata.pricer.curve.RatesProviderGenerator;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ImmutableRatesProviderGenerator
implements RatesProviderGenerator {
    private final ImmutableRatesProvider knownProvider;
    private final ImmutableList<CurveDefinition> curveDefinitions;
    private final ImmutableList<CurveMetadata> curveMetadata;
    private final ImmutableSetMultimap<CurveName, Currency> discountCurveNames;
    private final ImmutableSetMultimap<CurveName, Index> forwardCurveNames;

    public static ImmutableRatesProviderGenerator of(ImmutableRatesProvider knownProvider, RatesCurveGroupDefinition groupDefn, ReferenceData refData) {
        ArrayList<CurveDefinition> curveDefns = new ArrayList<CurveDefinition>();
        ArrayList<CurveMetadata> curveMetadata = new ArrayList<CurveMetadata>();
        HashMultimap discountNames = HashMultimap.create();
        HashMultimap indexNames = HashMultimap.create();
        for (CurveDefinition curveDefn : groupDefn.getCurveDefinitions()) {
            curveDefns.add(curveDefn);
            curveMetadata.add(curveDefn.metadata(knownProvider.getValuationDate(), refData));
            CurveName curveName = curveDefn.getName();
            RatesCurveGroupEntry entry = (RatesCurveGroupEntry)groupDefn.findEntry(curveName).get();
            ImmutableSet ccy = entry.getDiscountCurrencies();
            discountNames.putAll((Object)curveName, (Iterable)ccy);
            indexNames.putAll((Object)curveName, (Iterable)entry.getIndices());
        }
        return new ImmutableRatesProviderGenerator(knownProvider, curveDefns, curveMetadata, (SetMultimap<CurveName, Currency>)discountNames, (SetMultimap<CurveName, Index>)indexNames);
    }

    private ImmutableRatesProviderGenerator(ImmutableRatesProvider knownProvider, List<CurveDefinition> curveDefinitions, List<CurveMetadata> curveMetadata, SetMultimap<CurveName, Currency> discountCurveNames, SetMultimap<CurveName, Index> forwardCurveNames) {
        this.knownProvider = (ImmutableRatesProvider)ArgChecker.notNull((Object)knownProvider, (String)"knownProvider");
        this.curveDefinitions = ImmutableList.copyOf((Collection)((Collection)ArgChecker.notNull(curveDefinitions, (String)"curveDefinitions")));
        this.curveMetadata = ImmutableList.copyOf((Collection)((Collection)ArgChecker.notNull(curveMetadata, (String)"curveMetadata")));
        this.discountCurveNames = ImmutableSetMultimap.copyOf((Multimap)((Multimap)ArgChecker.notNull(discountCurveNames, (String)"discountCurveNames")));
        this.forwardCurveNames = ImmutableSetMultimap.copyOf((Multimap)((Multimap)ArgChecker.notNull(forwardCurveNames, (String)"forwardCurveNames")));
    }

    @Override
    public ImmutableRatesProvider generate(DoubleArray parameters, Map<CurveName, JacobianCalibrationMatrix> jacobians, Map<CurveName, DoubleArray> sensitivitiesMarketQuote) {
        HashMap<Currency, Curve> discountCurves = new HashMap<Currency, Curve>();
        HashMap<Index, Curve> indexCurves = new HashMap<Index, Curve>();
        discountCurves.putAll((Map<Currency, Curve>)this.knownProvider.getDiscountCurves());
        indexCurves.putAll((Map<Index, Curve>)this.knownProvider.getIndexCurves());
        int startIndex = 0;
        for (int i = 0; i < this.curveDefinitions.size(); ++i) {
            CurveDefinition curveDefn = (CurveDefinition)this.curveDefinitions.get(i);
            CurveMetadata metadata = (CurveMetadata)this.curveMetadata.get(i);
            CurveName name = curveDefn.getName();
            int paramCount = curveDefn.getParameterCount();
            DoubleArray curveParams = parameters.subArray(startIndex, startIndex + paramCount);
            startIndex += paramCount;
            CurveMetadata childMetadata = this.childMetadata(metadata, curveDefn, jacobians, sensitivitiesMarketQuote);
            Curve curve = curveDefn.curve(this.knownProvider.getValuationDate(), childMetadata, curveParams);
            ImmutableSet currencies = this.discountCurveNames.get((Object)name);
            for (Currency currency : currencies) {
                discountCurves.put(currency, curve);
            }
            ImmutableSet indices = this.forwardCurveNames.get((Object)name);
            for (Index index : indices) {
                indexCurves.put(index, curve);
            }
        }
        return this.knownProvider.toBuilder().discountCurves(discountCurves).indexCurves(indexCurves).build();
    }

    private CurveMetadata childMetadata(CurveMetadata metadata, CurveDefinition curveDefn, Map<CurveName, JacobianCalibrationMatrix> jacobians, Map<CurveName, DoubleArray> sensitivitiesMarketQuote) {
        DoubleArray sensitivity;
        JacobianCalibrationMatrix jacobian = jacobians.get(curveDefn.getName());
        CurveMetadata metadataResult = metadata;
        if (jacobian != null) {
            metadataResult = metadata.withInfo(CurveInfoType.JACOBIAN, (Object)jacobian);
        }
        if ((sensitivity = sensitivitiesMarketQuote.get(curveDefn.getName())) != null) {
            metadataResult = metadataResult.withInfo(CurveInfoType.PV_SENSITIVITY_TO_MARKET_QUOTE, (Object)sensitivity);
        }
        return metadataResult;
    }
}

