/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.ImmutableMarketData;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupEntry;
import com.opengamma.strata.market.observable.IndexQuoteId;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.pricer.curve.CalibrationMeasures;
import com.opengamma.strata.pricer.curve.RatesCurveCalibrator;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.ResolvedTrade;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class SyntheticRatesCurveCalibrator {
    private static final SyntheticRatesCurveCalibrator STANDARD = SyntheticRatesCurveCalibrator.of(RatesCurveCalibrator.standard(), CalibrationMeasures.MARKET_QUOTE);
    private final RatesCurveCalibrator calibrator;
    private final CalibrationMeasures measures;

    public static SyntheticRatesCurveCalibrator standard() {
        return STANDARD;
    }

    public static SyntheticRatesCurveCalibrator of(RatesCurveCalibrator calibrator, CalibrationMeasures marketQuotesMeasures) {
        return new SyntheticRatesCurveCalibrator(calibrator, marketQuotesMeasures);
    }

    private SyntheticRatesCurveCalibrator(RatesCurveCalibrator calibrator, CalibrationMeasures marketQuotesMeasures) {
        this.measures = marketQuotesMeasures;
        this.calibrator = calibrator;
    }

    public CalibrationMeasures getMeasures() {
        return this.measures;
    }

    public RatesCurveCalibrator getCalibrator() {
        return this.calibrator;
    }

    public ImmutableRatesProvider calibrate(RatesCurveGroupDefinition group, RatesProvider inputProvider, ReferenceData refData) {
        ImmutableMarketData marketQuotesSy = this.marketData(group, inputProvider, refData);
        return this.calibrator.calibrate(group, (MarketData)marketQuotesSy, refData);
    }

    public ImmutableMarketData marketData(RatesCurveGroupDefinition group, RatesProvider inputProvider, ReferenceData refData) {
        HashSet indicesRequired = new HashSet();
        ArrayList ccyRequired = new ArrayList();
        for (RatesCurveGroupEntry entry : group.getEntries()) {
            indicesRequired.addAll(entry.getIndices());
            ccyRequired.addAll(entry.getDiscountCurrencies());
        }
        HashMap<IndexQuoteId, LocalDateDoubleTimeSeries> ts = new HashMap<IndexQuoteId, LocalDateDoubleTimeSeries>();
        for (Index idx : Sets.intersection(inputProvider.getTimeSeriesIndices(), indicesRequired)) {
            ts.put(IndexQuoteId.of((Index)idx), inputProvider.timeSeries(idx));
        }
        LocalDate valuationDate = inputProvider.getValuationDate();
        ImmutableList curveGroups = group.getCurveDefinitions();
        HashMap<Object, Object> mapIdSy = new HashMap<Object, Object>();
        for (int loopccy = 1; loopccy < ccyRequired.size(); ++loopccy) {
            CurrencyPair ccyPair = CurrencyPair.of((Currency)((Currency)ccyRequired.get(0)), (Currency)((Currency)ccyRequired.get(loopccy)));
            FxRateId fxId = FxRateId.of((CurrencyPair)ccyPair);
            mapIdSy.put(fxId, FxRate.of((CurrencyPair)ccyPair, (double)inputProvider.fxRate(ccyPair)));
        }
        for (CurveDefinition entry : curveGroups) {
            ImmutableList nodes = entry.getNodes();
            for (CurveNode node : nodes) {
                ResolvedTrade trade = node.sampleResolvedTrade(valuationDate, (FxRateProvider)inputProvider, refData);
                double mq = this.measures.value(trade, inputProvider);
                for (MarketDataId key : node.requirements()) {
                    if (!(key instanceof QuoteId)) continue;
                    mapIdSy.put(key, mq);
                }
            }
        }
        return ImmutableMarketData.builder((LocalDate)valuationDate).addValueMap(mapIdSy).addTimeSeriesMap(ts).build();
    }

    public String toString() {
        return Messages.format((String)"SyntheticCurveCalibrator[{}, {}]", (Object[])new Object[]{this.calibrator, this.measures});
    }
}

