/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.curve.CalibrationMeasure;
import com.opengamma.strata.pricer.deposit.DiscountingIborFixingDepositProductPricer;
import com.opengamma.strata.pricer.deposit.DiscountingTermDepositProductPricer;
import com.opengamma.strata.pricer.fra.DiscountingFraProductPricer;
import com.opengamma.strata.pricer.fx.DiscountingFxSwapProductPricer;
import com.opengamma.strata.pricer.index.DiscountingIborFutureTradePricer;
import com.opengamma.strata.pricer.index.DiscountingOvernightFutureTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.deposit.ResolvedIborFixingDepositTrade;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;
import com.opengamma.strata.product.fra.ResolvedFraTrade;
import com.opengamma.strata.product.fx.ResolvedFxSwapTrade;
import com.opengamma.strata.product.index.ResolvedIborFutureTrade;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import java.util.function.BiFunction;
import java.util.function.ToDoubleBiFunction;

public final class TradeCalibrationMeasure<T extends ResolvedTrade>
implements CalibrationMeasure<T> {
    public static final TradeCalibrationMeasure<ResolvedFraTrade> FRA_PAR_SPREAD = TradeCalibrationMeasure.of("FraParSpreadDiscounting", ResolvedFraTrade.class, (trade, p) -> DiscountingFraProductPricer.DEFAULT.parSpread(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingFraProductPricer.DEFAULT.parSpreadSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final TradeCalibrationMeasure<ResolvedIborFutureTrade> IBOR_FUTURE_PAR_SPREAD = TradeCalibrationMeasure.of("IborFutureParSpreadDiscounting", ResolvedIborFutureTrade.class, (trade, p) -> DiscountingIborFutureTradePricer.DEFAULT.parSpread((ResolvedIborFutureTrade)trade, (RatesProvider)p, 0.0), (trade, p) -> DiscountingIborFutureTradePricer.DEFAULT.parSpreadSensitivity((ResolvedIborFutureTrade)trade, (RatesProvider)p));
    public static final TradeCalibrationMeasure<ResolvedOvernightFutureTrade> OVERNIGHT_FUTURE_PAR_SPREAD = TradeCalibrationMeasure.of("OvernightFutureParSpreadDiscounting", ResolvedOvernightFutureTrade.class, (trade, p) -> DiscountingOvernightFutureTradePricer.DEFAULT.parSpread((ResolvedOvernightFutureTrade)trade, (RatesProvider)p, 0.0), (trade, p) -> DiscountingOvernightFutureTradePricer.DEFAULT.parSpreadSensitivity((ResolvedOvernightFutureTrade)trade, (RatesProvider)p));
    public static final TradeCalibrationMeasure<ResolvedSwapTrade> SWAP_PAR_SPREAD = TradeCalibrationMeasure.of("SwapParSpreadDiscounting", ResolvedSwapTrade.class, (trade, p) -> DiscountingSwapProductPricer.DEFAULT.parSpread(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingSwapProductPricer.DEFAULT.parSpreadSensitivity(trade.getProduct(), (RatesProvider)p).build());
    public static final TradeCalibrationMeasure<ResolvedIborFixingDepositTrade> IBOR_FIXING_DEPOSIT_PAR_SPREAD = TradeCalibrationMeasure.of("IborFixingDepositParSpreadDiscounting", ResolvedIborFixingDepositTrade.class, (trade, p) -> DiscountingIborFixingDepositProductPricer.DEFAULT.parSpread(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingIborFixingDepositProductPricer.DEFAULT.parSpreadSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final TradeCalibrationMeasure<ResolvedTermDepositTrade> TERM_DEPOSIT_PAR_SPREAD = TradeCalibrationMeasure.of("TermDepositParSpreadDiscounting", ResolvedTermDepositTrade.class, (trade, p) -> DiscountingTermDepositProductPricer.DEFAULT.parSpread(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingTermDepositProductPricer.DEFAULT.parSpreadSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final TradeCalibrationMeasure<ResolvedFxSwapTrade> FX_SWAP_PAR_SPREAD = TradeCalibrationMeasure.of("FxSwapParSpreadDiscounting", ResolvedFxSwapTrade.class, (trade, p) -> DiscountingFxSwapProductPricer.DEFAULT.parSpread(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingFxSwapProductPricer.DEFAULT.parSpreadSensitivity(trade.getProduct(), (RatesProvider)p));
    private final String name;
    private final Class<T> tradeType;
    private final ToDoubleBiFunction<T, RatesProvider> valueFn;
    private final BiFunction<T, RatesProvider, PointSensitivities> sensitivityFn;

    public static <R extends ResolvedTrade> TradeCalibrationMeasure<R> of(String name, Class<R> tradeType, ToDoubleBiFunction<R, RatesProvider> valueFn, BiFunction<R, RatesProvider, PointSensitivities> sensitivityFn) {
        return new TradeCalibrationMeasure<R>(name, tradeType, valueFn, sensitivityFn);
    }

    private TradeCalibrationMeasure(String name, Class<T> tradeType, ToDoubleBiFunction<T, RatesProvider> valueFn, BiFunction<T, RatesProvider, PointSensitivities> sensitivityFn) {
        this.name = name;
        this.tradeType = tradeType;
        this.valueFn = (ToDoubleBiFunction)ArgChecker.notNull(valueFn, (String)"valueFn");
        this.sensitivityFn = (BiFunction)ArgChecker.notNull(sensitivityFn, (String)"sensitivityFn");
    }

    @Override
    public Class<T> getTradeType() {
        return this.tradeType;
    }

    @Override
    public double value(T trade, RatesProvider provider) {
        return this.valueFn.applyAsDouble(trade, provider);
    }

    @Override
    public CurrencyParameterSensitivities sensitivities(T trade, RatesProvider provider) {
        PointSensitivities pts = this.sensitivityFn.apply(trade, provider);
        return provider.parameterSensitivity(pts);
    }

    public String toString() {
        return this.name;
    }
}

