/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.deposit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.deposit.ResolvedTermDeposit;

public class DiscountingTermDepositProductPricer {
    public static final DiscountingTermDepositProductPricer DEFAULT = new DiscountingTermDepositProductPricer();

    public CurrencyAmount presentValue(ResolvedTermDeposit deposit, RatesProvider provider) {
        Currency currency = deposit.getCurrency();
        if (provider.getValuationDate().isAfter(deposit.getEndDate())) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        DiscountFactors discountFactors = provider.discountFactors(currency);
        double dfStart = discountFactors.discountFactor(deposit.getStartDate());
        double dfEnd = discountFactors.discountFactor(deposit.getEndDate());
        double pvStart = this.initialAmount(deposit, provider) * dfStart;
        double pvEnd = (deposit.getNotional() + deposit.getInterest()) * dfEnd;
        double pv = pvEnd - pvStart;
        return CurrencyAmount.of((Currency)currency, (double)pv);
    }

    private double initialAmount(ResolvedTermDeposit deposit, RatesProvider provider) {
        return provider.getValuationDate().isAfter(deposit.getStartDate()) ? 0.0 : deposit.getNotional();
    }

    public PointSensitivities presentValueSensitivity(ResolvedTermDeposit deposit, RatesProvider provider) {
        Currency currency = deposit.getCurrency();
        double dfEndBar = deposit.getNotional() + deposit.getInterest();
        double dfStartBar = -this.initialAmount(deposit, provider);
        DiscountFactors discountFactors = provider.discountFactors(currency);
        ZeroRateSensitivity sensStart = discountFactors.zeroRatePointSensitivity(deposit.getStartDate()).multipliedBy(dfStartBar);
        ZeroRateSensitivity sensEnd = discountFactors.zeroRatePointSensitivity(deposit.getEndDate()).multipliedBy(dfEndBar);
        return sensStart.combinedWith(sensEnd).build();
    }

    public double parRate(ResolvedTermDeposit deposit, RatesProvider provider) {
        Currency currency = deposit.getCurrency();
        DiscountFactors discountFactors = provider.discountFactors(currency);
        double dfStart = discountFactors.discountFactor(deposit.getStartDate());
        double dfEnd = discountFactors.discountFactor(deposit.getEndDate());
        double accrualFactor = deposit.getYearFraction();
        return (dfStart / dfEnd - 1.0) / accrualFactor;
    }

    public PointSensitivities parRateSensitivity(ResolvedTermDeposit deposit, RatesProvider provider) {
        return this.parSpreadSensitivity(deposit, provider);
    }

    public double parSpread(ResolvedTermDeposit deposit, RatesProvider provider) {
        double parRate = this.parRate(deposit, provider);
        return parRate - deposit.getRate();
    }

    public PointSensitivities parSpreadSensitivity(ResolvedTermDeposit deposit, RatesProvider provider) {
        Currency currency = deposit.getCurrency();
        double accrualFactorInv = 1.0 / deposit.getYearFraction();
        double dfStart = provider.discountFactor(currency, deposit.getStartDate());
        double dfEndInv = 1.0 / provider.discountFactor(currency, deposit.getEndDate());
        DiscountFactors discountFactors = provider.discountFactors(currency);
        ZeroRateSensitivity sensStart = discountFactors.zeroRatePointSensitivity(deposit.getStartDate()).multipliedBy(dfEndInv * accrualFactorInv);
        ZeroRateSensitivity sensEnd = discountFactors.zeroRatePointSensitivity(deposit.getEndDate()).multipliedBy(-dfStart * dfEndInv * dfEndInv * accrualFactorInv);
        return sensStart.combinedWith(sensEnd).build();
    }
}

