/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.dsf;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.dsf.ResolvedDsf;
import com.opengamma.strata.product.swap.ResolvedSwap;

public final class DiscountingDsfProductPricer {
    public static final DiscountingDsfProductPricer DEFAULT = new DiscountingDsfProductPricer(DiscountingSwapProductPricer.DEFAULT);
    private final DiscountingSwapProductPricer swapPricer;

    public DiscountingDsfProductPricer(DiscountingSwapProductPricer swapPricer) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
    }

    DiscountingSwapProductPricer getSwapPricer() {
        return this.swapPricer;
    }

    double marginIndex(ResolvedDsf future, double price) {
        return price * future.getNotional();
    }

    PointSensitivities marginIndexSensitivity(ResolvedDsf future, PointSensitivities priceSensitivity) {
        return priceSensitivity.multipliedBy(future.getNotional());
    }

    public double price(ResolvedDsf future, RatesProvider ratesProvider) {
        ResolvedSwap swap = future.getUnderlyingSwap();
        Currency currency = future.getCurrency();
        CurrencyAmount pvSwap = this.swapPricer.presentValue(swap, currency, ratesProvider);
        double df = ratesProvider.discountFactor(currency, future.getDeliveryDate());
        return 1.0 + pvSwap.getAmount() / df;
    }

    public PointSensitivities priceSensitivity(ResolvedDsf future, RatesProvider ratesProvider) {
        ResolvedSwap swap = future.getUnderlyingSwap();
        Currency currency = future.getCurrency();
        double pvSwap = this.swapPricer.presentValue(swap, currency, ratesProvider).getAmount();
        double dfInv = 1.0 / ratesProvider.discountFactor(currency, future.getDeliveryDate());
        PointSensitivityBuilder sensiSwapPv = this.swapPricer.presentValueSensitivity(swap, ratesProvider).multipliedBy(dfInv);
        ZeroRateSensitivity sensiDf = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(future.getDeliveryDate()).multipliedBy(-pvSwap * dfInv * dfInv);
        return sensiSwapPv.combinedWith((PointSensitivityBuilder)sensiDf).build();
    }
}

