/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.dsf;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.dsf.DiscountingDsfProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.dsf.ResolvedDsf;
import com.opengamma.strata.product.dsf.ResolvedDsfTrade;
import java.time.LocalDate;

public class DiscountingDsfTradePricer {
    public static final DiscountingDsfTradePricer DEFAULT = new DiscountingDsfTradePricer(DiscountingDsfProductPricer.DEFAULT);
    private final DiscountingDsfProductPricer productPricer;

    public DiscountingDsfTradePricer(DiscountingDsfProductPricer productPricer) {
        this.productPricer = (DiscountingDsfProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public double price(ResolvedDsfTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.price(trade.getProduct(), ratesProvider);
    }

    public PointSensitivities priceSensitivity(ResolvedDsfTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider);
    }

    private double referencePrice(ResolvedDsfTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }

    private CurrencyAmount presentValue(ResolvedDsfTrade trade, double currentPrice, double referencePrice) {
        ResolvedDsf future = trade.getProduct();
        double priceIndex = this.productPricer.marginIndex(future, currentPrice);
        double referenceIndex = this.productPricer.marginIndex(future, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)future.getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedDsfTrade trade, RatesProvider ratesProvider, double lastSettlementPrice) {
        double price = this.price(trade, ratesProvider);
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        return this.presentValue(trade, price, referencePrice);
    }

    public PointSensitivities presentValueSensitivity(ResolvedDsfTrade trade, RatesProvider ratesProvider) {
        ResolvedDsf product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivity(product, ratesProvider);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public MultiCurrencyAmount currencyExposure(ResolvedDsfTrade trade, RatesProvider ratesProvider, double lastSettlementPrice) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, ratesProvider, lastSettlementPrice)});
    }
}

