/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fra;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.amount.CashFlow;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fra.ResolvedFra;
import com.opengamma.strata.product.rate.RateComputation;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class DiscountingFraProductPricer {
    public static final DiscountingFraProductPricer DEFAULT = new DiscountingFraProductPricer(RateComputationFn.standard());
    private final RateComputationFn<RateComputation> rateComputationFn;

    public DiscountingFraProductPricer(RateComputationFn<RateComputation> rateComputationFn) {
        this.rateComputationFn = (RateComputationFn)ArgChecker.notNull(rateComputationFn, (String)"rateComputationFn");
    }

    public CurrencyAmount presentValue(ResolvedFra fra, RatesProvider provider) {
        double df = provider.discountFactor(fra.getCurrency(), fra.getPaymentDate());
        double pv = this.forecastValue0(fra, provider) * df;
        return CurrencyAmount.of((Currency)fra.getCurrency(), (double)pv);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFra fra, RatesProvider provider) {
        if (fra.getPaymentDate().isBefore(provider.getValuationDate())) {
            return PointSensitivities.empty();
        }
        DiscountFactors discountFactors = provider.discountFactors(fra.getCurrency());
        double df = discountFactors.discountFactor(fra.getPaymentDate());
        double notional = fra.getNotional();
        double unitAmount = this.unitAmount(fra, provider);
        double derivative = this.derivative(fra, provider);
        PointSensitivityBuilder iborSens = this.forwardRateSensitivity(fra, provider).multipliedBy(derivative * df * notional);
        ZeroRateSensitivity discSens = discountFactors.zeroRatePointSensitivity(fra.getPaymentDate()).multipliedBy(unitAmount * notional);
        return iborSens.withCurrency(fra.getCurrency()).combinedWith((PointSensitivityBuilder)discSens).build();
    }

    public CurrencyAmount forecastValue(ResolvedFra fra, RatesProvider provider) {
        double fv = this.forecastValue0(fra, provider);
        return CurrencyAmount.of((Currency)fra.getCurrency(), (double)fv);
    }

    public PointSensitivities forecastValueSensitivity(ResolvedFra fra, RatesProvider provider) {
        if (fra.getPaymentDate().isBefore(provider.getValuationDate())) {
            return PointSensitivities.empty();
        }
        double notional = fra.getNotional();
        double derivative = this.derivative(fra, provider);
        PointSensitivityBuilder iborSens = this.forwardRateSensitivity(fra, provider).multipliedBy(derivative * notional);
        return iborSens.withCurrency(fra.getCurrency()).build();
    }

    public double parRate(ResolvedFra fra, RatesProvider provider) {
        return this.forwardRate(fra, provider);
    }

    public PointSensitivities parRateSensitivity(ResolvedFra fra, RatesProvider provider) {
        return this.forwardRateSensitivity(fra, provider).build();
    }

    public double parSpread(ResolvedFra fra, RatesProvider provider) {
        double forward = this.forwardRate(fra, provider);
        return forward - fra.getFixedRate();
    }

    public PointSensitivities parSpreadSensitivity(ResolvedFra fra, RatesProvider provider) {
        return this.forwardRateSensitivity(fra, provider).build();
    }

    public CashFlows cashFlows(ResolvedFra fra, RatesProvider provider) {
        LocalDate paymentDate = fra.getPaymentDate();
        double forecastValue = this.forecastValue0(fra, provider);
        double df = provider.discountFactor(fra.getCurrency(), paymentDate);
        CashFlow cashFlow = CashFlow.ofForecastValue((LocalDate)paymentDate, (Currency)fra.getCurrency(), (double)forecastValue, (double)df);
        return CashFlows.of((CashFlow)cashFlow);
    }

    public ExplainMap explainPresentValue(ResolvedFra fra, RatesProvider provider) {
        ExplainMapBuilder builder = ExplainMap.builder();
        Currency currency = fra.getCurrency();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"FRA");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)fra.getPaymentDate());
        builder.put(ExplainKey.START_DATE, (Object)fra.getStartDate());
        builder.put(ExplainKey.END_DATE, (Object)fra.getEndDate());
        builder.put(ExplainKey.ACCRUAL_YEAR_FRACTION, (Object)fra.getYearFraction());
        builder.put(ExplainKey.DAYS, (Object)((int)ChronoUnit.DAYS.between(fra.getStartDate(), fra.getEndDate())));
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.NOTIONAL, (Object)CurrencyAmount.of((Currency)currency, (double)fra.getNotional()));
        builder.put(ExplainKey.TRADE_NOTIONAL, (Object)CurrencyAmount.of((Currency)currency, (double)fra.getNotional()));
        if (fra.getPaymentDate().isBefore(provider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            double rate = this.rateComputationFn.explainRate(fra.getFloatingRate(), fra.getStartDate(), fra.getEndDate(), provider, builder);
            builder.put(ExplainKey.FIXED_RATE, (Object)fra.getFixedRate());
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)provider.discountFactor(currency, fra.getPaymentDate()));
            builder.put(ExplainKey.PAY_OFF_RATE, (Object)rate);
            builder.put(ExplainKey.UNIT_AMOUNT, (Object)this.unitAmount(fra, provider));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)this.forecastValue(fra, provider));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)this.presentValue(fra, provider));
        }
        return builder.build();
    }

    private double forecastValue0(ResolvedFra fra, RatesProvider provider) {
        if (fra.getPaymentDate().isBefore(provider.getValuationDate())) {
            return 0.0;
        }
        return fra.getNotional() * this.unitAmount(fra, provider);
    }

    private double unitAmount(ResolvedFra fra, RatesProvider provider) {
        switch (fra.getDiscounting()) {
            case NONE: {
                return this.unitAmountNone(fra, provider);
            }
            case ISDA: {
                return this.unitAmountIsda(fra, provider);
            }
            case AFMA: {
                return this.unitAmountAfma(fra, provider);
            }
        }
        throw new IllegalArgumentException("Unknown FraDiscounting value: " + fra.getDiscounting());
    }

    private double unitAmountNone(ResolvedFra fra, RatesProvider provider) {
        double fixedRate = fra.getFixedRate();
        double forwardRate = this.forwardRate(fra, provider);
        double yearFraction = fra.getYearFraction();
        return (forwardRate - fixedRate) * yearFraction;
    }

    private double unitAmountIsda(ResolvedFra fra, RatesProvider provider) {
        double fixedRate = fra.getFixedRate();
        double forwardRate = this.forwardRate(fra, provider);
        double yearFraction = fra.getYearFraction();
        return (forwardRate - fixedRate) / (1.0 + forwardRate * yearFraction) * yearFraction;
    }

    private double unitAmountAfma(ResolvedFra fra, RatesProvider provider) {
        double fixedRate = fra.getFixedRate();
        double forwardRate = this.forwardRate(fra, provider);
        double yearFraction = fra.getYearFraction();
        return 1.0 / (1.0 + fixedRate * yearFraction) - 1.0 / (1.0 + forwardRate * yearFraction);
    }

    private double derivative(ResolvedFra fra, RatesProvider provider) {
        switch (fra.getDiscounting()) {
            case NONE: {
                return this.derivativeNone(fra, provider);
            }
            case ISDA: {
                return this.derivativeIsda(fra, provider);
            }
            case AFMA: {
                return this.derivativeAfma(fra, provider);
            }
        }
        throw new IllegalArgumentException("Unknown FraDiscounting value: " + fra.getDiscounting());
    }

    private double derivativeNone(ResolvedFra fra, RatesProvider provider) {
        return fra.getYearFraction();
    }

    private double derivativeIsda(ResolvedFra fra, RatesProvider provider) {
        double fixedRate = fra.getFixedRate();
        double forwardRate = this.forwardRate(fra, provider);
        double yearFraction = fra.getYearFraction();
        double dsc = 1.0 / (1.0 + forwardRate * yearFraction);
        return (1.0 + fixedRate * yearFraction) * yearFraction * dsc * dsc;
    }

    private double derivativeAfma(ResolvedFra fra, RatesProvider provider) {
        double forwardRate = this.forwardRate(fra, provider);
        double yearFraction = fra.getYearFraction();
        double dsc = 1.0 / (1.0 + forwardRate * yearFraction);
        return yearFraction * dsc * dsc;
    }

    private double forwardRate(ResolvedFra fra, RatesProvider provider) {
        return this.rateComputationFn.rate(fra.getFloatingRate(), fra.getStartDate(), fra.getEndDate(), provider);
    }

    private PointSensitivityBuilder forwardRateSensitivity(ResolvedFra fra, RatesProvider provider) {
        return this.rateComputationFn.rateSensitivity(fra.getFloatingRate(), fra.getStartDate(), fra.getEndDate(), provider);
    }
}

