/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fra;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.fra.DiscountingFraProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fra.ResolvedFra;
import com.opengamma.strata.product.fra.ResolvedFraTrade;

public class DiscountingFraTradePricer {
    public static final DiscountingFraTradePricer DEFAULT = new DiscountingFraTradePricer(DiscountingFraProductPricer.DEFAULT);
    private final DiscountingFraProductPricer productPricer;

    public DiscountingFraTradePricer(DiscountingFraProductPricer productPricer) {
        this.productPricer = (DiscountingFraProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public DiscountingFraProductPricer getProductPricer() {
        return this.productPricer;
    }

    public CurrencyAmount presentValue(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public ExplainMap explainPresentValue(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.explainPresentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider);
    }

    public CurrencyAmount forecastValue(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.forecastValue(trade.getProduct(), provider);
    }

    public PointSensitivities forecastValueSensitivity(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.forecastValueSensitivity(trade.getProduct(), provider);
    }

    public double parRate(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.parRate(trade.getProduct(), provider);
    }

    public PointSensitivities parRateSensitivity(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.parRateSensitivity(trade.getProduct(), provider);
    }

    public double parSpread(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.parSpread(trade.getProduct(), provider);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), provider);
    }

    public CashFlows cashFlows(ResolvedFraTrade trade, RatesProvider provider) {
        return this.productPricer.cashFlows(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFraTrade trade, RatesProvider provider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, provider)});
    }

    public CurrencyAmount currentCash(ResolvedFraTrade trade, RatesProvider provider) {
        ResolvedFra fra = trade.getProduct();
        if (fra.getPaymentDate().isEqual(provider.getValuationDate())) {
            return this.productPricer.presentValue(fra, provider);
        }
        return CurrencyAmount.zero((Currency)fra.getCurrency());
    }
}

