/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.ParameterizedDataCombiner;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.FxForwardRates;
import com.opengamma.strata.pricer.fx.FxForwardSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class DiscountFxForwardRates
implements FxForwardRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull")
    private final FxRateProvider fxRateProvider;
    @PropertyDefinition(validate="notNull")
    private final DiscountFactors baseCurrencyDiscountFactors;
    @PropertyDefinition(validate="notNull")
    private final DiscountFactors counterCurrencyDiscountFactors;
    private final transient LocalDate valuationDate;
    private final transient ParameterizedDataCombiner paramCombiner;
    private static final long serialVersionUID = 1L;

    public static DiscountFxForwardRates of(CurrencyPair currencyPair, FxRateProvider fxRateProvider, DiscountFactors baseCurrencyFactors, DiscountFactors counterCurrencyFactors) {
        return new DiscountFxForwardRates(currencyPair, fxRateProvider, baseCurrencyFactors, counterCurrencyFactors);
    }

    @ImmutableConstructor
    private DiscountFxForwardRates(CurrencyPair currencyPair, FxRateProvider fxRateProvider, DiscountFactors baseCurrencyDiscountFactors, DiscountFactors counterCurrencyDiscountFactors) {
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)fxRateProvider, (String)"fxRateProvider");
        JodaBeanUtils.notNull((Object)baseCurrencyDiscountFactors, (String)"baseCurrencyDiscountFactors");
        JodaBeanUtils.notNull((Object)counterCurrencyDiscountFactors, (String)"counterCurrencyDiscountFactors");
        if (!baseCurrencyDiscountFactors.getCurrency().equals((Object)currencyPair.getBase())) {
            throw new IllegalArgumentException(Messages.format((String)"Index base currency {} did not match discount factor base currency {}", (Object[])new Object[]{currencyPair.getBase(), baseCurrencyDiscountFactors.getCurrency()}));
        }
        if (!counterCurrencyDiscountFactors.getCurrency().equals((Object)currencyPair.getCounter())) {
            throw new IllegalArgumentException(Messages.format((String)"Index counter currency {} did not match discount factor counter currency {}", (Object[])new Object[]{currencyPair.getCounter(), counterCurrencyDiscountFactors.getCurrency()}));
        }
        if (!baseCurrencyDiscountFactors.getValuationDate().equals(counterCurrencyDiscountFactors.getValuationDate())) {
            throw new IllegalArgumentException("Curves must have the same valuation date");
        }
        this.currencyPair = currencyPair;
        this.fxRateProvider = fxRateProvider;
        this.baseCurrencyDiscountFactors = baseCurrencyDiscountFactors;
        this.counterCurrencyDiscountFactors = counterCurrencyDiscountFactors;
        this.valuationDate = baseCurrencyDiscountFactors.getValuationDate();
        this.paramCombiner = ParameterizedDataCombiner.of((ParameterizedData[])new ParameterizedData[]{baseCurrencyDiscountFactors, counterCurrencyDiscountFactors});
    }

    private Object readResolve() {
        return new DiscountFxForwardRates(this.currencyPair, this.fxRateProvider, this.baseCurrencyDiscountFactors, this.counterCurrencyDiscountFactors);
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return this.baseCurrencyDiscountFactors.findData(name).map(Optional::of).orElse(this.counterCurrencyDiscountFactors.findData(name));
    }

    public int getParameterCount() {
        return this.paramCombiner.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.paramCombiner.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.paramCombiner.getParameterMetadata(parameterIndex);
    }

    @Override
    public DiscountFxForwardRates withParameter(int parameterIndex, double newValue) {
        return new DiscountFxForwardRates(this.currencyPair, this.fxRateProvider, (DiscountFactors)this.paramCombiner.underlyingWithParameter(0, DiscountFactors.class, parameterIndex, newValue), (DiscountFactors)this.paramCombiner.underlyingWithParameter(1, DiscountFactors.class, parameterIndex, newValue));
    }

    @Override
    public DiscountFxForwardRates withPerturbation(ParameterPerturbation perturbation) {
        return new DiscountFxForwardRates(this.currencyPair, this.fxRateProvider, (DiscountFactors)this.paramCombiner.underlyingWithPerturbation(0, DiscountFactors.class, perturbation), (DiscountFactors)this.paramCombiner.underlyingWithPerturbation(1, DiscountFactors.class, perturbation));
    }

    @Override
    public double rate(Currency baseCurrency, LocalDate referenceDate) {
        ArgChecker.isTrue((boolean)this.currencyPair.contains(baseCurrency), (String)"Currency {} invalid for CurrencyPair {}", (Object[])new Object[]{baseCurrency, this.currencyPair});
        boolean inverse = baseCurrency.equals((Object)this.currencyPair.getCounter());
        double dfCcyBaseAtMaturity = this.baseCurrencyDiscountFactors.discountFactor(referenceDate);
        double dfCcyCounterAtMaturity = this.counterCurrencyDiscountFactors.discountFactor(referenceDate);
        double forwardRate = this.fxRateProvider.fxRate(this.currencyPair) * (dfCcyBaseAtMaturity / dfCcyCounterAtMaturity);
        return inverse ? 1.0 / forwardRate : forwardRate;
    }

    @Override
    public PointSensitivityBuilder ratePointSensitivity(Currency baseCurrency, LocalDate referenceDate) {
        ArgChecker.isTrue((boolean)this.currencyPair.contains(baseCurrency), (String)"Currency {} invalid for CurrencyPair {}", (Object[])new Object[]{baseCurrency, this.currencyPair});
        return FxForwardSensitivity.of(this.currencyPair, baseCurrency, referenceDate, 1.0);
    }

    @Override
    public double rateFxSpotSensitivity(Currency baseCurrency, LocalDate referenceDate) {
        ArgChecker.isTrue((boolean)this.currencyPair.contains(baseCurrency), (String)"Currency {} invalid for CurrencyPair {}", (Object[])new Object[]{baseCurrency, this.currencyPair});
        boolean inverse = baseCurrency.equals((Object)this.currencyPair.getCounter());
        double dfCcyBaseAtMaturity = this.baseCurrencyDiscountFactors.discountFactor(referenceDate);
        double dfCcyCounterAtMaturity = this.counterCurrencyDiscountFactors.discountFactor(referenceDate);
        double forwardRateDelta = dfCcyBaseAtMaturity / dfCcyCounterAtMaturity;
        return inverse ? 1.0 / forwardRateDelta : forwardRateDelta;
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(FxForwardSensitivity pointSensitivity) {
        CurrencyPair currencyPair = pointSensitivity.getCurrencyPair();
        Currency refBaseCurrency = pointSensitivity.getReferenceCurrency();
        Currency refCounterCurrency = pointSensitivity.getReferenceCounterCurrency();
        Currency sensitivityCurrency = pointSensitivity.getCurrency();
        LocalDate referenceDate = pointSensitivity.getReferenceDate();
        boolean inverse = refBaseCurrency.equals((Object)currencyPair.getCounter());
        DiscountFactors discountFactorsRefBase = inverse ? this.counterCurrencyDiscountFactors : this.baseCurrencyDiscountFactors;
        DiscountFactors discountFactorsRefCounter = inverse ? this.baseCurrencyDiscountFactors : this.counterCurrencyDiscountFactors;
        double dfCcyBaseAtMaturity = discountFactorsRefBase.discountFactor(referenceDate);
        double dfCcyCounterAtMaturityInv = 1.0 / discountFactorsRefCounter.discountFactor(referenceDate);
        double fxRate = this.fxRateProvider.fxRate(refBaseCurrency, refCounterCurrency);
        ZeroRateSensitivity dfCcyBaseAtMaturitySensitivity = discountFactorsRefBase.zeroRatePointSensitivity(referenceDate, sensitivityCurrency).multipliedBy(fxRate * dfCcyCounterAtMaturityInv * pointSensitivity.getSensitivity());
        ZeroRateSensitivity dfCcyCounterAtMaturitySensitivity = discountFactorsRefCounter.zeroRatePointSensitivity(referenceDate, sensitivityCurrency).multipliedBy(-fxRate * dfCcyBaseAtMaturity * dfCcyCounterAtMaturityInv * dfCcyCounterAtMaturityInv * pointSensitivity.getSensitivity());
        return discountFactorsRefBase.parameterSensitivity(dfCcyBaseAtMaturitySensitivity).combinedWith(discountFactorsRefCounter.parameterSensitivity(dfCcyCounterAtMaturitySensitivity));
    }

    @Override
    public MultiCurrencyAmount currencyExposure(FxForwardSensitivity pointSensitivity) {
        ArgChecker.isTrue((boolean)pointSensitivity.getCurrency().equals((Object)pointSensitivity.getReferenceCurrency()), (String)"Currency exposure defined only when sensitivity currency equal reference currency");
        Currency ccyRef = pointSensitivity.getReferenceCurrency();
        CurrencyPair pair = pointSensitivity.getCurrencyPair();
        double s = pointSensitivity.getSensitivity();
        LocalDate d = pointSensitivity.getReferenceDate();
        double f = this.fxRateProvider.fxRate(pair.getBase(), pair.getCounter());
        double pA = this.baseCurrencyDiscountFactors.discountFactor(d);
        double pB = this.counterCurrencyDiscountFactors.discountFactor(d);
        if (ccyRef.equals((Object)pair.getBase())) {
            CurrencyAmount amountCounter = CurrencyAmount.of((Currency)pair.getBase(), (double)(s * f * pA / pB));
            CurrencyAmount amountBase = CurrencyAmount.of((Currency)pair.getCounter(), (double)(-s * f * f * pA / pB));
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{amountBase, amountCounter});
        }
        CurrencyAmount amountBase = CurrencyAmount.of((Currency)pair.getBase(), (double)(-s * pB / (pA * f * f)));
        CurrencyAmount amountCounter = CurrencyAmount.of((Currency)pair.getCounter(), (double)(s * pB / (pA * f)));
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{amountBase, amountCounter});
    }

    public DiscountFxForwardRates withDiscountFactors(DiscountFactors baseCurrencyFactors, DiscountFactors counterCurrencyFactors) {
        return new DiscountFxForwardRates(this.currencyPair, this.fxRateProvider, baseCurrencyFactors, counterCurrencyFactors);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public FxRateProvider getFxRateProvider() {
        return this.fxRateProvider;
    }

    public DiscountFactors getBaseCurrencyDiscountFactors() {
        return this.baseCurrencyDiscountFactors;
    }

    public DiscountFactors getCounterCurrencyDiscountFactors() {
        return this.counterCurrencyDiscountFactors;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DiscountFxForwardRates other = (DiscountFxForwardRates)obj;
            return JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.fxRateProvider, (Object)other.fxRateProvider) && JodaBeanUtils.equal((Object)this.baseCurrencyDiscountFactors, (Object)other.baseCurrencyDiscountFactors) && JodaBeanUtils.equal((Object)this.counterCurrencyDiscountFactors, (Object)other.counterCurrencyDiscountFactors);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxRateProvider);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.baseCurrencyDiscountFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.counterCurrencyDiscountFactors);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("DiscountFxForwardRates{");
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("fxRateProvider").append('=').append(JodaBeanUtils.toString((Object)this.fxRateProvider)).append(',').append(' ');
        buf.append("baseCurrencyDiscountFactors").append('=').append(JodaBeanUtils.toString((Object)this.baseCurrencyDiscountFactors)).append(',').append(' ');
        buf.append("counterCurrencyDiscountFactors").append('=').append(JodaBeanUtils.toString((Object)this.counterCurrencyDiscountFactors));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DiscountFxForwardRates> {
        private CurrencyPair currencyPair;
        private FxRateProvider fxRateProvider;
        private DiscountFactors baseCurrencyDiscountFactors;
        private DiscountFactors counterCurrencyDiscountFactors;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case -1499624221: {
                    return this.fxRateProvider;
                }
                case 1151357473: {
                    return this.baseCurrencyDiscountFactors;
                }
                case -453959018: {
                    return this.counterCurrencyDiscountFactors;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case -1499624221: {
                    this.fxRateProvider = (FxRateProvider)newValue;
                    break;
                }
                case 1151357473: {
                    this.baseCurrencyDiscountFactors = (DiscountFactors)newValue;
                    break;
                }
                case -453959018: {
                    this.counterCurrencyDiscountFactors = (DiscountFactors)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DiscountFxForwardRates build() {
            return new DiscountFxForwardRates(this.currencyPair, this.fxRateProvider, this.baseCurrencyDiscountFactors, this.counterCurrencyDiscountFactors);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("DiscountFxForwardRates.Builder{");
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("fxRateProvider").append('=').append(JodaBeanUtils.toString((Object)this.fxRateProvider)).append(',').append(' ');
            buf.append("baseCurrencyDiscountFactors").append('=').append(JodaBeanUtils.toString((Object)this.baseCurrencyDiscountFactors)).append(',').append(' ');
            buf.append("counterCurrencyDiscountFactors").append('=').append(JodaBeanUtils.toString((Object)this.counterCurrencyDiscountFactors));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", DiscountFxForwardRates.class, CurrencyPair.class);
        private final MetaProperty<FxRateProvider> fxRateProvider = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxRateProvider", DiscountFxForwardRates.class, FxRateProvider.class);
        private final MetaProperty<DiscountFactors> baseCurrencyDiscountFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"baseCurrencyDiscountFactors", DiscountFxForwardRates.class, DiscountFactors.class);
        private final MetaProperty<DiscountFactors> counterCurrencyDiscountFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"counterCurrencyDiscountFactors", DiscountFxForwardRates.class, DiscountFactors.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currencyPair", "fxRateProvider", "baseCurrencyDiscountFactors", "counterCurrencyDiscountFactors"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case -1499624221: {
                    return this.fxRateProvider;
                }
                case 1151357473: {
                    return this.baseCurrencyDiscountFactors;
                }
                case -453959018: {
                    return this.counterCurrencyDiscountFactors;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DiscountFxForwardRates> builder() {
            return new Builder();
        }

        public Class<? extends DiscountFxForwardRates> beanType() {
            return DiscountFxForwardRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<FxRateProvider> fxRateProvider() {
            return this.fxRateProvider;
        }

        public MetaProperty<DiscountFactors> baseCurrencyDiscountFactors() {
            return this.baseCurrencyDiscountFactors;
        }

        public MetaProperty<DiscountFactors> counterCurrencyDiscountFactors() {
            return this.counterCurrencyDiscountFactors;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return ((DiscountFxForwardRates)bean).getCurrencyPair();
                }
                case -1499624221: {
                    return ((DiscountFxForwardRates)bean).getFxRateProvider();
                }
                case 1151357473: {
                    return ((DiscountFxForwardRates)bean).getBaseCurrencyDiscountFactors();
                }
                case -453959018: {
                    return ((DiscountFxForwardRates)bean).getCounterCurrencyDiscountFactors();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

