/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxNdf;
import java.time.LocalDate;
import java.util.OptionalDouble;

public class DiscountingFxNdfProductPricer {
    public static final DiscountingFxNdfProductPricer DEFAULT = new DiscountingFxNdfProductPricer();

    public CurrencyAmount presentValue(ResolvedFxNdf ndf, RatesProvider provider) {
        Currency ccySettle = ndf.getSettlementCurrency();
        if (provider.getValuationDate().isAfter(ndf.getPaymentDate())) {
            return CurrencyAmount.zero((Currency)ccySettle);
        }
        Currency ccyOther = ndf.getNonDeliverableCurrency();
        CurrencyAmount notionalSettle = ndf.getSettlementCurrencyNotional();
        double agreedRate = ndf.getAgreedFxRate().fxRate(ccySettle, ccyOther);
        double forwardRate = provider.fxIndexRates(ndf.getIndex()).rate(ndf.getObservation(), ccySettle);
        double dfSettle = provider.discountFactor(ccySettle, ndf.getPaymentDate());
        return notionalSettle.multipliedBy(dfSettle * (1.0 - agreedRate / forwardRate));
    }

    public PointSensitivities presentValueSensitivity(ResolvedFxNdf ndf, RatesProvider provider) {
        if (provider.getValuationDate().isAfter(ndf.getPaymentDate())) {
            return PointSensitivities.empty();
        }
        Currency ccySettle = ndf.getSettlementCurrency();
        Currency ccyOther = ndf.getNonDeliverableCurrency();
        double notionalSettle = ndf.getSettlementNotional();
        double agreedRate = ndf.getAgreedFxRate().fxRate(ccySettle, ccyOther);
        double forwardRate = provider.fxIndexRates(ndf.getIndex()).rate(ndf.getObservation(), ccySettle);
        double dfSettle = provider.discountFactor(ccySettle, ndf.getPaymentDate());
        double ratio = agreedRate / forwardRate;
        double dscBar = (1.0 - ratio) * notionalSettle;
        ZeroRateSensitivity sensiDsc = provider.discountFactors(ccySettle).zeroRatePointSensitivity(ndf.getPaymentDate()).multipliedBy(dscBar);
        double forwardRateBar = dfSettle * notionalSettle * ratio / forwardRate;
        PointSensitivityBuilder sensiFx = provider.fxIndexRates(ndf.getIndex()).ratePointSensitivity(ndf.getObservation(), ccySettle).withCurrency(ccySettle).multipliedBy(forwardRateBar);
        return sensiDsc.combinedWith(sensiFx).build();
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxNdf ndf, RatesProvider provider) {
        LocalDate valuationDate;
        if (provider.getValuationDate().isAfter(ndf.getPaymentDate())) {
            return MultiCurrencyAmount.empty();
        }
        Currency ccySettle = ndf.getSettlementCurrency();
        CurrencyAmount notionalSettle = ndf.getSettlementCurrencyNotional();
        double dfSettle = provider.discountFactor(ccySettle, ndf.getPaymentDate());
        Currency ccyOther = ndf.getNonDeliverableCurrency();
        double agreedRate = ndf.getAgreedFxRate().fxRate(ccySettle, ccyOther);
        LocalDate fixingDate = ndf.getObservation().getFixingDate();
        if (fixingDate.isAfter(valuationDate = provider.getValuationDate())) {
            double dfOther = provider.discountFactor(ccyOther, ndf.getPaymentDate());
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{notionalSettle.multipliedBy(dfSettle)}).plus(CurrencyAmount.of((Currency)ccyOther, (double)(-notionalSettle.getAmount() * agreedRate * dfOther)));
        }
        if (fixingDate.equals(valuationDate)) {
            FxIndexRates fxIndexRates = provider.fxIndexRates(ndf.getObservation().getIndex());
            LocalDateDoubleTimeSeries fixings = fxIndexRates.getFixings();
            OptionalDouble fixedRate = fixings.get(fixingDate);
            if (fixedRate.isPresent()) {
                return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{notionalSettle.multipliedBy(dfSettle * (1.0 - agreedRate / fixedRate.getAsDouble()))});
            }
            double dfOther = provider.discountFactor(ccyOther, ndf.getPaymentDate());
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{notionalSettle.multipliedBy(dfSettle)}).plus(CurrencyAmount.of((Currency)ccyOther, (double)(-notionalSettle.getAmount() * agreedRate * dfOther)));
        }
        FxIndexRates fxIndexRates = provider.fxIndexRates(ndf.getObservation().getIndex());
        LocalDateDoubleTimeSeries fixings = fxIndexRates.getFixings();
        OptionalDouble fixedRate = fixings.get(fixingDate);
        if (fixedRate.isPresent()) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{notionalSettle.multipliedBy(dfSettle * (1.0 - agreedRate / fixedRate.getAsDouble()))});
        }
        throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}", (Object[])new Object[]{ndf.getObservation().getIndex(), fixingDate}));
    }

    public CurrencyAmount currentCash(ResolvedFxNdf ndf, RatesProvider provider) {
        Currency ccySettle = ndf.getSettlementCurrency();
        if (provider.getValuationDate().isEqual(ndf.getPaymentDate())) {
            Currency ccyOther = ndf.getNonDeliverableCurrency();
            CurrencyAmount notionalSettle = ndf.getSettlementCurrencyNotional();
            double agreedRate = ndf.getAgreedFxRate().fxRate(ccySettle, ccyOther);
            double rate = provider.fxIndexRates(ndf.getIndex()).rate(ndf.getObservation(), ccySettle);
            return notionalSettle.multipliedBy(1.0 - agreedRate / rate);
        }
        return CurrencyAmount.zero((Currency)ccySettle);
    }

    public FxRate forwardFxRate(ResolvedFxNdf ndf, RatesProvider provider) {
        Currency ccySettle = ndf.getSettlementCurrency();
        Currency ccyOther = ndf.getNonDeliverableCurrency();
        double forwardRate = provider.fxIndexRates(ndf.getIndex()).rate(ndf.getObservation(), ccySettle);
        return FxRate.of((Currency)ccySettle, (Currency)ccyOther, (double)forwardRate);
    }
}

