/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.fx.DiscountingFxSwapProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSwapTrade;

public class DiscountingFxSwapTradePricer {
    public static final DiscountingFxSwapTradePricer DEFAULT = new DiscountingFxSwapTradePricer(DiscountingFxSwapProductPricer.DEFAULT);
    private final DiscountingFxSwapProductPricer productPricer;

    public DiscountingFxSwapTradePricer(DiscountingFxSwapProductPricer productPricer) {
        this.productPricer = (DiscountingFxSwapProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSwapTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFxSwapTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider);
    }

    public double parSpread(ResolvedFxSwapTrade trade, RatesProvider provider) {
        return this.productPricer.parSpread(trade.getProduct(), provider);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedFxSwapTrade trade, RatesProvider provider) {
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSwapTrade trade, RatesProvider provider) {
        return this.productPricer.currencyExposure(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currentCash(ResolvedFxSwapTrade trade, RatesProvider provider) {
        return this.productPricer.currentCash(trade.getProduct(), provider.getValuationDate());
    }
}

