/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionSensitivity;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BlackFxOptionFlatVolatilities
implements BlackFxOptionVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final Curve curve;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static BlackFxOptionFlatVolatilities of(CurrencyPair currencyPair, ZonedDateTime valuationDateTime, Curve curve) {
        return new BlackFxOptionFlatVolatilities(currencyPair, valuationDateTime, curve);
    }

    @ImmutableConstructor
    private BlackFxOptionFlatVolatilities(CurrencyPair currencyPair, ZonedDateTime valuationDateTime, Curve curve) {
        ArgChecker.notNull((Object)currencyPair, (String)"currencyPair");
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.notNull((Object)curve, (String)"curve");
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for Black volatilities");
        curve.getMetadata().getYValueType().checkEquals(ValueType.BLACK_VOLATILITY, "Incorrect y-value type for Black volatilities");
        DayCount dayCount = (DayCount)curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        this.currencyPair = currencyPair;
        this.valuationDateTime = valuationDateTime;
        this.curve = curve;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new BlackFxOptionFlatVolatilities(this.currencyPair, this.valuationDateTime, this.curve);
    }

    @Override
    public FxOptionVolatilitiesName getName() {
        return FxOptionVolatilitiesName.of(this.curve.getName().getName());
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.curve.findParameterIndex(metadata);
    }

    @Override
    public BlackFxOptionFlatVolatilities withParameter(int parameterIndex, double newValue) {
        return new BlackFxOptionFlatVolatilities(this.currencyPair, this.valuationDateTime, this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public BlackFxOptionFlatVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new BlackFxOptionFlatVolatilities(this.currencyPair, this.valuationDateTime, this.curve.withPerturbation(perturbation));
    }

    @Override
    public double volatility(CurrencyPair currencyPair, double expiry, double strike, double forward) {
        return this.curve.yValue(expiry);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            FxOptionSensitivity pt;
            if (!(point instanceof FxOptionSensitivity) || !(pt = (FxOptionSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    @Override
    public ValueDerivatives firstPartialDerivatives(CurrencyPair currencyPair, double expiry, double strike, double forward) {
        double vol = this.volatility(currencyPair, expiry, strike, forward);
        double dVoldStrike = 0.0;
        double dVoldExpiry = this.curve.firstDerivative(expiry);
        return ValueDerivatives.of((double)vol, (DoubleArray)DoubleArray.of((double)dVoldStrike, (double)dVoldExpiry));
    }

    private CurrencyParameterSensitivity parameterSensitivity(FxOptionSensitivity point) {
        double expiry = point.getExpiry();
        UnitParameterSensitivity unitSens = this.curve.yValueParameterSensitivity(expiry);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    @Override
    public double price(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.price(forward, strike, expiry, volatility, putCall.isCall());
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.dayCount.relativeYearFraction(valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BlackFxOptionFlatVolatilities other = (BlackFxOptionFlatVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("BlackFxOptionFlatVolatilities{");
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BlackFxOptionFlatVolatilities> {
        private CurrencyPair currencyPair;
        private ZonedDateTime valuationDateTime;
        private Curve curve;

        private Builder() {
        }

        private Builder(BlackFxOptionFlatVolatilities beanToCopy) {
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.valuationDateTime = beanToCopy.getValuationDateTime();
            this.curve = beanToCopy.getCurve();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (Curve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BlackFxOptionFlatVolatilities build() {
            return new BlackFxOptionFlatVolatilities(this.currencyPair, this.valuationDateTime, this.curve);
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder valuationDateTime(ZonedDateTime valuationDateTime) {
            JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
            this.valuationDateTime = valuationDateTime;
            return this;
        }

        public Builder curve(Curve curve) {
            JodaBeanUtils.notNull((Object)curve, (String)"curve");
            this.curve = curve;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("BlackFxOptionFlatVolatilities.Builder{");
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", BlackFxOptionFlatVolatilities.class, CurrencyPair.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", BlackFxOptionFlatVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<Curve> curve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curve", BlackFxOptionFlatVolatilities.class, Curve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currencyPair", "valuationDateTime", "curve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BlackFxOptionFlatVolatilities> beanType() {
            return BlackFxOptionFlatVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<Curve> curve() {
            return this.curve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return ((BlackFxOptionFlatVolatilities)bean).getCurrencyPair();
                }
                case -949589828: {
                    return ((BlackFxOptionFlatVolatilities)bean).getValuationDateTime();
                }
                case 95027439: {
                    return ((BlackFxOptionFlatVolatilities)bean).getCurve();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

