/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.option.DeltaStrike;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionSensitivity;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import com.opengamma.strata.pricer.fxopt.FxVolatilitySurfaceYearFractionParameterMetadata;
import com.opengamma.strata.pricer.fxopt.SmileDeltaTermStructure;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BlackFxOptionSmileVolatilities
implements BlackFxOptionVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxOptionVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final SmileDeltaTermStructure smile;
    private static final long serialVersionUID = 1L;

    public static BlackFxOptionSmileVolatilities of(FxOptionVolatilitiesName name, CurrencyPair currencyPair, ZonedDateTime valuationTime, SmileDeltaTermStructure smile) {
        return new BlackFxOptionSmileVolatilities(name, currencyPair, valuationTime, smile);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.name.equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.smile.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.smile.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.smile.getParameterMetadata(parameterIndex);
    }

    @Override
    public BlackFxOptionSmileVolatilities withParameter(int parameterIndex, double newValue) {
        return new BlackFxOptionSmileVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.smile.withParameter(parameterIndex, newValue));
    }

    @Override
    public BlackFxOptionSmileVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new BlackFxOptionSmileVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.smile.withPerturbation(perturbation));
    }

    @Override
    public double volatility(CurrencyPair currencyPair, double expiryTime, double strike, double forward) {
        if (currencyPair.isInverse(this.currencyPair)) {
            return this.smile.volatility(expiryTime, 1.0 / strike, 1.0 / forward);
        }
        return this.smile.volatility(expiryTime, strike, forward);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            FxOptionSensitivity pt;
            if (!(point instanceof FxOptionSensitivity) || !(pt = (FxOptionSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    @Override
    public ValueDerivatives firstPartialDerivatives(CurrencyPair currencyPair, double expiry, double strike, double forward) {
        if (currencyPair.isInverse(this.currencyPair)) {
            return this.smile.partialFirstDerivatives(expiry, 1.0 / strike, 1.0 / forward);
        }
        return this.smile.partialFirstDerivatives(expiry, strike, forward);
    }

    private CurrencyParameterSensitivity parameterSensitivity(FxOptionSensitivity point) {
        double expiryTime = point.getExpiry();
        double strike = this.currencyPair.isInverse(point.getCurrencyPair()) ? 1.0 / point.getStrike() : point.getStrike();
        double forward = this.currencyPair.isInverse(point.getCurrencyPair()) ? 1.0 / point.getForward() : point.getForward();
        double pointValue = point.getSensitivity();
        DoubleMatrix bucketedSensi = this.smile.volatilityAndSensitivities(expiryTime, strike, forward).getSensitivities();
        DoubleArray smileExpiries = this.smile.getExpiries();
        List<Optional<Tenor>> smileExpiryTenors = this.smile.getExpiryTenors();
        int nTimes = smileExpiries.size();
        ArrayList<Double> sensiList = new ArrayList<Double>();
        ArrayList<ParameterMetadata> paramList = new ArrayList<ParameterMetadata>();
        DoubleArray deltas = this.smile.getDelta();
        int nDeltas = deltas.size();
        for (int i = 0; i < nTimes; ++i) {
            int j;
            double smileExpiry = smileExpiries.get(i);
            Optional<Tenor> tenorOpt = smileExpiryTenors.get(i);
            int nDeltasTotal = 2 * nDeltas + 1;
            double[] deltasTotal = new double[nDeltasTotal];
            deltasTotal[nDeltas] = 0.5;
            for (j = 0; j < nDeltas; ++j) {
                deltasTotal[j] = 1.0 - deltas.get(j);
                deltasTotal[2 * nDeltas - j] = deltas.get(j);
            }
            for (j = 0; j < nDeltasTotal; ++j) {
                sensiList.add(bucketedSensi.get(i, j) * pointValue);
                DeltaStrike absoluteDelta = DeltaStrike.of((double)deltasTotal[j]);
                ParameterMetadata parameterMetadata = tenorOpt.map(tenor -> FxVolatilitySurfaceYearFractionParameterMetadata.of(smileExpiry, tenor, (Strike)absoluteDelta, this.currencyPair)).orElseGet(() -> FxVolatilitySurfaceYearFractionParameterMetadata.of(smileExpiry, (Strike)absoluteDelta, this.currencyPair));
                paramList.add(parameterMetadata);
            }
        }
        return CurrencyParameterSensitivity.of((MarketDataName)this.name, paramList, (Currency)point.getCurrency(), (DoubleArray)DoubleArray.copyOf(sensiList));
    }

    @Override
    public double price(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.price(forward, strike, expiry, volatility, putCall.isCall());
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.smile.getDayCount().relativeYearFraction(valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BlackFxOptionSmileVolatilities(FxOptionVolatilitiesName name, CurrencyPair currencyPair, ZonedDateTime valuationDateTime, SmileDeltaTermStructure smile) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        JodaBeanUtils.notNull((Object)smile, (String)"smile");
        this.name = name;
        this.currencyPair = currencyPair;
        this.valuationDateTime = valuationDateTime;
        this.smile = smile;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FxOptionVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public SmileDeltaTermStructure getSmile() {
        return this.smile;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BlackFxOptionSmileVolatilities other = (BlackFxOptionSmileVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.smile, (Object)other.smile);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.smile);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("BlackFxOptionSmileVolatilities{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("smile").append('=').append(JodaBeanUtils.toString((Object)this.smile));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BlackFxOptionSmileVolatilities> {
        private FxOptionVolatilitiesName name;
        private CurrencyPair currencyPair;
        private ZonedDateTime valuationDateTime;
        private SmileDeltaTermStructure smile;

        private Builder() {
        }

        private Builder(BlackFxOptionSmileVolatilities beanToCopy) {
            this.name = beanToCopy.getName();
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.valuationDateTime = beanToCopy.getValuationDateTime();
            this.smile = beanToCopy.getSmile();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 109556488: {
                    return this.smile;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (FxOptionVolatilitiesName)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case 109556488: {
                    this.smile = (SmileDeltaTermStructure)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BlackFxOptionSmileVolatilities build() {
            return new BlackFxOptionSmileVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.smile);
        }

        public Builder name(FxOptionVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder valuationDateTime(ZonedDateTime valuationDateTime) {
            JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
            this.valuationDateTime = valuationDateTime;
            return this;
        }

        public Builder smile(SmileDeltaTermStructure smile) {
            JodaBeanUtils.notNull((Object)smile, (String)"smile");
            this.smile = smile;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("BlackFxOptionSmileVolatilities.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("smile").append('=').append(JodaBeanUtils.toString((Object)this.smile));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxOptionVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", BlackFxOptionSmileVolatilities.class, FxOptionVolatilitiesName.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", BlackFxOptionSmileVolatilities.class, CurrencyPair.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", BlackFxOptionSmileVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<SmileDeltaTermStructure> smile = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"smile", BlackFxOptionSmileVolatilities.class, SmileDeltaTermStructure.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currencyPair", "valuationDateTime", "smile"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 109556488: {
                    return this.smile;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BlackFxOptionSmileVolatilities> beanType() {
            return BlackFxOptionSmileVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxOptionVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<SmileDeltaTermStructure> smile() {
            return this.smile;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((BlackFxOptionSmileVolatilities)bean).getName();
                }
                case 1005147787: {
                    return ((BlackFxOptionSmileVolatilities)bean).getCurrencyPair();
                }
                case -949589828: {
                    return ((BlackFxOptionSmileVolatilities)bean).getValuationDateTime();
                }
                case 109556488: {
                    return ((BlackFxOptionSmileVolatilities)bean).getSmile();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

