/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionSensitivity;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BlackFxOptionSurfaceVolatilities
implements BlackFxOptionVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxOptionVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final Surface surface;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static BlackFxOptionSurfaceVolatilities of(CurrencyPair currencyPair, ZonedDateTime valuationDateTime, Surface surface) {
        FxOptionVolatilitiesName name = FxOptionVolatilitiesName.of(surface.getName().getName());
        return BlackFxOptionSurfaceVolatilities.of(name, currencyPair, valuationDateTime, surface);
    }

    public static BlackFxOptionSurfaceVolatilities of(FxOptionVolatilitiesName name, CurrencyPair currencyPair, ZonedDateTime valuationDateTime, Surface surface) {
        return new BlackFxOptionSurfaceVolatilities(name, currencyPair, valuationDateTime, surface);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.name == null && builder.surface != null) {
            builder.name = FxOptionVolatilitiesName.of(builder.surface.getName().getName());
        }
    }

    @ImmutableConstructor
    private BlackFxOptionSurfaceVolatilities(FxOptionVolatilitiesName name, CurrencyPair currencyPair, ZonedDateTime valuationDateTime, Surface surface) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)currencyPair, (String)"currencyPair");
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.notNull((Object)surface, (String)"surface");
        surface.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for Black volatilities");
        surface.getMetadata().getYValueType().checkEquals(ValueType.STRIKE, "Incorrect y-value type for Black volatilities");
        surface.getMetadata().getZValueType().checkEquals(ValueType.BLACK_VOLATILITY, "Incorrect z-value type for Black volatilities");
        DayCount dayCount = (DayCount)surface.getMetadata().findInfo(SurfaceInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect surface metadata, missing DayCount"));
        this.name = name;
        this.currencyPair = currencyPair;
        this.valuationDateTime = valuationDateTime;
        this.surface = surface;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new BlackFxOptionSurfaceVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.surface);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.surface.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.surface));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.surface.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.surface.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.surface.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.surface.findParameterIndex(metadata);
    }

    @Override
    public BlackFxOptionSurfaceVolatilities withParameter(int parameterIndex, double newValue) {
        return new BlackFxOptionSurfaceVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.surface.withParameter(parameterIndex, newValue));
    }

    @Override
    public BlackFxOptionSurfaceVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new BlackFxOptionSurfaceVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.surface.withPerturbation(perturbation));
    }

    @Override
    public double volatility(CurrencyPair currencyPair, double expiry, double strike, double forward) {
        if (currencyPair.isInverse(this.currencyPair)) {
            return this.surface.zValue(expiry, 1.0 / strike);
        }
        return this.surface.zValue(expiry, strike);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            FxOptionSensitivity pt;
            if (!(point instanceof FxOptionSensitivity) || !(pt = (FxOptionSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    @Override
    public ValueDerivatives firstPartialDerivatives(CurrencyPair currencyPair, double expiry, double strike, double forward) {
        if (currencyPair.isInverse(this.currencyPair)) {
            return this.surface.firstPartialDerivatives(expiry, 1.0 / strike);
        }
        return this.surface.firstPartialDerivatives(expiry, strike);
    }

    private CurrencyParameterSensitivity parameterSensitivity(FxOptionSensitivity point) {
        double expiry = point.getExpiry();
        double strike = point.getCurrencyPair().isInverse(this.currencyPair) ? 1.0 / point.getStrike() : point.getStrike();
        UnitParameterSensitivity unitSens = this.surface.zValueParameterSensitivity(expiry, strike);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    @Override
    public double price(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.price(forward, strike, expiry, volatility, putCall.isCall());
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.dayCount.relativeYearFraction(valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FxOptionVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BlackFxOptionSurfaceVolatilities other = (BlackFxOptionSurfaceVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.surface, (Object)other.surface);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.surface);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("BlackFxOptionSurfaceVolatilities{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BlackFxOptionSurfaceVolatilities> {
        private FxOptionVolatilitiesName name;
        private CurrencyPair currencyPair;
        private ZonedDateTime valuationDateTime;
        private Surface surface;

        private Builder() {
        }

        private Builder(BlackFxOptionSurfaceVolatilities beanToCopy) {
            this.name = beanToCopy.getName();
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.valuationDateTime = beanToCopy.getValuationDateTime();
            this.surface = beanToCopy.getSurface();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (FxOptionVolatilitiesName)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case -1853231955: {
                    this.surface = (Surface)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BlackFxOptionSurfaceVolatilities build() {
            BlackFxOptionSurfaceVolatilities.preBuild(this);
            return new BlackFxOptionSurfaceVolatilities(this.name, this.currencyPair, this.valuationDateTime, this.surface);
        }

        public Builder name(FxOptionVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder valuationDateTime(ZonedDateTime valuationDateTime) {
            JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
            this.valuationDateTime = valuationDateTime;
            return this;
        }

        public Builder surface(Surface surface) {
            JodaBeanUtils.notNull((Object)surface, (String)"surface");
            this.surface = surface;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("BlackFxOptionSurfaceVolatilities.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxOptionVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", BlackFxOptionSurfaceVolatilities.class, FxOptionVolatilitiesName.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", BlackFxOptionSurfaceVolatilities.class, CurrencyPair.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", BlackFxOptionSurfaceVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<Surface> surface = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"surface", BlackFxOptionSurfaceVolatilities.class, Surface.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currencyPair", "valuationDateTime", "surface"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BlackFxOptionSurfaceVolatilities> beanType() {
            return BlackFxOptionSurfaceVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxOptionVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<Surface> surface() {
            return this.surface;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((BlackFxOptionSurfaceVolatilities)bean).getName();
                }
                case 1005147787: {
                    return ((BlackFxOptionSurfaceVolatilities)bean).getCurrencyPair();
                }
                case -949589828: {
                    return ((BlackFxOptionSurfaceVolatilities)bean).getValuationDateTime();
                }
                case -1853231955: {
                    return ((BlackFxOptionSurfaceVolatilities)bean).getSurface();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

