/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.DiscountingFxSingleProductPricer;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionSensitivity;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;

public class BlackFxVanillaOptionProductPricer {
    public static final BlackFxVanillaOptionProductPricer DEFAULT = new BlackFxVanillaOptionProductPricer(DiscountingFxSingleProductPricer.DEFAULT);
    private final DiscountingFxSingleProductPricer fxPricer;

    public BlackFxVanillaOptionProductPricer(DiscountingFxSingleProductPricer fxPricer) {
        this.fxPricer = (DiscountingFxSingleProductPricer)ArgChecker.notNull((Object)fxPricer, (String)"fxPricer");
    }

    DiscountingFxSingleProductPricer getDiscountingFxSingleProductPricer() {
        return this.fxPricer;
    }

    public double price(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingle underlying = option.getUnderlying();
        double forwardPrice = this.undiscountedPrice(option, ratesProvider, volatilities);
        double discountFactor = ratesProvider.discountFactor(option.getCounterCurrency(), underlying.getPaymentDate());
        return discountFactor * forwardPrice;
    }

    public CurrencyAmount presentValue(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double price = this.price(option, ratesProvider, volatilities);
        return CurrencyAmount.of((Currency)option.getCounterCurrency(), (double)(this.signedNotional(option) * price));
    }

    private double undiscountedPrice(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        if (timeToExpiry < 0.0) {
            return 0.0;
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        FxRate forward = this.fxPricer.forwardFxRate(underlying, ratesProvider);
        CurrencyPair strikePair = underlying.getCurrencyPair();
        double forwardRate = forward.fxRate(strikePair);
        double strikeRate = option.getStrike();
        boolean isCall = option.getPutCall().isCall();
        if (timeToExpiry == 0.0) {
            return isCall ? Math.max(forwardRate - strikeRate, 0.0) : Math.max(0.0, strikeRate - forwardRate);
        }
        double volatility = volatilities.volatility(strikePair, option.getExpiry(), strikeRate, forwardRate);
        return BlackFormulaRepository.price(forwardRate, strikeRate, timeToExpiry, volatility, isCall);
    }

    public double delta(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingle underlying = option.getUnderlying();
        double fwdDelta = this.undiscountedDelta(option, ratesProvider, volatilities);
        double discountFactor = ratesProvider.discountFactor(option.getCounterCurrency(), underlying.getPaymentDate());
        double fwdRateSpotSensitivity = this.fxPricer.forwardFxRateSpotSensitivity(option.getPutCall().isCall() ? underlying : underlying.inverse(), ratesProvider);
        return fwdDelta * discountFactor * fwdRateSpotSensitivity;
    }

    public CurrencyAmount presentValueDelta(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double delta = this.delta(option, ratesProvider, volatilities);
        return CurrencyAmount.of((Currency)option.getCounterCurrency(), (double)(this.signedNotional(option) * delta));
    }

    public PointSensitivities presentValueSensitivityRatesStickyStrike(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        if (volatilities.relativeTime(option.getExpiry()) < 0.0) {
            return PointSensitivities.empty();
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        double fwdDelta = this.undiscountedDelta(option, ratesProvider, volatilities);
        double discountFactor = ratesProvider.discountFactor(option.getCounterCurrency(), underlying.getPaymentDate());
        double notional = this.signedNotional(option);
        PointSensitivityBuilder fwdSensi = this.fxPricer.forwardFxRatePointSensitivity(option.getPutCall().isCall() ? underlying : underlying.inverse(), ratesProvider).multipliedBy(notional * discountFactor * fwdDelta);
        double fwdPrice = this.undiscountedPrice(option, ratesProvider, volatilities);
        ZeroRateSensitivity dscSensi = ratesProvider.discountFactors(option.getCounterCurrency()).zeroRatePointSensitivity(underlying.getPaymentDate()).multipliedBy(notional * fwdPrice);
        return fwdSensi.combinedWith((PointSensitivityBuilder)dscSensi).build().convertedTo(option.getCounterCurrency(), (FxRateProvider)ratesProvider);
    }

    private double undiscountedDelta(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        if (timeToExpiry < 0.0) {
            return 0.0;
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        FxRate forward = this.fxPricer.forwardFxRate(underlying, ratesProvider);
        CurrencyPair strikePair = underlying.getCurrencyPair();
        double forwardRate = forward.fxRate(strikePair);
        double strikeRate = option.getStrike();
        boolean isCall = option.getPutCall().isCall();
        if (timeToExpiry == 0.0) {
            return isCall ? (forwardRate > strikeRate ? 1.0 : 0.0) : (strikeRate > forwardRate ? -1.0 : 0.0);
        }
        double volatility = volatilities.volatility(strikePair, option.getExpiry(), strikeRate, forwardRate);
        return BlackFormulaRepository.delta(forwardRate, strikeRate, timeToExpiry, volatility, isCall);
    }

    public double gamma(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        if (timeToExpiry <= 0.0) {
            return 0.0;
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        FxRate forward = this.fxPricer.forwardFxRate(underlying, ratesProvider);
        CurrencyPair strikePair = underlying.getCurrencyPair();
        double forwardRate = forward.fxRate(strikePair);
        double strikeRate = option.getStrike();
        double volatility = volatilities.volatility(strikePair, option.getExpiry(), strikeRate, forwardRate);
        double forwardGamma = BlackFormulaRepository.gamma(forwardRate, strikeRate, timeToExpiry, volatility);
        double discountFactor = ratesProvider.discountFactor(option.getCounterCurrency(), underlying.getPaymentDate());
        double fwdRateSpotSensitivity = this.fxPricer.forwardFxRateSpotSensitivity(option.getPutCall().isCall() ? underlying : underlying.inverse(), ratesProvider);
        return forwardGamma * discountFactor * fwdRateSpotSensitivity * fwdRateSpotSensitivity;
    }

    public CurrencyAmount presentValueGamma(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double gamma = this.gamma(option, ratesProvider, volatilities);
        return CurrencyAmount.of((Currency)option.getCounterCurrency(), (double)(this.signedNotional(option) * gamma));
    }

    public double vega(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        if (timeToExpiry <= 0.0) {
            return 0.0;
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        FxRate forward = this.fxPricer.forwardFxRate(underlying, ratesProvider);
        CurrencyPair strikePair = underlying.getCurrencyPair();
        double forwardRate = forward.fxRate(strikePair);
        double strikeRate = option.getStrike();
        double volatility = volatilities.volatility(strikePair, option.getExpiry(), strikeRate, forwardRate);
        double fwdVega = BlackFormulaRepository.vega(forwardRate, strikeRate, timeToExpiry, volatility);
        double discountFactor = ratesProvider.discountFactor(option.getCounterCurrency(), underlying.getPaymentDate());
        return discountFactor * fwdVega;
    }

    public CurrencyAmount presentValueVega(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double vega = this.vega(option, ratesProvider, volatilities);
        return CurrencyAmount.of((Currency)option.getCounterCurrency(), (double)(this.signedNotional(option) * vega));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        if (volatilities.relativeTime(option.getExpiry()) <= 0.0) {
            return PointSensitivityBuilder.none();
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        FxRate forward = this.fxPricer.forwardFxRate(underlying, ratesProvider);
        CurrencyPair strikePair = underlying.getCurrencyPair();
        CurrencyAmount valueVega = this.presentValueVega(option, ratesProvider, volatilities);
        return FxOptionSensitivity.of(volatilities.getName(), strikePair, volatilities.relativeTime(option.getExpiry()), option.getStrike(), forward.fxRate(strikePair), valueVega.getCurrency(), valueVega.getAmount());
    }

    public double theta(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        if (timeToExpiry <= 0.0) {
            return 0.0;
        }
        ResolvedFxSingle underlying = option.getUnderlying();
        FxRate forward = this.fxPricer.forwardFxRate(underlying, ratesProvider);
        CurrencyPair strikePair = underlying.getCurrencyPair();
        double forwardRate = forward.fxRate(strikePair);
        double strikeRate = option.getStrike();
        double volatility = volatilities.volatility(strikePair, option.getExpiry(), strikeRate, forwardRate);
        double fwdTheta = BlackFormulaRepository.driftlessTheta(forwardRate, strikeRate, timeToExpiry, volatility);
        double discountFactor = ratesProvider.discountFactor(option.getCounterCurrency(), underlying.getPaymentDate());
        return discountFactor * fwdTheta;
    }

    public CurrencyAmount presentValueTheta(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double theta = this.theta(option, ratesProvider, volatilities);
        return CurrencyAmount.of((Currency)option.getCounterCurrency(), (double)(this.signedNotional(option) * theta));
    }

    public FxRate forwardFxRate(ResolvedFxVanillaOption option, RatesProvider ratesProvider) {
        return this.fxPricer.forwardFxRate(option.getUnderlying(), ratesProvider);
    }

    public double impliedVolatility(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        if (timeToExpiry <= 0.0) {
            throw new IllegalArgumentException("valuation is after option's expiry.");
        }
        FxRate forward = this.forwardFxRate(option, ratesProvider);
        CurrencyPair strikePair = option.getUnderlying().getCurrencyPair();
        return volatilities.volatility(strikePair, option.getExpiry(), option.getStrike(), forward.fxRate(strikePair));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        CurrencyPair strikePair = option.getUnderlying().getCurrencyPair();
        double price = this.price(option, ratesProvider, volatilities);
        double delta = this.delta(option, ratesProvider, volatilities);
        double spot = ratesProvider.fxRate(strikePair);
        double signedNotional = this.signedNotional(option);
        CurrencyAmount domestic = CurrencyAmount.of((Currency)strikePair.getCounter(), (double)((price - delta * spot) * signedNotional));
        CurrencyAmount foreign = CurrencyAmount.of((Currency)strikePair.getBase(), (double)(delta * signedNotional));
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{domestic, foreign});
    }

    private double signedNotional(ResolvedFxVanillaOption option) {
        return (option.getLongShort().isLong() ? 1.0 : -1.0) * Math.abs(option.getUnderlying().getBaseCurrencyPayment().getAmount());
    }
}

