/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.ImpliedTrinomialTreeFxOptionCalibrator;
import com.opengamma.strata.pricer.fxopt.RecombiningTrinomialTreeData;
import com.opengamma.strata.pricer.impl.tree.ConstantContinuousSingleBarrierKnockoutFunction;
import com.opengamma.strata.pricer.impl.tree.EuropeanVanillaOptionFunction;
import com.opengamma.strata.pricer.impl.tree.TrinomialTree;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOption;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;
import com.opengamma.strata.product.option.SimpleConstantContinuousBarrier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer {
    private static final TrinomialTree TREE = new TrinomialTree();
    private static final double SMALL = 1.0E-12;
    private static final int NUM_STEPS_DEFAULT = 51;
    public static final ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer DEFAULT = new ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer(51);
    private final ImpliedTrinomialTreeFxOptionCalibrator calibrator;

    public ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer() {
        this(51);
    }

    public ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer(int nSteps) {
        this.calibrator = new ImpliedTrinomialTreeFxOptionCalibrator(nSteps);
    }

    public ImpliedTrinomialTreeFxOptionCalibrator getCalibrator() {
        return this.calibrator;
    }

    public double price(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        RecombiningTrinomialTreeData treeData = this.calibrator.calibrateTrinomialTree(option.getUnderlyingOption(), ratesProvider, volatilities);
        return this.price(option, ratesProvider, volatilities, treeData);
    }

    public double price(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities, RecombiningTrinomialTreeData treeData) {
        return this.priceDerivatives(option, ratesProvider, volatilities, treeData).getValue();
    }

    public CurrencyAmount presentValue(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        RecombiningTrinomialTreeData treeData = this.calibrator.calibrateTrinomialTree(option.getUnderlyingOption(), ratesProvider, volatilities);
        return this.presentValue(option, ratesProvider, volatilities, treeData);
    }

    public CurrencyAmount presentValue(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities, RecombiningTrinomialTreeData treeData) {
        double price = this.price(option, ratesProvider, volatilities, treeData);
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        return CurrencyAmount.of((Currency)underlyingOption.getCounterCurrency(), (double)(this.signedNotional(underlyingOption) * price));
    }

    public CurrencyParameterSensitivities presentValueSensitivityRates(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        RecombiningTrinomialTreeData baseTreeData = this.calibrator.calibrateTrinomialTree(option.getUnderlyingOption(), ratesProvider, volatilities);
        return this.presentValueSensitivityRates(option, ratesProvider, volatilities, baseTreeData);
    }

    public CurrencyParameterSensitivities presentValueSensitivityRates(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities, RecombiningTrinomialTreeData baseTreeData) {
        ArgChecker.isTrue((baseTreeData.getNumberOfSteps() == this.calibrator.getNumberOfSteps() ? 1 : 0) != 0, (String)"the number of steps mismatch between pricer and trinomial tree data");
        double shift = 1.0E-5;
        CurrencyAmount pvBase = this.presentValue(option, ratesProvider, volatilities, baseTreeData);
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        ResolvedFxSingle underlyingFx = underlyingOption.getUnderlying();
        CurrencyPair currencyPair = underlyingFx.getCurrencyPair();
        ImmutableRatesProvider immRatesProvider = ratesProvider.toImmutableRatesProvider();
        ImmutableMap<Currency, Curve> baseCurves = immRatesProvider.getDiscountCurves();
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (Map.Entry entry : baseCurves.entrySet()) {
            if (!currencyPair.contains((Currency)entry.getKey())) continue;
            Curve curve = (Curve)entry.getValue();
            int nParams = curve.getParameterCount();
            DoubleArray sensitivity = DoubleArray.of((int)nParams, i -> {
                Curve dscBumped = curve.withParameter(i, curve.getParameter(i) + shift);
                HashMap mapBumped = new HashMap(baseCurves);
                mapBumped.put(entry.getKey(), dscBumped);
                ImmutableRatesProvider providerDscBumped = immRatesProvider.toBuilder().discountCurves(mapBumped).build();
                double pvBumped = this.presentValue(option, providerDscBumped, volatilities).getAmount();
                return (pvBumped - pvBase.getAmount()) / shift;
            });
            result = result.combinedWith(curve.createParameterSensitivity(pvBase.getCurrency(), sensitivity));
        }
        return result;
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        RecombiningTrinomialTreeData treeData = this.calibrator.calibrateTrinomialTree(option.getUnderlyingOption(), ratesProvider, volatilities);
        return this.currencyExposure(option, ratesProvider, volatilities, treeData);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities, RecombiningTrinomialTreeData treeData) {
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities, treeData);
        double price = priceDerivatives.getValue();
        double delta = priceDerivatives.getDerivative(0);
        CurrencyPair currencyPair = underlyingOption.getUnderlying().getCurrencyPair();
        double todayFx = ratesProvider.fxRate(currencyPair);
        double signedNotional = this.signedNotional(underlyingOption);
        CurrencyAmount domestic = CurrencyAmount.of((Currency)currencyPair.getCounter(), (double)((price - delta * todayFx) * signedNotional));
        CurrencyAmount foreign = CurrencyAmount.of((Currency)currencyPair.getBase(), (double)(delta * signedNotional));
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{domestic, foreign});
    }

    private ValueDerivatives priceDerivatives(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities, RecombiningTrinomialTreeData data) {
        this.validate(option, ratesProvider, volatilities);
        this.validateData(option, ratesProvider, volatilities, data);
        int nSteps = data.getNumberOfSteps();
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        double timeToExpiry = data.getTime(nSteps);
        ResolvedFxSingle underlyingFx = underlyingOption.getUnderlying();
        Currency ccyBase = underlyingFx.getCounterCurrencyPayment().getCurrency();
        Currency ccyCounter = underlyingFx.getCounterCurrencyPayment().getCurrency();
        DiscountFactors baseDiscountFactors = ratesProvider.discountFactors(ccyBase);
        DiscountFactors counterDiscountFactors = ratesProvider.discountFactors(ccyCounter);
        double rebateAtExpiry = 0.0;
        double rebateAtExpiryDerivative = 0.0;
        double notional = Math.abs(underlyingFx.getBaseCurrencyPayment().getAmount());
        double[] rebateArray = new double[nSteps + 1];
        SimpleConstantContinuousBarrier barrier = (SimpleConstantContinuousBarrier)option.getBarrier();
        if (option.getRebate().isPresent()) {
            double rebate;
            CurrencyAmount rebateCurrencyAmount = (CurrencyAmount)option.getRebate().get();
            double rebatePerUnit = rebateCurrencyAmount.getAmount() / notional;
            boolean isCounter = rebateCurrencyAmount.getCurrency().equals((Object)ccyCounter);
            double d = rebate = isCounter ? rebatePerUnit : rebatePerUnit * barrier.getBarrierLevel();
            if (barrier.getKnockType().isKnockIn()) {
                double dfCounterAtExpiry = counterDiscountFactors.discountFactor(timeToExpiry);
                double dfBaseAtExpiry = baseDiscountFactors.discountFactor(timeToExpiry);
                for (int i = 0; i < nSteps + 1; ++i) {
                    rebateArray[i] = isCounter ? rebate * dfCounterAtExpiry / counterDiscountFactors.discountFactor(data.getTime(i)) : rebate * dfBaseAtExpiry / baseDiscountFactors.discountFactor(data.getTime(i));
                }
                if (isCounter) {
                    rebateAtExpiry = rebatePerUnit * dfCounterAtExpiry;
                } else {
                    rebateAtExpiry = rebatePerUnit * data.getSpot() * dfBaseAtExpiry;
                    rebateAtExpiryDerivative = rebatePerUnit * dfBaseAtExpiry;
                }
            } else {
                Arrays.fill(rebateArray, rebate);
            }
        }
        ConstantContinuousSingleBarrierKnockoutFunction barrierFunction = ConstantContinuousSingleBarrierKnockoutFunction.of(underlyingOption.getStrike(), timeToExpiry, underlyingOption.getPutCall(), nSteps, barrier.getBarrierType(), barrier.getBarrierLevel(), DoubleArray.ofUnsafe((double[])rebateArray));
        ValueDerivatives barrierPrice = TREE.optionPriceAdjoint(barrierFunction, data);
        if (barrier.getKnockType().isKnockIn()) {
            EuropeanVanillaOptionFunction vanillaFunction = EuropeanVanillaOptionFunction.of(underlyingOption.getStrike(), timeToExpiry, underlyingOption.getPutCall(), nSteps);
            ValueDerivatives vanillaPrice = TREE.optionPriceAdjoint(vanillaFunction, data);
            return ValueDerivatives.of((double)(vanillaPrice.getValue() + rebateAtExpiry - barrierPrice.getValue()), (DoubleArray)DoubleArray.of((double)(vanillaPrice.getDerivative(0) + rebateAtExpiryDerivative - barrierPrice.getDerivative(0))));
        }
        return barrierPrice;
    }

    private void validateData(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities, RecombiningTrinomialTreeData data) {
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        ArgChecker.isTrue((boolean)DoubleMath.fuzzyEquals((double)data.getTime(data.getNumberOfSteps()), (double)volatilities.relativeTime(underlyingOption.getExpiry()), (double)1.0E-12), (String)"time to expiry mismatch between pricing option and trinomial tree data");
        ArgChecker.isTrue((boolean)DoubleMath.fuzzyEquals((double)data.getSpot(), (double)ratesProvider.fxRate(underlyingOption.getUnderlying().getCurrencyPair()), (double)1.0E-12), (String)"today's FX rate mismatch between rates provider and trinomial tree data");
    }

    private void validate(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ArgChecker.isTrue((boolean)(option.getBarrier() instanceof SimpleConstantContinuousBarrier), (String)"barrier should be SimpleConstantContinuousBarrier");
        ArgChecker.isTrue((boolean)ratesProvider.getValuationDate().isEqual(volatilities.getValuationDateTime().toLocalDate()), (String)"Volatility and rate data must be for the same date");
    }

    private double signedNotional(ResolvedFxVanillaOption option) {
        return (option.getLongShort().isLong() ? 1.0 : -1.0) * Math.abs(option.getUnderlying().getBaseCurrencyPayment().getAmount());
    }
}

