/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.option.DeltaStrike;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.TenoredParameterMetadata;
import com.opengamma.strata.pricer.common.GenericVolatilitySurfaceYearFractionParameterMetadata;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SmileDeltaParameters
implements ParameterizedData,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double expiry;
    @PropertyDefinition
    private final DoubleArray delta;
    @PropertyDefinition
    private final DoubleArray volatility;
    @PropertyDefinition
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    private static final long serialVersionUID = 1L;

    public static SmileDeltaParameters of(double expiry, DoubleArray delta, DoubleArray volatility) {
        return SmileDeltaParameters.of(expiry, delta, volatility, SmileDeltaParameters.createParameterMetadata(expiry, null, delta));
    }

    public static SmileDeltaParameters of(double expiry, Tenor expiryTenor, DoubleArray delta, DoubleArray volatility) {
        return SmileDeltaParameters.of(expiry, delta, volatility, SmileDeltaParameters.createParameterMetadata(expiry, expiryTenor, delta));
    }

    public static SmileDeltaParameters of(double expiry, DoubleArray delta, DoubleArray volatility, List<ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)delta, (String)"delta");
        ArgChecker.notNull((Object)volatility, (String)"volatility");
        return new SmileDeltaParameters(expiry, delta, volatility, parameterMetadata);
    }

    public static SmileDeltaParameters of(double expiry, double atmVolatility, DoubleArray delta, DoubleArray riskReversal, DoubleArray strangle) {
        return SmileDeltaParameters.of(expiry, atmVolatility, delta, riskReversal, strangle, SmileDeltaParameters.createParameterMetadata(expiry, null, delta));
    }

    public static SmileDeltaParameters of(double expiry, Tenor expiryTenor, double atmVolatility, DoubleArray delta, DoubleArray riskReversal, DoubleArray strangle) {
        return SmileDeltaParameters.of(expiry, atmVolatility, delta, riskReversal, strangle, SmileDeltaParameters.createParameterMetadata(expiry, expiryTenor, delta));
    }

    public static SmileDeltaParameters of(double expiry, double atmVolatility, DoubleArray delta, DoubleArray riskReversal, DoubleArray strangle, List<ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)delta, (String)"delta");
        ArgChecker.notNull((Object)riskReversal, (String)"riskReversal");
        ArgChecker.notNull((Object)strangle, (String)"strangle");
        int nbDelta = delta.size();
        ArgChecker.isTrue((nbDelta == riskReversal.size() ? 1 : 0) != 0, (String)"Length of delta {} should be equal to length of riskReversal {}", (Object[])new Object[]{delta.size(), riskReversal.size()});
        ArgChecker.isTrue((nbDelta == strangle.size() ? 1 : 0) != 0, (String)"Length of delta {} should be equal to length of strangle {} ", (Object[])new Object[]{delta.size(), strangle.size()});
        double[] volatility = new double[2 * nbDelta + 1];
        volatility[nbDelta] = atmVolatility;
        for (int i = 0; i < nbDelta; ++i) {
            volatility[i] = strangle.get(i) + atmVolatility - riskReversal.get(i) / 2.0;
            volatility[2 * nbDelta - i] = strangle.get(i) + atmVolatility + riskReversal.get(i) / 2.0;
        }
        return SmileDeltaParameters.of(expiry, delta, DoubleArray.ofUnsafe((double[])volatility), parameterMetadata);
    }

    private static ImmutableList<ParameterMetadata> createParameterMetadata(double expiry, Tenor expiryTenor, DoubleArray delta) {
        ArgChecker.notNull((Object)delta, (String)"delta");
        int nbDelta = delta.size();
        Object[] paramMetadata = new ParameterMetadata[2 * nbDelta + 1];
        DeltaStrike strikeAtm = DeltaStrike.of((double)0.5);
        paramMetadata[nbDelta] = GenericVolatilitySurfaceYearFractionParameterMetadata.of(expiry, expiryTenor, (Strike)strikeAtm);
        for (int i = 0; i < nbDelta; ++i) {
            DeltaStrike strikePut = DeltaStrike.of((double)(1.0 - delta.get(i)));
            paramMetadata[i] = GenericVolatilitySurfaceYearFractionParameterMetadata.of(expiry, expiryTenor, (Strike)strikePut);
            DeltaStrike strikeCall = DeltaStrike.of((double)delta.get(i));
            paramMetadata[2 * nbDelta - i] = GenericVolatilitySurfaceYearFractionParameterMetadata.of(expiry, expiryTenor, (Strike)strikeCall);
        }
        return ImmutableList.copyOf((Object[])paramMetadata);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.parameterMetadata == null && builder.delta != null) {
            builder.parameterMetadata = SmileDeltaParameters.createParameterMetadata(builder.expiry, null, builder.delta);
        }
    }

    @ImmutableValidator
    private void validate() {
        int nbDelta = this.delta.size();
        ArgChecker.isTrue((2 * nbDelta + 1 == this.volatility.size() ? 1 : 0) != 0, (String)"Length of delta {} should be coherent with volatility length {}", (Object[])new Object[]{2 * this.delta.size() + 1, this.volatility.size()});
        ArgChecker.isTrue((2 * nbDelta + 1 == this.parameterMetadata.size() ? 1 : 0) != 0, (String)"Length of delta {} should be coherent with parameterMetadata length {}", (Object[])new Object[]{2 * this.delta.size() + 1, this.parameterMetadata.size()});
        if (nbDelta > 1) {
            for (int i = 1; i < nbDelta; ++i) {
                ArgChecker.isTrue((this.delta.get(i - 1) < this.delta.get(i) ? 1 : 0) != 0, (String)"delta should be sorted in ascending order");
            }
        }
    }

    public int getParameterCount() {
        return this.volatility.size();
    }

    public double getParameter(int parameterIndex) {
        return this.volatility.get(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return (ParameterMetadata)this.parameterMetadata.get(parameterIndex);
    }

    public SmileDeltaParameters withParameter(int parameterIndex, double newValue) {
        return new SmileDeltaParameters(this.expiry, this.delta, this.volatility.with(parameterIndex, newValue), (List<ParameterMetadata>)this.parameterMetadata);
    }

    public SmileDeltaParameters withPerturbation(ParameterPerturbation perturbation) {
        int size = this.volatility.size();
        DoubleArray perturbedValues = DoubleArray.of((int)size, i -> perturbation.perturbParameter(i, this.volatility.get(i), this.getParameterMetadata(i)));
        return new SmileDeltaParameters(this.expiry, this.delta, perturbedValues, (List<ParameterMetadata>)this.parameterMetadata);
    }

    public DoubleArray strike(double forward) {
        int nbDelta = this.delta.size();
        double[] strike = new double[2 * nbDelta + 1];
        strike[nbDelta] = forward * Math.exp(this.volatility.get(nbDelta) * this.volatility.get(nbDelta) * this.expiry / 2.0);
        for (int loopdelta = 0; loopdelta < nbDelta; ++loopdelta) {
            strike[loopdelta] = BlackFormulaRepository.impliedStrike(-this.delta.get(loopdelta), false, forward, this.expiry, this.volatility.get(loopdelta));
            strike[2 * nbDelta - loopdelta] = BlackFormulaRepository.impliedStrike(this.delta.get(loopdelta), true, forward, this.expiry, this.volatility.get(2 * nbDelta - loopdelta));
        }
        return DoubleArray.ofUnsafe((double[])strike);
    }

    public DoubleArray impliedStrikesDerivativeToExpiry(double forward) {
        int nbDelta = this.delta.size();
        double[] dStrikedTime = new double[2 * nbDelta + 1];
        double atmVol = this.volatility.get(nbDelta);
        dStrikedTime[nbDelta] = forward * atmVol * atmVol * Math.exp(atmVol * atmVol * this.expiry / 2.0) / 2.0;
        for (int loopdelta = 0; loopdelta < nbDelta; ++loopdelta) {
            double[] valueDerivatives = new double[4];
            BlackFormulaRepository.impliedStrike(-this.delta.get(loopdelta), false, forward, this.expiry, this.volatility.get(loopdelta), valueDerivatives);
            dStrikedTime[loopdelta] = valueDerivatives[2];
            BlackFormulaRepository.impliedStrike(this.delta.get(loopdelta), true, forward, this.expiry, this.volatility.get(2 * nbDelta - loopdelta), valueDerivatives);
            dStrikedTime[2 * nbDelta - loopdelta] = valueDerivatives[2];
        }
        return DoubleArray.ofUnsafe((double[])dStrikedTime);
    }

    public DoubleArray impliedStrikesDerivativeToSmileVols(double forward) {
        int nbDelta = this.delta.size();
        double[] dStrikedVol = new double[2 * nbDelta + 1];
        double[] valueDerivatives = new double[4];
        double atmVol = this.volatility.get(nbDelta);
        dStrikedVol[nbDelta] = atmVol * this.expiry * forward * Math.exp(atmVol * atmVol * this.expiry / 2.0);
        for (int loopdelta = 0; loopdelta < nbDelta; ++loopdelta) {
            BlackFormulaRepository.impliedStrike(-this.delta.get(loopdelta), false, forward, this.expiry, this.volatility.get(loopdelta), valueDerivatives);
            dStrikedVol[loopdelta] = valueDerivatives[3];
            BlackFormulaRepository.impliedStrike(this.delta.get(loopdelta), true, forward, this.expiry, this.volatility.get(2 * nbDelta - loopdelta), valueDerivatives);
            dStrikedVol[2 * nbDelta - loopdelta] = valueDerivatives[3];
        }
        return DoubleArray.ofUnsafe((double[])dStrikedVol);
    }

    public Optional<Tenor> getExpiryTenor() {
        ParameterMetadata meta = (ParameterMetadata)this.parameterMetadata.get(0);
        if (meta instanceof TenoredParameterMetadata) {
            return Optional.of(((TenoredParameterMetadata)meta).getTenor());
        }
        if (meta instanceof GenericVolatilitySurfaceYearFractionParameterMetadata) {
            return ((GenericVolatilitySurfaceYearFractionParameterMetadata)meta).getYearFractionTenor();
        }
        return Optional.empty();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SmileDeltaParameters(double expiry, DoubleArray delta, DoubleArray volatility, List<ParameterMetadata> parameterMetadata) {
        this.expiry = expiry;
        this.delta = delta;
        this.volatility = volatility;
        this.parameterMetadata = parameterMetadata != null ? ImmutableList.copyOf(parameterMetadata) : null;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getExpiry() {
        return this.expiry;
    }

    public DoubleArray getDelta() {
        return this.delta;
    }

    public DoubleArray getVolatility() {
        return this.volatility;
    }

    public ImmutableList<ParameterMetadata> getParameterMetadata() {
        return this.parameterMetadata;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SmileDeltaParameters other = (SmileDeltaParameters)obj;
            return JodaBeanUtils.equal((double)this.expiry, (double)other.expiry) && JodaBeanUtils.equal((Object)this.delta, (Object)other.delta) && JodaBeanUtils.equal((Object)this.volatility, (Object)other.volatility) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.delta);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatility);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SmileDeltaParameters{");
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("delta").append('=').append(JodaBeanUtils.toString((Object)this.delta)).append(',').append(' ');
        buf.append("volatility").append('=').append(JodaBeanUtils.toString((Object)this.volatility)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SmileDeltaParameters> {
        private double expiry;
        private DoubleArray delta;
        private DoubleArray volatility;
        private List<ParameterMetadata> parameterMetadata;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1289159373: {
                    return this.expiry;
                }
                case 95468472: {
                    return this.delta;
                }
                case -1917967323: {
                    return this.volatility;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1289159373: {
                    this.expiry = (Double)newValue;
                    break;
                }
                case 95468472: {
                    this.delta = (DoubleArray)newValue;
                    break;
                }
                case -1917967323: {
                    this.volatility = (DoubleArray)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SmileDeltaParameters build() {
            SmileDeltaParameters.preBuild(this);
            return new SmileDeltaParameters(this.expiry, this.delta, this.volatility, this.parameterMetadata);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SmileDeltaParameters.Builder{");
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("delta").append('=').append(JodaBeanUtils.toString((Object)this.delta)).append(',').append(' ');
            buf.append("volatility").append('=').append(JodaBeanUtils.toString((Object)this.volatility)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", SmileDeltaParameters.class, Double.TYPE);
        private final MetaProperty<DoubleArray> delta = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"delta", SmileDeltaParameters.class, DoubleArray.class);
        private final MetaProperty<DoubleArray> volatility = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatility", SmileDeltaParameters.class, DoubleArray.class);
        private final MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", SmileDeltaParameters.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"expiry", "delta", "volatility", "parameterMetadata"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1289159373: {
                    return this.expiry;
                }
                case 95468472: {
                    return this.delta;
                }
                case -1917967323: {
                    return this.volatility;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SmileDeltaParameters> builder() {
            return new Builder();
        }

        public Class<? extends SmileDeltaParameters> beanType() {
            return SmileDeltaParameters.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> expiry() {
            return this.expiry;
        }

        public MetaProperty<DoubleArray> delta() {
            return this.delta;
        }

        public MetaProperty<DoubleArray> volatility() {
            return this.volatility;
        }

        public MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1289159373: {
                    return ((SmileDeltaParameters)bean).getExpiry();
                }
                case 95468472: {
                    return ((SmileDeltaParameters)bean).getDelta();
                }
                case -1917967323: {
                    return ((SmileDeltaParameters)bean).getVolatility();
                }
                case -1169106440: {
                    return ((SmileDeltaParameters)bean).getParameterMetadata();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

