/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.pricer.fxopt.SmileAndBucketedSensitivities;
import com.opengamma.strata.pricer.fxopt.SmileDeltaParameters;
import com.opengamma.strata.pricer.fxopt.VolatilityAndBucketedSensitivities;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface SmileDeltaTermStructure
extends ParameterizedData {
    public DayCount getDayCount();

    default public int getSmileCount() {
        return this.getVolatilityTerm().size();
    }

    default public int getStrikeCount() {
        return ((SmileDeltaParameters)this.getVolatilityTerm().get(0)).getVolatility().size();
    }

    default public DoubleArray getDelta() {
        return ((SmileDeltaParameters)this.getVolatilityTerm().get(0)).getDelta();
    }

    public ImmutableList<SmileDeltaParameters> getVolatilityTerm();

    public DoubleArray getExpiries();

    default public List<Optional<Tenor>> getExpiryTenors() {
        return Collections.nCopies(this.getExpiries().size(), Optional.empty());
    }

    default public DoubleArray getDeltaFull() {
        int nbDelta = this.getDelta().size();
        double[] result = new double[2 * nbDelta + 1];
        for (int loopdelta = 0; loopdelta < nbDelta; ++loopdelta) {
            result[loopdelta] = this.getDelta().get(loopdelta);
            result[nbDelta + 1 + loopdelta] = 1.0 - this.getDelta().get(nbDelta - 1 - loopdelta);
        }
        result[nbDelta] = 0.5;
        return DoubleArray.ofUnsafe((double[])result);
    }

    public double volatility(double var1, double var3, double var5);

    public VolatilityAndBucketedSensitivities volatilityAndSensitivities(double var1, double var3, double var5);

    public ValueDerivatives partialFirstDerivatives(double var1, double var3, double var5);

    public SmileDeltaParameters smileForExpiry(double var1);

    public SmileAndBucketedSensitivities smileAndSensitivitiesForExpiry(double var1, DoubleArray var3);

    public SmileDeltaTermStructure withParameter(int var1, double var2);

    public SmileDeltaTermStructure withPerturbation(ParameterPerturbation var1);
}

