/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.cms;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.cms.CmsPeriodType;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapIndex;
import com.opengamma.strata.product.swap.SwapLegType;
import java.time.LocalDate;
import java.util.OptionalDouble;

public final class BlackFlatCmsPeriodPricer {
    private final DiscountingSwapProductPricer swapPricer;
    static final double EPS = 1.0E-4;

    public static BlackFlatCmsPeriodPricer of(DiscountingSwapProductPricer swapPricer) {
        return new BlackFlatCmsPeriodPricer(swapPricer);
    }

    private BlackFlatCmsPeriodPricer(DiscountingSwapProductPricer swapPricer) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
    }

    public CurrencyAmount presentValue(CmsPeriod cmsPeriod, RatesProvider provider, SwaptionVolatilities swaptionVolatilities) {
        Currency ccy = cmsPeriod.getCurrency();
        LocalDate valuationDate = provider.getValuationDate();
        if (valuationDate.isAfter(cmsPeriod.getPaymentDate())) {
            return CurrencyAmount.zero((Currency)ccy);
        }
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        if (!fixingDate.isAfter(valuationDate)) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                double payoff = 0.0;
                switch (cmsPeriod.getCmsPeriodType()) {
                    case CAPLET: {
                        payoff = Math.max(fixedRate.getAsDouble() - cmsPeriod.getStrike(), 0.0);
                        break;
                    }
                    case FLOORLET: {
                        payoff = Math.max(cmsPeriod.getStrike() - fixedRate.getAsDouble(), 0.0);
                        break;
                    }
                    case COUPON: {
                        payoff = fixedRate.getAsDouble();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported CMS type");
                    }
                }
                return CurrencyAmount.of((Currency)ccy, (double)(payoff * dfPayment * cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
            }
            if (fixingDate.isBefore(valuationDate)) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        if (!cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON)) {
            throw new IllegalArgumentException("Unable to price cap or floor in this pricer");
        }
        SwapIndex index = cmsPeriod.getIndex();
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        ResolvedSwapLeg fixedLeg = (ResolvedSwapLeg)swap.getLegs(SwapLegType.FIXED).get(0);
        int nbFixedPaymentYear = (int)Math.round(1.0 / ((RateAccrualPeriod)((RatePaymentPeriod)fixedLeg.getPaymentPeriods().get(0)).getAccrualPeriods().get(0)).getYearFraction());
        int nbFixedPeriod = fixedLeg.getPaymentPeriods().size();
        double forward = this.swapPricer.parRate(swap, provider);
        double tenor = swaptionVolatilities.tenor(swap.getStartDate(), swap.getEndDate());
        double expiryTime = swaptionVolatilities.relativeTime(fixingDate.atTime(index.getFixingTime()).atZone(index.getFixingZone()));
        double volatility = swaptionVolatilities.volatility(expiryTime, tenor, forward, forward);
        ValueDerivatives annuityDerivatives = this.swapPricer.getLegPricer().annuityCash2(nbFixedPaymentYear, nbFixedPeriod, volatility);
        double forwardAdjustment = -0.5 * forward * forward * volatility * volatility * expiryTime * annuityDerivatives.getDerivative(1) / annuityDerivatives.getDerivative(0);
        return CurrencyAmount.of((Currency)ccy, (double)((forward + forwardAdjustment) * dfPayment * cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
    }
}

