/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.cms;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.cms.CmsPeriodType;
import com.opengamma.strata.product.swap.ResolvedSwap;
import java.time.LocalDate;
import java.util.OptionalDouble;

public class DiscountingCmsPeriodPricer {
    public static final DiscountingCmsPeriodPricer DEFAULT = new DiscountingCmsPeriodPricer(DiscountingSwapProductPricer.DEFAULT);
    private final DiscountingSwapProductPricer swapPricer;

    public DiscountingCmsPeriodPricer(DiscountingSwapProductPricer swapPricer) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"legPricer");
    }

    public CurrencyAmount presentValue(CmsPeriod cmsPeriod, RatesProvider provider) {
        Currency ccy = cmsPeriod.getCurrency();
        LocalDate valuationDate = provider.getValuationDate();
        if (valuationDate.isAfter(cmsPeriod.getPaymentDate())) {
            return CurrencyAmount.zero((Currency)ccy);
        }
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        if (!fixingDate.isAfter(valuationDate)) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                double payoff = 0.0;
                switch (cmsPeriod.getCmsPeriodType()) {
                    case CAPLET: {
                        payoff = Math.max(fixedRate.getAsDouble() - cmsPeriod.getStrike(), 0.0);
                        break;
                    }
                    case FLOORLET: {
                        payoff = Math.max(cmsPeriod.getStrike() - fixedRate.getAsDouble(), 0.0);
                        break;
                    }
                    case COUPON: {
                        payoff = fixedRate.getAsDouble();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported CMS type");
                    }
                }
                return CurrencyAmount.of((Currency)ccy, (double)(payoff * dfPayment * cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
            }
            if (fixingDate.isBefore(valuationDate)) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        if (!cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON)) {
            throw new IllegalArgumentException("Unable to price cap or floor in this pricer");
        }
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        double forward = this.swapPricer.parRate(swap, provider);
        return CurrencyAmount.of((Currency)ccy, (double)(forward * dfPayment * cmsPeriod.getNotional() * cmsPeriod.getYearFraction()));
    }

    public double forwardRate(CmsPeriod cmsPeriod, RatesProvider provider) {
        LocalDate valuationDate;
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        if (!fixingDate.isAfter(valuationDate = provider.getValuationDate())) {
            throw new IllegalArgumentException("Forward rate is availaible only for valuation date after the fixing date");
        }
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        return this.swapPricer.parRate(swap, provider);
    }

    public PointSensitivityBuilder presentValueSensitivity(CmsPeriod cmsPeriod, RatesProvider provider) {
        Currency ccy = cmsPeriod.getCurrency();
        LocalDate valuationDate = provider.getValuationDate();
        if (valuationDate.isAfter(cmsPeriod.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        LocalDate fixingDate = cmsPeriod.getFixingDate();
        double dfPayment = provider.discountFactor(ccy, cmsPeriod.getPaymentDate());
        if (!fixingDate.isAfter(valuationDate)) {
            OptionalDouble fixedRate = provider.timeSeries((Index)cmsPeriod.getIndex()).get(fixingDate);
            if (fixedRate.isPresent()) {
                double payoff = 0.0;
                switch (cmsPeriod.getCmsPeriodType()) {
                    case CAPLET: {
                        payoff = Math.max(fixedRate.getAsDouble() - cmsPeriod.getStrike(), 0.0);
                        break;
                    }
                    case FLOORLET: {
                        payoff = Math.max(cmsPeriod.getStrike() - fixedRate.getAsDouble(), 0.0);
                        break;
                    }
                    case COUPON: {
                        payoff = fixedRate.getAsDouble();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported CMS type");
                    }
                }
                return provider.discountFactors(ccy).zeroRatePointSensitivity(cmsPeriod.getPaymentDate()).multipliedBy(payoff * cmsPeriod.getNotional() * cmsPeriod.getYearFraction());
            }
            if (fixingDate.isBefore(valuationDate)) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{cmsPeriod.getIndex(), fixingDate}));
            }
        }
        if (!cmsPeriod.getCmsPeriodType().equals((Object)CmsPeriodType.COUPON)) {
            throw new IllegalArgumentException("Unable to price cap or floor in this pricer");
        }
        ResolvedSwap swap = cmsPeriod.getUnderlyingSwap();
        ZeroRateSensitivity dfPaymentdr = provider.discountFactors(ccy).zeroRatePointSensitivity(cmsPeriod.getPaymentDate());
        double forward = this.swapPricer.parRate(swap, provider);
        PointSensitivityBuilder forwardSensi = this.swapPricer.parRateSensitivity(swap, provider);
        return forwardSensi.multipliedBy(dfPayment).combinedWith((PointSensitivityBuilder)dfPaymentdr.multipliedBy(forward)).multipliedBy(cmsPeriod.getNotional() * cmsPeriod.getYearFraction());
    }
}

