/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.product.option.SimpleConstantContinuousBarrier;

public class BlackBarrierPriceFormulaRepository {
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double SMALL = 1.0E-6;

    public double price(double spot, double strike, double timeToExpiry, double costOfCarry, double rate, double lognormalVol, boolean isCall, SimpleConstantContinuousBarrier barrier) {
        ArgChecker.notNull((Object)barrier, (String)"barrier");
        boolean isKnockIn = barrier.getKnockType().isKnockIn();
        boolean isDown = barrier.getBarrierType().isDown();
        double h = barrier.getBarrierLevel();
        ArgChecker.isFalse((isDown && spot <= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (DOWN and spot<=barrier).");
        ArgChecker.isFalse((!isDown && spot >= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (UP and spot>=barrier).");
        int phi = isCall ? 1 : -1;
        double eta = isDown ? 1.0 : -1.0;
        double df1 = Math.exp(timeToExpiry * (costOfCarry - rate));
        double df2 = Math.exp(-rate * timeToExpiry);
        double sigmaSq = lognormalVol * lognormalVol;
        double sigmaT = lognormalVol * Math.sqrt(timeToExpiry);
        if (MathUtils.nearZero((double)Math.min(timeToExpiry, sigmaSq), (double)1.0E-6)) {
            if (isKnockIn) {
                return 0.0;
            }
            double dscFwd = df1 * spot;
            double dscStr = df2 * strike;
            return isCall ? (dscFwd >= dscStr ? dscFwd - dscStr : 0.0) : (dscStr >= dscFwd ? dscStr - dscFwd : 0.0);
        }
        double mu = (costOfCarry - 0.5 * sigmaSq) / sigmaSq;
        double m1 = sigmaT * (1.0 + mu);
        double x1 = Math.log(spot / strike) / sigmaT + m1;
        double x2 = Math.log(spot / h) / sigmaT + m1;
        double y1 = Math.log(h * h / spot / strike) / sigmaT + m1;
        double y2 = Math.log(h / spot) / sigmaT + m1;
        double xA = this.getA(spot, strike, df1, df2, x1, sigmaT, phi);
        double xB = this.getA(spot, strike, df1, df2, x2, sigmaT, phi);
        double xC = this.getC(spot, strike, df1, df2, y1, sigmaT, h, mu, phi, eta);
        double xD = this.getC(spot, strike, df1, df2, y2, sigmaT, h, mu, phi, eta);
        if (isKnockIn) {
            if (isDown) {
                if (isCall) {
                    return strike > h ? xC : xA - xB + xD;
                }
                return strike > h ? xB - xC + xD : xA;
            }
            if (isCall) {
                return strike > h ? xA : xB - xC + xD;
            }
            return strike > h ? xA - xB + xD : xC;
        }
        if (isDown) {
            if (isCall) {
                return strike > h ? xA - xC : xB - xD;
            }
            return strike > h ? xA - xB + xC - xD : 0.0;
        }
        if (isCall) {
            return strike > h ? 0.0 : xA - xB + xC - xD;
        }
        return strike > h ? xB - xD : xA - xC;
    }

    public ValueDerivatives priceAdjoint(double spot, double strike, double timeToExpiry, double costOfCarry, double rate, double lognormalVol, boolean isCall, SimpleConstantContinuousBarrier barrier) {
        double price;
        ArgChecker.notNull((Object)barrier, (String)"barrier");
        double[] derivatives = new double[7];
        boolean isKnockIn = barrier.getKnockType().isKnockIn();
        boolean isDown = barrier.getBarrierType().isDown();
        double h = barrier.getBarrierLevel();
        ArgChecker.isFalse((isDown && spot <= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (DOWN and spot<=barrier).");
        ArgChecker.isFalse((!isDown && spot >= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (UP and spot>=barrier).");
        int phi = isCall ? 1 : -1;
        double eta = isDown ? 1.0 : -1.0;
        double df1 = Math.exp(timeToExpiry * (costOfCarry - rate));
        double df2 = Math.exp(-rate * timeToExpiry);
        double lognormalVolSq = lognormalVol * lognormalVol;
        double lognormalVolT = lognormalVol * Math.sqrt(timeToExpiry);
        if (MathUtils.nearZero((double)Math.min(timeToExpiry, lognormalVolSq), (double)1.0E-6)) {
            if (isKnockIn) {
                return ValueDerivatives.of((double)0.0, (DoubleArray)DoubleArray.filled((int)7));
            }
            double dscFwd = df1 * spot;
            double dscStr = df2 * strike;
            double price2 = 0.0;
            if (isCall) {
                if (dscFwd >= dscStr) {
                    price2 = dscFwd - dscStr;
                    derivatives[0] = df1;
                    derivatives[1] = -df2;
                    derivatives[2] = -timeToExpiry * price2;
                    derivatives[3] = timeToExpiry * dscFwd;
                    derivatives[5] = (costOfCarry - rate) * dscFwd + rate * dscStr;
                }
            } else if (dscStr >= dscFwd) {
                price2 = dscStr - dscFwd;
                derivatives[0] = -df1;
                derivatives[1] = df2;
                derivatives[2] = -timeToExpiry * price2;
                derivatives[3] = -timeToExpiry * dscFwd;
                derivatives[5] = -rate * dscStr - (costOfCarry - rate) * dscFwd;
            }
            return ValueDerivatives.of((double)price2, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
        }
        double mu = (costOfCarry - 0.5 * lognormalVolSq) / lognormalVolSq;
        double m1 = lognormalVolT * (1.0 + mu);
        double x1 = Math.log(spot / strike) / lognormalVolT + m1;
        double x2 = Math.log(spot / h) / lognormalVolT + m1;
        double y1 = Math.log(h * h / spot / strike) / lognormalVolT + m1;
        double y2 = Math.log(h / spot) / lognormalVolT + m1;
        double[] aDerivFirst = new double[6];
        double[][] aDerivSecond = new double[2][2];
        double xA = this.getAAdjoint(spot, strike, df1, df2, x1, lognormalVolT, phi, aDerivFirst, aDerivSecond);
        double[] bDerivFirst = new double[6];
        double[][] bDerivSecond = new double[2][2];
        double xB = this.getAAdjoint(spot, strike, df1, df2, x2, lognormalVolT, phi, bDerivFirst, bDerivSecond);
        double[] cDerivFirst = new double[7];
        double[][] cDerivSecond = new double[2][2];
        double xC = this.getCAdjoint(spot, strike, df1, df2, y1, lognormalVolT, h, mu, phi, eta, cDerivFirst, cDerivSecond);
        double[] dDerivFirst = new double[7];
        double[][] dDerivSecond = new double[2][2];
        double xD = this.getCAdjoint(spot, strike, df1, df2, y2, lognormalVolT, h, mu, phi, eta, dDerivFirst, dDerivSecond);
        double xDBar = 0.0;
        double xCBar = 0.0;
        double xBBar = 0.0;
        double xABar = 0.0;
        if (isKnockIn) {
            if (isDown) {
                if (isCall) {
                    if (strike > h) {
                        xCBar = 1.0;
                        price = xC;
                    } else {
                        xABar = 1.0;
                        xBBar = -1.0;
                        xDBar = 1.0;
                        price = xA - xB + xD;
                    }
                } else if (strike > h) {
                    xBBar = 1.0;
                    xCBar = -1.0;
                    xDBar = 1.0;
                    price = xB - xC + xD;
                } else {
                    xABar = 1.0;
                    price = xA;
                }
            } else if (isCall) {
                if (strike > h) {
                    xABar = 1.0;
                    price = xA;
                } else {
                    xBBar = 1.0;
                    xCBar = -1.0;
                    xDBar = 1.0;
                    price = xB - xC + xD;
                }
            } else if (strike > h) {
                xABar = 1.0;
                xBBar = -1.0;
                xDBar = 1.0;
                price = xA - xB + xD;
            } else {
                xCBar = 1.0;
                price = xC;
            }
        } else if (isDown) {
            if (isCall) {
                if (strike > h) {
                    xABar = 1.0;
                    xCBar = -1.0;
                    price = xA - xC;
                } else {
                    xBBar = 1.0;
                    xDBar = -1.0;
                    price = xB - xD;
                }
            } else if (strike > h) {
                xABar = 1.0;
                xBBar = -1.0;
                xCBar = 1.0;
                xDBar = -1.0;
                price = xA - xB + xC - xD;
            } else {
                price = 0.0;
            }
        } else if (isCall) {
            if (strike > h) {
                price = 0.0;
            } else {
                xABar = 1.0;
                xBBar = -1.0;
                xCBar = 1.0;
                xDBar = -1.0;
                price = xA - xB + xC - xD;
            }
        } else if (strike > h) {
            xBBar = 1.0;
            xDBar = -1.0;
            price = xB - xD;
        } else {
            xABar = 1.0;
            xCBar = -1.0;
            price = xA - xC;
        }
        double dxyds = 1.0 / spot / lognormalVolT;
        double x1Bar = aDerivFirst[4] * xABar;
        double x2Bar = bDerivFirst[4] * xBBar;
        double y1Bar = cDerivFirst[4] * xCBar;
        double y2Bar = dDerivFirst[4] * xDBar;
        double m1Bar = x1Bar + x2Bar + y1Bar + y2Bar;
        double muBar = cDerivFirst[6] * xCBar + dDerivFirst[6] * xDBar + lognormalVolT * m1Bar;
        double lognormalVolTBar = aDerivFirst[5] * xABar + bDerivFirst[5] * xBBar + cDerivFirst[5] * xCBar + dDerivFirst[5] * xDBar - Math.log(h / spot) / (lognormalVolT * lognormalVolT) * y2Bar - Math.log(h * h / spot / strike) / (lognormalVolT * lognormalVolT) * y1Bar - Math.log(spot / h) / (lognormalVolT * lognormalVolT) * x2Bar - Math.log(spot / strike) / (lognormalVolT * lognormalVolT) * x1Bar + (1.0 + mu) * m1Bar;
        double lognormalVolSqBar = -costOfCarry / (lognormalVolSq * lognormalVolSq) * muBar;
        double df2Bar = aDerivFirst[3] * xABar + bDerivFirst[3] * xBBar + cDerivFirst[3] * xCBar + dDerivFirst[3] * xDBar;
        double df1Bar = aDerivFirst[2] * xABar + bDerivFirst[2] * xBBar + cDerivFirst[2] * xCBar + dDerivFirst[2] * xDBar;
        derivatives[0] = aDerivFirst[0] * xABar + bDerivFirst[0] * xBBar + cDerivFirst[0] * xCBar + dDerivFirst[0] * xDBar + x1Bar * dxyds + x2Bar * dxyds - y1Bar * dxyds - y2Bar * dxyds;
        derivatives[1] = aDerivFirst[1] * xABar + bDerivFirst[1] * xBBar + cDerivFirst[1] * xCBar + dDerivFirst[1] * xDBar - (x1Bar + y1Bar) / strike / lognormalVolT;
        derivatives[2] = -timeToExpiry * (df1 * df1Bar + df2 * df2Bar);
        derivatives[3] = timeToExpiry * df1 * df1Bar + muBar / lognormalVolSq;
        derivatives[4] = 2.0 * lognormalVol * lognormalVolSqBar + Math.sqrt(timeToExpiry) * lognormalVolTBar;
        derivatives[5] = (costOfCarry - rate) * df1 * df1Bar - rate * df2 * df2Bar + lognormalVolTBar * lognormalVolT * 0.5 / timeToExpiry;
        derivatives[6] = aDerivSecond[0][0] * xABar + bDerivSecond[0][0] * xBBar + cDerivSecond[0][0] * xCBar + dDerivSecond[0][0] * xDBar + 2.0 * xABar * aDerivSecond[0][1] * dxyds + 2.0 * xBBar * bDerivSecond[0][1] * dxyds - 2.0 * xCBar * cDerivSecond[0][1] * dxyds - 2.0 * xDBar * dDerivSecond[0][1] * dxyds + xABar * aDerivSecond[1][1] * dxyds * dxyds + xBBar * bDerivSecond[1][1] * dxyds * dxyds + xCBar * cDerivSecond[1][1] * dxyds * dxyds + xDBar * dDerivSecond[1][1] * dxyds * dxyds - x1Bar * dxyds / spot - x2Bar * dxyds / spot + y1Bar * dxyds / spot + y2Bar * dxyds / spot;
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    private double getA(double s, double k, double df1, double df2, double x, double lognormalVolT, double phi) {
        return phi * (s * df1 * NORMAL.getCDF((Object)(phi * x)) - k * df2 * NORMAL.getCDF((Object)(phi * (x - lognormalVolT))));
    }

    private double getC(double s, double k, double df1, double df2, double y, double lognormalVolT, double h, double mu, double phi, double eta) {
        return phi * (s * df1 * Math.pow(h / s, 2.0 * (mu + 1.0)) * NORMAL.getCDF((Object)(eta * y)) - k * df2 * Math.pow(h / s, 2.0 * mu) * NORMAL.getCDF((Object)(eta * (y - lognormalVolT))));
    }

    private double getAAdjoint(double s, double k, double df1, double df2, double x, double lognormalVolT, double phi, double[] firstderivatives, double[][] secondderivatives) {
        double n1 = NORMAL.getCDF((Object)(phi * x));
        double n2 = NORMAL.getCDF((Object)(phi * (x - lognormalVolT)));
        double a = phi * (s * df1 * n1 - k * df2 * n2);
        double n2Bar = phi * -k * df2;
        double n1Bar = phi * s * df1;
        firstderivatives[0] = phi * df1 * n1;
        firstderivatives[1] = phi * -df2 * n2;
        firstderivatives[2] = phi * s * n1;
        firstderivatives[3] = phi * -k * n2;
        double n1df = NORMAL.getPDF((Object)x);
        double n2df = NORMAL.getPDF((Object)(x - lognormalVolT));
        firstderivatives[4] = n1df * phi * n1Bar + n2df * phi * n2Bar;
        firstderivatives[5] = n2df * -phi * n2Bar;
        secondderivatives[0][0] = 0.0;
        secondderivatives[1][0] = n1df * df1;
        secondderivatives[0][1] = secondderivatives[1][0];
        secondderivatives[1][1] = -x * n1df * phi * n1Bar - (x - lognormalVolT) * n2df * phi * n2Bar;
        return a;
    }

    private double getCAdjoint(double s, double k, double df1, double df2, double y, double lognormalVolT, double h, double mu, double phi, double eta, double[] firstDerivatives, double[][] secondDerivatives) {
        double n1 = NORMAL.getCDF((Object)(eta * y));
        double n2 = NORMAL.getCDF((Object)(eta * (y - lognormalVolT)));
        double hsMu1 = Math.pow(h / s, 2.0 * (mu + 1.0));
        double hsMu = Math.pow(h / s, 2.0 * mu);
        double c = phi * (s * df1 * hsMu1 * n1 - k * df2 * hsMu * n2);
        double n1df = NORMAL.getPDF((Object)y);
        double n2df = NORMAL.getPDF((Object)(y - lognormalVolT));
        double hsMuBar = phi * -k * df2 * n2;
        double hsMu1Bar = phi * s * df1 * n1;
        double n2Bar = phi * -k * df2 * hsMu;
        double n1Bar = phi * s * df1 * hsMu1;
        firstDerivatives[0] = phi * df1 * hsMu1 * n1 - 2.0 * mu * hsMu / s * hsMuBar - 2.0 * (mu + 1.0) * hsMu1 / s * hsMu1Bar;
        firstDerivatives[1] = phi * -df2 * hsMu * n2;
        firstDerivatives[2] = phi * s * hsMu1 * n1;
        firstDerivatives[3] = phi * -k * hsMu * n2;
        firstDerivatives[4] = n1df * eta * n1Bar + n2df * eta * n2Bar;
        firstDerivatives[5] = -n2df * eta * n2Bar;
        firstDerivatives[6] = 2.0 * Math.log(h / s) * hsMu * hsMuBar + 2.0 * Math.log(h / s) * hsMu1 * hsMu1Bar;
        secondDerivatives[0][0] = -2.0 * (mu + 1.0) * phi * df1 * hsMu1 * n1 / s + hsMu * hsMuBar * 2.0 * mu * (2.0 * mu + 1.0) / (s * s) - hsMu1 * hsMu1Bar * 2.0 * (mu + 1.0) / (s * s) + hsMu1 * hsMu1Bar * 2.0 * (mu + 1.0) * (2.0 * mu + 3.0) / (s * s);
        secondDerivatives[0][1] = hsMu1 * n1df * phi * df1 * eta - 2.0 * mu * hsMu / s * phi * -k * df2 * n2df * eta - hsMu1 * n1df * 2.0 * (mu + 1.0) * phi * df1 * eta;
        secondDerivatives[1][0] = secondDerivatives[0][1];
        secondDerivatives[1][1] = -y * n1df * eta * n1Bar - (y - lognormalVolT) * n2df * eta * n2Bar;
        return c;
    }
}

