/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.rootfinding.NewtonRaphsonSingleRootFinder;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.pricer.impl.option.GenericImpliedVolatiltySolver;
import com.opengamma.strata.pricer.impl.option.NormalFormulaRepository;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlackFormulaRepository {
    private static final Logger log = LoggerFactory.getLogger(BlackFormulaRepository.class);
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double LARGE = 1.0E13;
    private static final double SMALL = 1.0E-13;
    private static final double NEAR_ZERO = 1.0E-16;
    private static final double ATM_LIMIT = 0.001;
    private static final double ROOT_ACCURACY = 1.0E-7;
    private static final NewtonRaphsonSingleRootFinder ROOT_FINDER = new NewtonRaphsonSingleRootFinder(1.0E-7);

    private BlackFormulaRepository() {
    }

    public static double price(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        double d2 = 0.0;
        if (bFwd && bStr) {
            log.info("(large value)/(large value) ambiguous");
            return isCall ? (forward >= strike ? forward : 0.0) : (strike >= forward ? strike : 0.0);
        }
        if (sigmaRootT < 1.0E-13) {
            return Math.max((double)sign * (forward - strike), 0.0);
        }
        if (Math.abs(forward - strike) < 1.0E-13 || bSigRt) {
            d1 = 0.5 * sigmaRootT;
            d2 = -0.5 * sigmaRootT;
        } else {
            d1 = Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
            d2 = d1 - sigmaRootT;
        }
        double nF = NORMAL.getCDF((Object)((double)sign * d1));
        double nS = NORMAL.getCDF((Object)((double)sign * d2));
        double first = nF == 0.0 ? 0.0 : forward * nF;
        double second = nS == 0.0 ? 0.0 : strike * nS;
        double res = (double)sign * (first - second);
        return Math.max(0.0, res);
    }

    public static ValueDerivatives priceAdjoint(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall) {
        double d1Bar;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        double d2 = 0.0;
        if (bFwd && bStr) {
            log.info("(large value)/(large value) ambiguous");
            double price = isCall ? (forward >= strike ? forward : 0.0) : (strike >= forward ? strike : 0.0);
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.filled((int)4));
        }
        if (sigmaRootT < 1.0E-13) {
            boolean isItm = (double)sign * (forward - strike) > 0.0;
            double price = isItm ? (double)sign * (forward - strike) : 0.0;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)(isItm ? (double)sign : 0.0), (double)(isItm ? (double)(-sign) : 0.0), (double)0.0, (double)0.0));
        }
        if (Math.abs(forward - strike) < 1.0E-13 || bSigRt) {
            d1 = 0.5 * sigmaRootT;
            d2 = -0.5 * sigmaRootT;
        } else {
            d2 = Math.log(forward / strike) / sigmaRootT - 0.5 * sigmaRootT;
            d1 = d2 + sigmaRootT;
        }
        double nF = NORMAL.getCDF((Object)((double)sign * d1));
        double nS = NORMAL.getCDF((Object)((double)sign * d2));
        double first = nF == 0.0 ? 0.0 : forward * nF;
        double second = nS == 0.0 ? 0.0 : strike * nS;
        double res = (double)sign * (first - second);
        double price = Math.max(0.0, res);
        double resBar = 1.0;
        double firstBar = (double)sign * resBar;
        double secondBar = (double)(-sign) * resBar;
        double forwardBar = nF * firstBar;
        double strikeBar = nS * secondBar;
        double nFBar = forward * firstBar;
        double sigmaRootTBar = d1Bar = (double)sign * NORMAL.getPDF((Object)((double)sign * d1)) * nFBar;
        double lognormalVolBar = Math.sqrt(timeToExpiry) * sigmaRootTBar;
        double timeToExpiryBar = 0.5 / Math.sqrt(timeToExpiry) * lognormalVol * sigmaRootTBar;
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)forwardBar, (double)strikeBar, (double)timeToExpiryBar, (double)lognormalVolBar));
    }

    public static Pair<ValueDerivatives, double[][]> priceAdjoint2(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall) {
        double p;
        double discountFactor = 1.0;
        double sqrttheta = Math.sqrt(timeToExpiry);
        double omega = isCall ? 1.0 : -1.0;
        double volPeriod = 0.0;
        double kappa = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double x = 0.0;
        if (strike < 1.0E-16 || sqrttheta < 1.0E-16) {
            x = omega * (forward - strike);
            p = x > 0.0 ? discountFactor * x : 0.0;
            volPeriod = sqrttheta < 1.0E-16 ? 0.0 : lognormalVol * sqrttheta;
        } else {
            volPeriod = lognormalVol * sqrttheta;
            kappa = Math.log(forward / strike) / volPeriod - 0.5 * volPeriod;
            d1 = NORMAL.getCDF((Object)(omega * (kappa + volPeriod)));
            d2 = NORMAL.getCDF((Object)(omega * kappa));
            p = discountFactor * omega * (forward * d1 - strike * d2);
        }
        double[][] bsD2 = new double[3][3];
        double pBar = 1.0;
        double density1 = 0.0;
        double d1Bar = 0.0;
        double forwardBar = 0.0;
        double strikeBar = 0.0;
        double volPeriodBar = 0.0;
        double lognormalVolBar = 0.0;
        double sqrtthetaBar = 0.0;
        double timeToExpiryBar = 0.0;
        if (strike < 1.0E-16 || sqrttheta < 1.0E-16) {
            forwardBar = x > 0.0 ? discountFactor * omega : 0.0;
            strikeBar = x > 0.0 ? -discountFactor * omega : 0.0;
        } else {
            d1Bar = discountFactor * omega * forward * pBar;
            density1 = NORMAL.getPDF((Object)(omega * (kappa + volPeriod)));
            forwardBar = discountFactor * omega * d1 * pBar;
            strikeBar = -discountFactor * omega * d2 * pBar;
            volPeriodBar = density1 * omega * d1Bar;
            lognormalVolBar = sqrttheta * volPeriodBar;
            sqrtthetaBar = lognormalVol * volPeriodBar;
            timeToExpiryBar = 0.5 / sqrttheta * sqrtthetaBar;
        }
        DoubleArray bsD = DoubleArray.of((double)forwardBar, (double)strikeBar, (double)timeToExpiryBar, (double)lognormalVolBar);
        if (strike < 1.0E-16 || sqrttheta < 1.0E-16) {
            return Pair.of((Object)ValueDerivatives.of((double)p, (DoubleArray)bsD), (Object)bsD2);
        }
        double d2Bar = -discountFactor * omega * strike;
        double density2 = NORMAL.getPDF((Object)(omega * kappa));
        double d1Kappa = omega * density1;
        double d1KappaKappa = -(kappa + volPeriod) * d1Kappa;
        double d2Kappa = omega * density2;
        double d2KappaKappa = -kappa * d2Kappa;
        double kappaKappaBar2 = d1KappaKappa * d1Bar + d2KappaKappa * d2Bar;
        double kappaV = -Math.log(forward / strike) / (volPeriod * volPeriod) - 0.5;
        double kappaVV = 2.0 * Math.log(forward / strike) / (volPeriod * volPeriod * volPeriod);
        double d1TotVV = density1 * omega * (-(kappa + volPeriod) * (kappaV + 1.0) * (kappaV + 1.0) + kappaVV);
        double d2TotVV = d2KappaKappa * kappaV * kappaV + d2Kappa * kappaVV;
        double vVbar2 = d1Bar * d1TotVV + d2Bar * d2TotVV;
        double volVolBar2 = vVbar2 * timeToExpiry;
        double kappaStrikeBar2 = -discountFactor * omega * d2Kappa;
        double kappaStrike = -1.0 / (strike * volPeriod);
        double strikeStrikeBar2 = (kappaKappaBar2 * kappaStrike + 2.0 * kappaStrikeBar2) * kappaStrike;
        double kappaStrikeV = 1.0 / strike / (volPeriod * volPeriod);
        double d1VK = -omega * (kappa + volPeriod) * density1 * (kappaV + 1.0) * kappaStrike + omega * density1 * kappaStrikeV;
        double d2V = d2Kappa * kappaV;
        double d2VK = -omega * kappa * density2 * kappaV * kappaStrike + omega * density2 * kappaStrikeV;
        double strikeD2Bar2 = -discountFactor * omega;
        double strikeVolblackBar2 = strikeD2Bar2 * d2V + d1Bar * d1VK + d2Bar * d2VK;
        double strikeVolBar2 = strikeVolblackBar2 * sqrttheta;
        double kappaForward = 1.0 / (forward * volPeriod);
        double forwardForwardBar2 = discountFactor * omega * d1Kappa * kappaForward;
        double strikeForwardBar2 = discountFactor * omega * d1Kappa * kappaStrike;
        double volForwardBar2 = discountFactor * omega * d1Kappa * (kappaV + 1.0) * sqrttheta;
        bsD2[0][0] = forwardForwardBar2;
        bsD2[0][2] = volForwardBar2;
        bsD2[2][0] = volForwardBar2;
        bsD2[0][1] = strikeForwardBar2;
        bsD2[1][0] = strikeForwardBar2;
        bsD2[2][2] = volVolBar2;
        bsD2[1][2] = strikeVolBar2;
        bsD2[2][1] = strikeVolBar2;
        bsD2[1][1] = strikeStrikeBar2;
        return Pair.of((Object)ValueDerivatives.of((double)p, (DoubleArray)bsD), (Object)bsD2);
    }

    public static double delta(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall) {
        boolean bSigRt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double d1 = 0.0;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bl = bSigRt = sigmaRootT > 1.0E13;
        if (bSigRt) {
            return isCall ? 1.0 : 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return isCall ? (forward > strike ? 1.0 : 0.0) : (forward > strike ? 0.0 : -1.0);
            }
            log.info("(log 1d)/0., ambiguous value");
            return isCall ? 0.5 : -0.5;
        }
        d1 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? 0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
        return (double)sign * NORMAL.getCDF((Object)((double)sign * d1));
    }

    public static double strikeForDelta(double forward, double forwardDelta, double timeToExpiry, double lognormalVol, boolean isCall) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((isCall && forwardDelta > 0.0 && forwardDelta < 1.0 || !isCall && forwardDelta > -1.0 && forwardDelta < 0.0 ? 1 : 0) != 0, (String)"delta out of range", (double)forwardDelta);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        int sign = isCall ? 1 : -1;
        double d1 = (double)sign * NORMAL.getInverseCDF((Object)((double)sign * forwardDelta));
        double sigmaSqT = lognormalVol * lognormalVol * timeToExpiry;
        if (Double.isNaN(sigmaSqT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaSqT = 1.0;
        }
        return forward * Math.exp(-d1 * Math.sqrt(sigmaSqT) + 0.5 * sigmaSqT);
    }

    public static double dualDelta(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall) {
        boolean bSigRt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double d2 = 0.0;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bl = bSigRt = sigmaRootT > 1.0E13;
        if (bSigRt) {
            return isCall ? 0.0 : 1.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return isCall ? (forward > strike ? -1.0 : 0.0) : (forward > strike ? 0.0 : 1.0);
            }
            log.info("(log 1d)/0., ambiguous value");
            return isCall ? -0.5 : 0.5;
        }
        d2 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? -0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT - 0.5 * sigmaRootT;
        return (double)(-sign) * NORMAL.getCDF((Object)((double)sign * d2));
    }

    public static double simpleDelta(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall) {
        boolean bSigRt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double d = 0.0;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bl = bSigRt = sigmaRootT > 1.0E13;
        if (bSigRt) {
            return isCall ? 0.5 : -0.5;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return isCall ? (forward > strike ? 1.0 : 0.0) : (forward > strike ? 0.0 : -1.0);
            }
            log.info("(log 1d)/0., ambiguous");
            return isCall ? 0.5 : -0.5;
        }
        d = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? 0.0 : Math.log(forward / strike) / sigmaRootT;
        return (double)sign * NORMAL.getCDF((Object)((double)sign * d));
    }

    public static double gamma(double forward, double strike, double timeToExpiry, double lognormalVol) {
        boolean bSigRt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        double d1 = 0.0;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bl = bSigRt = sigmaRootT > 1.0E13;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("(log 1d)/0d ambiguous");
            return bFwd ? NORMAL.getPDF((Object)0.0) : NORMAL.getPDF((Object)0.0) / forward / sigmaRootT;
        }
        d1 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? 0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
        double nVal = NORMAL.getPDF((Object)d1);
        return nVal == 0.0 ? 0.0 : nVal / forward / sigmaRootT;
    }

    public static double dualGamma(double forward, double strike, double timeToExpiry, double lognormalVol) {
        boolean bSigRt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        double d2 = 0.0;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bl = bSigRt = sigmaRootT > 1.0E13;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("(log 1d)/0d ambiguous");
            return bStr ? NORMAL.getPDF((Object)0.0) : NORMAL.getPDF((Object)0.0) / strike / sigmaRootT;
        }
        d2 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? -0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT - 0.5 * sigmaRootT;
        double nVal = NORMAL.getPDF((Object)d2);
        return nVal == 0.0 ? 0.0 : nVal / strike / sigmaRootT;
    }

    public static double crossGamma(double forward, double strike, double timeToExpiry, double lognormalVol) {
        boolean bSigRt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        double d2 = 0.0;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bl = bSigRt = sigmaRootT > 1.0E13;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("(log 1d)/0d ambiguous");
            return bFwd ? -NORMAL.getPDF((Object)0.0) : -NORMAL.getPDF((Object)0.0) / forward / sigmaRootT;
        }
        d2 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? -0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT - 0.5 * sigmaRootT;
        double nVal = NORMAL.getPDF((Object)d2);
        return nVal == 0.0 ? 0.0 : -nVal / forward / sigmaRootT;
    }

    public static double theta(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall, double interestRate) {
        double rt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        if (-interestRate > 1.0E13) {
            return 0.0;
        }
        double driftLess = BlackFormulaRepository.driftlessTheta(forward, strike, timeToExpiry, lognormalVol);
        if (Math.abs(interestRate) < 1.0E-13) {
            return driftLess;
        }
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        double d2 = 0.0;
        double priceLike = Double.NaN;
        double d = timeToExpiry < 1.0E-13 && Math.abs(interestRate) > 1.0E13 ? (interestRate > 0.0 ? 1.0 : -1.0) : (rt = interestRate * timeToExpiry);
        if (bFwd && bStr) {
            log.info("(large value)/(large value) ambiguous");
            priceLike = isCall ? (forward >= strike ? forward : 0.0) : (strike >= forward ? strike : 0.0);
        } else if (sigmaRootT < 1.0E-13) {
            priceLike = rt > 1.0E13 ? (isCall ? (forward > strike ? forward : 0.0) : (forward > strike ? 0.0 : -forward)) : (isCall ? (forward > strike ? forward - strike * Math.exp(-rt) : 0.0) : (forward > strike ? 0.0 : -forward + strike * Math.exp(-rt)));
        } else {
            if (Math.abs(forward - strike) < 1.0E-13 | bSigRt) {
                d1 = 0.5 * sigmaRootT;
                d2 = -0.5 * sigmaRootT;
            } else {
                d1 = Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
                d2 = d1 - sigmaRootT;
            }
            double nF = NORMAL.getCDF((Object)((double)sign * d1));
            double nS = NORMAL.getCDF((Object)((double)sign * d2));
            double first = nF == 0.0 ? 0.0 : forward * nF;
            double second = nS == 0.0 | Math.exp(-interestRate * timeToExpiry) == 0.0 ? 0.0 : strike * Math.exp(-interestRate * timeToExpiry) * nS;
            priceLike = (double)sign * (first - second);
        }
        double res = interestRate > 1.0E13 && Math.abs(priceLike) < 1.0E-13 ? 0.0 : interestRate * priceLike;
        return Math.abs(res) > 1.0E13 ? res : driftLess + res;
    }

    public static double thetaMod(double forward, double strike, double timeToExpiry, double lognormalVol, boolean isCall, double interestRate) {
        double rt;
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        if (-interestRate > 1.0E13) {
            return 0.0;
        }
        double driftLess = BlackFormulaRepository.driftlessTheta(forward, strike, timeToExpiry, lognormalVol);
        if (Math.abs(interestRate) < 1.0E-13) {
            return driftLess;
        }
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d2 = 0.0;
        double priceLike = Double.NaN;
        double d = timeToExpiry < 1.0E-13 && Math.abs(interestRate) > 1.0E13 ? (interestRate > 0.0 ? 1.0 : -1.0) : (rt = interestRate * timeToExpiry);
        if (bFwd && bStr) {
            log.info("(large value)/(large value) ambiguous");
            priceLike = isCall ? 0.0 : (strike >= forward ? strike : 0.0);
        } else if (sigmaRootT < 1.0E-13) {
            priceLike = rt > 1.0E13 ? 0.0 : (isCall ? (forward > strike ? -strike : 0.0) : (forward > strike ? 0.0 : strike));
        } else {
            d2 = Math.abs(forward - strike) < 1.0E-13 | bSigRt ? -0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT - 0.5 * sigmaRootT;
            double nS = NORMAL.getCDF((Object)((double)sign * d2));
            priceLike = nS == 0.0 ? 0.0 : (double)(-sign) * strike * nS;
        }
        double res = interestRate > 1.0E13 && Math.abs(priceLike) < 1.0E-13 ? 0.0 : interestRate * priceLike;
        return Math.abs(res) > 1.0E13 ? res : driftLess + res;
    }

    public static double driftlessTheta(double forward, double strike, double timeToExpiry, double lognormalVol) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("log(1)/0 ambiguous");
            if (rootT < 1.0E-13) {
                return forward < 1.0E-13 ? -NORMAL.getPDF((Object)0.0) * lognormalVol / 2.0 : (lognormalVol < 1.0E-13 ? -forward * NORMAL.getPDF((Object)0.0) / 2.0 : -forward * NORMAL.getPDF((Object)0.0) * lognormalVol / 2.0 / rootT);
            }
            if (lognormalVol < 1.0E-13) {
                return bFwd ? -NORMAL.getPDF((Object)0.0) / 2.0 / rootT : -forward * NORMAL.getPDF((Object)0.0) * lognormalVol / 2.0 / rootT;
            }
        }
        d1 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? 0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
        double nVal = NORMAL.getPDF((Object)d1);
        return nVal == 0.0 ? 0.0 : -forward * nVal * lognormalVol / 2.0 / rootT;
    }

    public static double vega(double forward, double strike, double timeToExpiry, double lognormalVol) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("log(1)/0 ambiguous");
            return rootT < 1.0E-13 && forward > 1.0E13 ? NORMAL.getPDF((Object)0.0) : forward * rootT * NORMAL.getPDF((Object)0.0);
        }
        d1 = Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr) ? 0.5 * sigmaRootT : Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
        double nVal = NORMAL.getPDF((Object)d1);
        return nVal == 0.0 ? 0.0 : forward * rootT * nVal;
    }

    public static double vanna(double forward, double strike, double timeToExpiry, double lognormalVol) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        double d2 = 0.0;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("log(1)/0 ambiguous");
            return lognormalVol < 1.0E-13 ? -NORMAL.getPDF((Object)0.0) / lognormalVol : NORMAL.getPDF((Object)0.0) * rootT;
        }
        if (Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr)) {
            d1 = 0.5 * sigmaRootT;
            d2 = -0.5 * sigmaRootT;
        } else {
            d1 = Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
            d2 = d1 - sigmaRootT;
        }
        double nVal = NORMAL.getPDF((Object)d1);
        return nVal == 0.0 ? 0.0 : -nVal * d2 / lognormalVol;
    }

    public static double dualVanna(double forward, double strike, double timeToExpiry, double lognormalVol) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        double d2 = 0.0;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("log(1)/0 ambiguous");
            return lognormalVol < 1.0E-13 ? -NORMAL.getPDF((Object)0.0) / lognormalVol : -NORMAL.getPDF((Object)0.0) * rootT;
        }
        if (Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr)) {
            d1 = 0.5 * sigmaRootT;
            d2 = -0.5 * sigmaRootT;
        } else {
            d1 = Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
            d2 = d1 - sigmaRootT;
        }
        double nVal = NORMAL.getPDF((Object)d2);
        return nVal == 0.0 ? 0.0 : nVal * d1 / lognormalVol;
    }

    public static double vomma(double forward, double strike, double timeToExpiry, double lognormalVol) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            log.info("lognormalVol * Math.sqrt(timeToExpiry) ambiguous");
            sigmaRootT = 1.0;
        }
        boolean bFwd = forward > 1.0E13;
        boolean bStr = strike > 1.0E13;
        boolean bSigRt = sigmaRootT > 1.0E13;
        double d1 = 0.0;
        double d2 = 0.0;
        if (bSigRt) {
            return 0.0;
        }
        if (sigmaRootT < 1.0E-13) {
            if (!(!(Math.abs(forward - strike) >= 1.0E-13) || bFwd && bStr)) {
                return 0.0;
            }
            log.info("log(1)/0 ambiguous");
            if (bFwd) {
                return rootT < 1.0E-13 ? NORMAL.getPDF((Object)0.0) / lognormalVol : forward * NORMAL.getPDF((Object)0.0) * rootT / lognormalVol;
            }
            return lognormalVol < 1.0E-13 ? forward * NORMAL.getPDF((Object)0.0) * rootT / lognormalVol : -forward * NORMAL.getPDF((Object)0.0) * timeToExpiry * lognormalVol / 4.0;
        }
        if (Math.abs(forward - strike) < 1.0E-13 | (bFwd && bStr)) {
            d1 = 0.5 * sigmaRootT;
            d2 = -0.5 * sigmaRootT;
        } else {
            d1 = Math.log(forward / strike) / sigmaRootT + 0.5 * sigmaRootT;
            d2 = d1 - sigmaRootT;
        }
        double nVal = NORMAL.getPDF((Object)d1);
        double res = nVal == 0.0 ? 0.0 : forward * nVal * rootT * d1 * d2 / lognormalVol;
        return res;
    }

    public static double volga(double forward, double strike, double timeToExpiry, double lognormalVol) {
        return BlackFormulaRepository.vomma(forward, strike, timeToExpiry, lognormalVol);
    }

    public static double impliedVolatility(double price, double forward, double strike, double timeToExpiry, boolean isCall) {
        ArgChecker.isTrue((price >= -1.0E-16 * forward ? 1 : 0) != 0, (String)"negative/NaN price; have {}", (double)price);
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isFalse((boolean)Double.isInfinite(forward), (String)"forward is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(strike), (String)"strike is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(timeToExpiry), (String)"timeToExpiry is Infinity");
        double intrinsicPrice = Math.max(0.0, (double)(isCall ? 1 : -1) * (forward - strike));
        double targetPrice = price - intrinsicPrice;
        double sigmaGuess = 0.3;
        return BlackFormulaRepository.impliedVolatility(targetPrice, forward, strike, timeToExpiry, sigmaGuess);
    }

    public static ValueDerivatives impliedVolatilityAdjoint(double price, double forward, double strike, double timeToExpiry, boolean isCall) {
        ArgChecker.isTrue((price >= -1.0E-16 * forward ? 1 : 0) != 0, (String)"negative/NaN price; have {}", (double)price);
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isFalse((boolean)Double.isInfinite(forward), (String)"forward is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(strike), (String)"strike is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(timeToExpiry), (String)"timeToExpiry is Infinity");
        double intrinsicPrice = Math.max(0.0, (double)(isCall ? 1 : -1) * (forward - strike));
        double targetPrice = price - intrinsicPrice;
        double sigmaGuess = 0.3;
        return BlackFormulaRepository.impliedVolatilityAdjoint(targetPrice, forward, strike, timeToExpiry, sigmaGuess);
    }

    public static double impliedVolatility(double otmPrice, final double forward, final double strike, final double timeToExpiry, double volGuess) {
        ArgChecker.isTrue((otmPrice >= -1.0E-16 * forward ? 1 : 0) != 0, (String)"negative/NaN otmPrice; have {}", (double)otmPrice);
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN forward; have {}", (double)forward);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((volGuess >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN volGuess; have {}", (double)volGuess);
        ArgChecker.isFalse((boolean)Double.isInfinite(otmPrice), (String)"otmPrice is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(forward), (String)"forward is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(strike), (String)"strike is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(timeToExpiry), (String)"timeToExpiry is Infinity");
        ArgChecker.isFalse((boolean)Double.isInfinite(volGuess), (String)"volGuess is Infinity");
        if (Math.abs(otmPrice) < 1.0E-16 * forward) {
            return 0.0;
        }
        ArgChecker.isTrue((otmPrice < Math.min(forward, strike) ? 1 : 0) != 0, (String)"otmPrice of {} exceeded upper bound of {}", (Object[])new Object[]{otmPrice, Math.min(forward, strike)});
        if (forward == strike) {
            return NORMAL.getInverseCDF((Object)(0.5 * (otmPrice / forward + 1.0))) * 2.0 / Math.sqrt(timeToExpiry);
        }
        final boolean isCall = strike >= forward;
        Function<Double, Double> priceFunc = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                return BlackFormulaRepository.price(forward, strike, timeToExpiry, x, isCall);
            }
        };
        Function<Double, Double> vegaFunc = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                return BlackFormulaRepository.vega(forward, strike, timeToExpiry, x);
            }
        };
        GenericImpliedVolatiltySolver solver = new GenericImpliedVolatiltySolver(priceFunc, vegaFunc);
        return solver.impliedVolatility(otmPrice, volGuess);
    }

    public static ValueDerivatives impliedVolatilityAdjoint(double otmPrice, double forward, double strike, double timeToExpiry, double volGuess) {
        if (Math.abs(otmPrice) < 1.0E-16 * forward) {
            return ValueDerivatives.of((double)0.0, (DoubleArray)DoubleArray.of((double)0.0));
        }
        double impliedVolatility = BlackFormulaRepository.impliedVolatility(otmPrice, forward, strike, timeToExpiry, volGuess);
        boolean isCall = strike >= forward;
        ValueDerivatives price = BlackFormulaRepository.priceAdjoint(forward, strike, timeToExpiry, impliedVolatility, isCall);
        double dpricedvol = price.getDerivative(3);
        double dvoldprice = 1.0 / dpricedvol;
        return ValueDerivatives.of((double)impliedVolatility, (DoubleArray)DoubleArray.of((double)dvoldprice));
    }

    public static double impliedStrike(double delta, boolean isCall, double forward, double time, double volatility) {
        ArgChecker.isTrue((delta > -1.0 && delta < 1.0 ? 1 : 0) != 0, (String)"Delta out of range");
        ArgChecker.isTrue((boolean)(isCall ^ delta < 0.0), (String)"Delta incompatible with call/put: {}, {}", (Object[])new Object[]{isCall, delta});
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"Forward negative");
        double omega = isCall ? 1.0 : -1.0;
        double strike = forward * Math.exp(-volatility * Math.sqrt(time) * omega * NORMAL.getInverseCDF((Object)(omega * delta)) + volatility * volatility * time / 2.0);
        return strike;
    }

    public static double impliedStrike(double delta, boolean isCall, double forward, double time, double volatility, double[] derivatives) {
        ArgChecker.isTrue((delta > -1.0 && delta < 1.0 ? 1 : 0) != 0, (String)"Delta out of range");
        ArgChecker.isTrue((boolean)(isCall ^ delta < 0.0), (String)"Delta incompatible with call/put: {}, {}", (Object[])new Object[]{isCall, delta});
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"Forward negative");
        double omega = isCall ? 1.0 : -1.0;
        double sqrtt = Math.sqrt(time);
        double n = NORMAL.getInverseCDF((Object)(omega * delta));
        double part1 = Math.exp(-volatility * sqrtt * omega * n + volatility * volatility * time / 2.0);
        double strike = forward * part1;
        double strikeBar = 1.0;
        double part1Bar = forward * strikeBar;
        double nBar = part1 * -volatility * Math.sqrt(time) * omega * part1Bar;
        derivatives[0] = omega / NORMAL.getPDF((Object)n) * nBar;
        derivatives[1] = part1 * strikeBar;
        derivatives[2] = part1 * (-volatility * omega * n * 0.5 / sqrtt + volatility * volatility / 2.0) * part1Bar;
        derivatives[3] = part1 * (-sqrtt * omega * n + volatility * time) * part1Bar;
        return strike;
    }

    public static double impliedVolatilityFromNormalApproximated(final double forward, final double strike, final double timeToExpiry, final double normalVolatility) {
        ArgChecker.isTrue((strike > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        double guess = BlackFormulaRepository.impliedVolatilityFromNormalApproximated2(forward, strike, timeToExpiry, normalVolatility);
        Function<Double, Double> func = new Function<Double, Double>(){

            @Override
            public Double apply(Double volatility) {
                return NormalFormulaRepository.impliedVolatilityFromBlackApproximated(forward, strike, timeToExpiry, volatility) - normalVolatility;
            }
        };
        return ROOT_FINDER.getRoot((Function)func, Double.valueOf(guess));
    }

    public static ValueDerivatives impliedVolatilityFromNormalApproximatedAdjoint(final double forward, final double strike, final double timeToExpiry, final double normalVolatility) {
        ArgChecker.isTrue((strike > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        double guess = BlackFormulaRepository.impliedVolatilityFromNormalApproximated2(forward, strike, timeToExpiry, normalVolatility);
        Function<Double, Double> func = new Function<Double, Double>(){

            @Override
            public Double apply(Double volatility) {
                return NormalFormulaRepository.impliedVolatilityFromBlackApproximated(forward, strike, timeToExpiry, volatility) - normalVolatility;
            }
        };
        double impliedVolatilityBlack = ROOT_FINDER.getRoot((Function)func, Double.valueOf(guess));
        double derivativeInverse = NormalFormulaRepository.impliedVolatilityFromBlackApproximatedAdjoint(forward, strike, timeToExpiry, impliedVolatilityBlack).getDerivative(0);
        double derivative = 1.0 / derivativeInverse;
        return ValueDerivatives.of((double)impliedVolatilityBlack, (DoubleArray)DoubleArray.of((double)derivative));
    }

    public static double impliedVolatilityFromNormalApproximated2(double forward, double strike, double timeToExpiry, double normalVolatility) {
        ArgChecker.isTrue((strike > 0.0 ? 1 : 0) != 0, (String)"strike must be strctly positive");
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"strike must be strctly positive");
        double lnFK = Math.log(forward / strike);
        double s2t = normalVolatility * normalVolatility * timeToExpiry;
        if (Math.abs((forward - strike) / strike) < 0.001) {
            double factor1 = 1.0 / Math.sqrt(forward * strike);
            double factor2 = (1.0 + s2t / (24.0 * forward * strike)) / (1.0 + lnFK * lnFK / 24.0);
            return normalVolatility * factor1 * factor2;
        }
        double factor1 = lnFK / (forward - strike);
        double factor2 = 1.0 + (1.0 - lnFK * lnFK / 120.0) * s2t / (24.0 * forward * strike);
        return normalVolatility * factor1 * factor2;
    }
}

