/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.product.option.SimpleConstantContinuousBarrier;

public class BlackOneTouchCashPriceFormulaRepository {
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double SMALL = 1.0E-6;

    public double price(double spot, double timeToExpiry, double costOfCarry, double rate, double lognormalVol, SimpleConstantContinuousBarrier barrier) {
        ArgChecker.notNull((Object)barrier, (String)"barrier");
        boolean isKnockIn = barrier.getKnockType().isKnockIn();
        boolean isDown = barrier.getBarrierType().isDown();
        double h = barrier.getBarrierLevel();
        ArgChecker.isFalse((isDown && spot <= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (DOWN and spot<=barrier).");
        ArgChecker.isFalse((!isDown && spot >= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (UP and spot>=barrier).");
        double eta = isDown ? 1.0 : -1.0;
        double df2 = Math.exp(-rate * timeToExpiry);
        double lognormalVolSq = lognormalVol * lognormalVol;
        double lognormalVolT = lognormalVol * Math.sqrt(timeToExpiry);
        if (MathUtils.nearZero((double)Math.min(timeToExpiry, lognormalVolSq), (double)1.0E-6)) {
            return isKnockIn ? 0.0 : df2;
        }
        double mu = (costOfCarry - 0.5 * lognormalVolSq) / lognormalVolSq;
        double lambda = Math.sqrt(mu * mu + 2.0 * rate / lognormalVolSq);
        double m1 = lognormalVolT * (1.0 + mu);
        double x2 = Math.log(spot / h) / lognormalVolT + m1;
        double y2 = Math.log(h / spot) / lognormalVolT + m1;
        double z = Math.log(h / spot) / lognormalVolT + lambda * lognormalVolT;
        double xE = isKnockIn ? this.getF(spot, z, lognormalVolT, h, mu, lambda, eta) : this.getE(spot, df2, x2, y2, lognormalVolT, h, mu, eta);
        return xE;
    }

    public ValueDerivatives priceAdjoint(double spot, double timeToExpiry, double costOfCarry, double rate, double lognormalVol, SimpleConstantContinuousBarrier barrier) {
        ArgChecker.notNull((Object)barrier, (String)"barrier");
        double[] derivatives = new double[6];
        boolean isKnockIn = barrier.getKnockType().isKnockIn();
        boolean isDown = barrier.getBarrierType().isDown();
        double h = barrier.getBarrierLevel();
        ArgChecker.isFalse((isDown && spot <= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (DOWN and spot<=barrier).");
        ArgChecker.isFalse((!isDown && spot >= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (UP and spot>=barrier).");
        double eta = isDown ? 1.0 : -1.0;
        double df2 = Math.exp(-rate * timeToExpiry);
        double lognormalVolSq = lognormalVol * lognormalVol;
        double lognormalVolT = lognormalVol * Math.sqrt(timeToExpiry);
        if (MathUtils.nearZero((double)Math.min(timeToExpiry, lognormalVolSq), (double)1.0E-6)) {
            if (isKnockIn) {
                return ValueDerivatives.of((double)0.0, (DoubleArray)DoubleArray.filled((int)6));
            }
            double price = df2;
            derivatives[1] = -timeToExpiry * price;
            derivatives[4] = -rate * price;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
        }
        double mu = (costOfCarry - 0.5 * lognormalVolSq) / lognormalVolSq;
        double lambda = Math.sqrt(mu * mu + 2.0 * rate / lognormalVolSq);
        double m1 = lognormalVolT * (1.0 + mu);
        double x2 = Math.log(spot / h) / lognormalVolT + m1;
        double y2 = Math.log(h / spot) / lognormalVolT + m1;
        double z = Math.log(h / spot) / lognormalVolT + lambda * lognormalVolT;
        double[] eDerivFirst = new double[6];
        double[] eDerivSecond = new double[6];
        double[] fDerivFirst = new double[5];
        double[] fDerivSecond = new double[5];
        double price = isKnockIn ? this.getFAdjoint(spot, z, lognormalVolT, h, mu, lambda, eta, fDerivFirst, fDerivSecond) : this.getEAdjoint(spot, df2, x2, y2, lognormalVolT, h, mu, eta, eDerivFirst, eDerivSecond);
        double zBar = 0.0;
        double y2Bar = 0.0;
        double x2Bar = 0.0;
        double zSqBar = 0.0;
        double y2SqBar = 0.0;
        double x2SqBar = 0.0;
        double zsBar = 0.0;
        double y2sBar = 0.0;
        double lambdaBar = 0.0;
        double muBar = 0.0;
        double lognormalVolTBar = 0.0;
        double df2Bar = 0.0;
        if (isKnockIn) {
            zBar = fDerivFirst[1];
            lambdaBar = fDerivFirst[4];
            muBar = fDerivFirst[3];
            lognormalVolTBar = fDerivFirst[2];
            derivatives[0] = fDerivFirst[0];
            zSqBar = fDerivSecond[1];
            zsBar = fDerivSecond[2];
            derivatives[5] = fDerivSecond[0];
        } else {
            y2Bar = eDerivFirst[3];
            x2Bar = eDerivFirst[2];
            muBar = eDerivFirst[5];
            lognormalVolTBar = eDerivFirst[4];
            df2Bar = eDerivFirst[1];
            derivatives[0] = eDerivFirst[0];
            y2SqBar = eDerivSecond[2];
            x2SqBar = eDerivSecond[1];
            y2sBar = eDerivSecond[3];
            derivatives[5] = eDerivSecond[0];
        }
        double dxyds = 1.0 / spot / lognormalVolT;
        double m1Bar = x2Bar + y2Bar;
        double lognormalVolSqBar = -costOfCarry / (lognormalVolSq * lognormalVolSq) * (muBar += lognormalVolT * m1Bar + mu / lambda * lambdaBar) - rate / (lognormalVolSq * lognormalVolSq) / lambda * lambdaBar;
        derivatives[0] = derivatives[0] + (dxyds * x2Bar - dxyds * y2Bar - dxyds * zBar);
        derivatives[1] = -timeToExpiry * df2 * df2Bar + lambdaBar / lambda / lognormalVolSq;
        derivatives[2] = muBar / lognormalVolSq;
        derivatives[3] = 2.0 * lognormalVol * lognormalVolSqBar + Math.sqrt(timeToExpiry) * (lognormalVolTBar += (lambda - Math.log(h / spot) / (lognormalVolT * lognormalVolT)) * zBar - Math.log(h / spot) / (lognormalVolT * lognormalVolT) * y2Bar - Math.log(spot / h) / (lognormalVolT * lognormalVolT) * x2Bar + (1.0 + mu) * m1Bar);
        derivatives[4] = -rate * df2 * df2Bar + lognormalVolTBar * lognormalVolT * 0.5 / timeToExpiry;
        derivatives[5] = derivatives[5] + (-dxyds * x2Bar / spot + dxyds * y2Bar / spot + dxyds * zBar / spot + dxyds * dxyds * x2SqBar + dxyds * dxyds * y2SqBar - 2.0 * dxyds * y2sBar + dxyds * dxyds * zSqBar - 2.0 * dxyds * zsBar);
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    private double getE(double s, double df2, double x, double y, double lognormalVolT, double h, double mu, double eta) {
        return df2 * (NORMAL.getCDF((Object)(eta * (x - lognormalVolT))) - Math.pow(h / s, 2.0 * mu) * NORMAL.getCDF((Object)(eta * (y - lognormalVolT))));
    }

    private double getF(double s, double z, double lognormalVolT, double h, double mu, double lambda, double eta) {
        return Math.pow(h / s, mu + lambda) * NORMAL.getCDF((Object)(eta * z)) + Math.pow(h / s, mu - lambda) * NORMAL.getCDF((Object)(eta * (z - 2.0 * lambda * lognormalVolT)));
    }

    private double getEAdjoint(double s, double df2, double x, double y, double lognormalVolT, double h, double mu, double eta, double[] firstDerivatives, double[] secondDerivatives) {
        double n1 = NORMAL.getCDF((Object)(eta * (x - lognormalVolT)));
        double n2 = NORMAL.getCDF((Object)(eta * (y - lognormalVolT)));
        double hsMu = Math.pow(h / s, 2.0 * mu);
        double e = df2 * (n1 - hsMu * n2);
        double n1df = NORMAL.getPDF((Object)(eta * (x - lognormalVolT)));
        double n2df = NORMAL.getPDF((Object)(eta * (y - lognormalVolT)));
        double hsMuBar = df2 * -n2;
        double n2Bar = df2 * -hsMu;
        double n1Bar = df2;
        firstDerivatives[0] = -2.0 * mu * hsMu / s * hsMuBar;
        firstDerivatives[1] = n1 - hsMu * n2;
        firstDerivatives[2] = n1df * eta * n1Bar;
        firstDerivatives[3] = n2df * eta * n2Bar;
        firstDerivatives[4] = n2df * -eta * n2Bar + n1df * -eta * n1Bar;
        firstDerivatives[5] = 2.0 * Math.log(h / s) * hsMu * hsMuBar;
        secondDerivatives[0] = hsMu * hsMuBar * 2.0 * mu * (2.0 * mu + 1.0) / (s * s);
        secondDerivatives[1] = -n1df * n1Bar * (x - lognormalVolT) * eta;
        secondDerivatives[2] = -n2df * n2Bar * (y - lognormalVolT) * eta;
        secondDerivatives[3] = -2.0 * mu * n2df * eta * n2Bar / s;
        return e;
    }

    private double getFAdjoint(double s, double z, double lognormalVolT, double h, double mu, double lambda, double eta, double[] firstDerivatives, double[] secondDerivatives) {
        double n1 = NORMAL.getCDF((Object)(eta * z));
        double n2 = NORMAL.getCDF((Object)(eta * (z - 2.0 * lambda * lognormalVolT)));
        double hsMuPLa = Math.pow(h / s, mu + lambda);
        double hsMuMLa = Math.pow(h / s, mu - lambda);
        double f = hsMuPLa * n1 + hsMuMLa * n2;
        double fBar = 1.0;
        double n1df = NORMAL.getPDF((Object)(eta * z));
        double n2df = NORMAL.getPDF((Object)(eta * (z - 2.0 * lambda * lognormalVolT)));
        double hsMuPLaBar = n1 * fBar;
        double hsMuMLaBar = n2 * fBar;
        double n2Bar = hsMuMLa * fBar;
        double n1Bar = hsMuPLa * fBar;
        firstDerivatives[0] = -(mu + lambda) * hsMuPLa / s * hsMuPLaBar - (mu - lambda) * hsMuMLa / s * hsMuMLaBar;
        firstDerivatives[1] = n1df * eta * n1Bar + n2df * eta * n2Bar;
        firstDerivatives[2] = -n2df * eta * 2.0 * lambda * n2Bar;
        firstDerivatives[3] = hsMuPLa * Math.log(h / s) * hsMuPLaBar + hsMuMLa * Math.log(h / s) * hsMuMLaBar;
        firstDerivatives[4] = hsMuPLa * Math.log(h / s) * hsMuPLaBar - hsMuMLa * Math.log(h / s) * hsMuMLaBar;
        secondDerivatives[0] = hsMuPLa * hsMuPLaBar * (mu + lambda) * (mu + lambda + 1.0) / (s * s) + hsMuMLa * hsMuMLaBar * (mu - lambda) * (mu - lambda + 1.0) / (s * s);
        secondDerivatives[1] = -z * n1df * eta * n1Bar - (z - 2.0 * lambda * lognormalVolT) * n2df * eta * n2Bar;
        secondDerivatives[2] = -n1df * n1Bar * (mu + lambda) * eta / s - n2df * n2Bar * (mu - lambda) * eta / s;
        return f;
    }
}

