/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;

public final class BlackScholesFormulaRepository {
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double SMALL = 1.0E-13;
    private static final double LARGE = 1.0E13;

    private BlackScholesFormulaRepository() {
    }

    public static double price(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double discount;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        if (interestRate > 1.0E13) {
            return 0.0;
        }
        if (-interestRate > 1.0E13) {
            return Double.POSITIVE_INFINITY;
        }
        double d = discount = Math.abs(interestRate) < 1.0E-13 ? 1.0 : Math.exp(-interestRate * timeToExpiry);
        if (costOfCarry > 1.0E13) {
            return isCall ? Double.POSITIVE_INFINITY : 0.0;
        }
        if (-costOfCarry > 1.0E13) {
            double res = isCall ? 0.0 : (discount > 1.0E-13 ? strike * discount : 0.0);
            return Double.isNaN(res) ? discount : res;
        }
        double factor = Math.exp(costOfCarry * timeToExpiry);
        if (spot > 1.0E13 * strike) {
            double tmp = Math.exp((costOfCarry - interestRate) * timeToExpiry);
            return isCall ? (tmp > 1.0E-13 ? spot * tmp : 0.0) : 0.0;
        }
        if (1.0E13 * spot < strike) {
            return isCall || discount < 1.0E-13 ? 0.0 : strike * discount;
        }
        if (spot > 1.0E13 && strike > 1.0E13) {
            double tmp = Math.exp((costOfCarry - interestRate) * timeToExpiry);
            return isCall ? (tmp > 1.0E-13 ? spot * tmp : 0.0) : (discount > 1.0E-13 ? strike * discount : 0.0);
        }
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double rescaledSpot = factor * spot;
        if (sigmaRootT < 1.0E-13) {
            double res = isCall ? (rescaledSpot > strike ? discount * (rescaledSpot - strike) : 0.0) : (rescaledSpot < strike ? discount * (strike - rescaledSpot) : 0.0);
            return Double.isNaN(res) ? (double)sign * (spot - discount * strike) : res;
        }
        double d1 = 0.0;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || sigmaRootT > 1.0E13) {
            double coefD1 = costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double coefD2 = costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmpD1 = coefD1 * rootT;
            double tmpD2 = coefD2 * rootT;
            d1 = Double.isNaN(tmpD1) ? 0.0 : tmpD1;
            d2 = Double.isNaN(tmpD2) ? 0.0 : tmpD2;
        } else {
            double sig;
            double tmp = costOfCarry * rootT / lognormalVol;
            double d3 = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            d1 = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
            d2 = d1 - sigmaRootT;
        }
        double res = (double)sign * discount * (rescaledSpot * NORMAL.getCDF((Object)((double)sign * d1)) - strike * NORMAL.getCDF((Object)((double)sign * d2)));
        return Double.isNaN(res) ? 0.0 : Math.max(res, 0.0);
    }

    public static double delta(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double factor;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return isCall ? Double.POSITIVE_INFINITY : (costOfCarry > 1.0E13 ? 0.0 : Double.NEGATIVE_INFINITY);
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        if (spot > 1.0E13 * strike) {
            return isCall ? coef : 0.0;
        }
        if (spot < 1.0E-13 * strike) {
            return isCall ? 0.0 : -coef;
        }
        int sign = isCall ? 1 : -1;
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (Double.isNaN(factor = Math.exp(costOfCarry * timeToExpiry))) {
            factor = 1.0;
        }
        double rescaledSpot = spot * factor;
        double d1 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || sigmaRootT > 1.0E13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD1 = costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmp = coefD1 * rootT;
            d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            if (sigmaRootT < 1.0E-13) {
                return isCall ? (rescaledSpot > strike ? coef : 0.0) : (rescaledSpot < strike ? -coef : 0.0);
            }
            double tmp = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            d1 = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getCDF((Object)((double)sign * d1));
        return norm < 1.0E-13 ? 0.0 : (double)sign * coef * norm;
    }

    public static double strikeForDelta(double spot, double spotDelta, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        ArgChecker.isTrue((spot > 0.0 ? 1 : 0) != 0, (String)"non-positive/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((timeToExpiry > 0.0 ? 1 : 0) != 0, (String)"non-positive/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol > 0.0 ? 1 : 0) != 0, (String)"non-positive/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(spot), (String)"spot is infinite");
        ArgChecker.isFalse((boolean)Double.isInfinite(spotDelta), (String)"spotDelta is infinite");
        ArgChecker.isFalse((boolean)Double.isInfinite(timeToExpiry), (String)"timeToExpiry is infinite");
        ArgChecker.isFalse((boolean)Double.isInfinite(lognormalVol), (String)"lognormalVol is infinite");
        ArgChecker.isFalse((boolean)Double.isInfinite(interestRate), (String)"interestRate is infinite");
        ArgChecker.isFalse((boolean)Double.isInfinite(costOfCarry), (String)"costOfCarry is infinite");
        double rescaledDelta = spotDelta * Math.exp((-costOfCarry + interestRate) * timeToExpiry);
        ArgChecker.isTrue((isCall && rescaledDelta > 0.0 && rescaledDelta < 1.0 || !isCall && spotDelta < 0.0 && rescaledDelta > -1.0 ? 1 : 0) != 0, (String)"delta/Math.exp((costOfCarry - interestRate) * timeToExpiry) out of range, ", (double)rescaledDelta);
        double sigmaRootT = lognormalVol * Math.sqrt(timeToExpiry);
        double rescaledSpot = spot * Math.exp(costOfCarry * timeToExpiry);
        int sign = isCall ? 1 : -1;
        double d1 = (double)sign * NORMAL.getInverseCDF((Object)((double)sign * rescaledDelta));
        return rescaledSpot * Math.exp(-d1 * sigmaRootT + 0.5 * sigmaRootT * sigmaRootT);
    }

    public static double dualDelta(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double factor;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double discount = 0.0;
        if (-interestRate > 1.0E13) {
            return isCall ? Double.NEGATIVE_INFINITY : (costOfCarry > 1.0E13 ? 0.0 : Double.POSITIVE_INFINITY);
        }
        if (interestRate > 1.0E13) {
            return 0.0;
        }
        double d = discount = Math.abs(interestRate) < 1.0E-13 && timeToExpiry > 1.0E13 ? 1.0 : Math.exp(-interestRate * timeToExpiry);
        if (spot > 1.0E13 * strike) {
            return isCall ? -discount : 0.0;
        }
        if (spot < 1.0E-13 * strike) {
            return isCall ? 0.0 : discount;
        }
        int sign = isCall ? 1 : -1;
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (Double.isNaN(factor = Math.exp(costOfCarry * timeToExpiry))) {
            factor = 1.0;
        }
        double rescaledSpot = spot * factor;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || sigmaRootT > 1.0E13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD2 = costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmp = coefD2 * rootT;
            d2 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            if (sigmaRootT < 1.0E-13) {
                return isCall ? (rescaledSpot > strike ? -discount : 0.0) : (rescaledSpot < strike ? discount : 0.0);
            }
            double tmp = costOfCarry * rootT / lognormalVol;
            double d3 = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            d2 = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getCDF((Object)((double)sign * d2));
        return norm < 1.0E-13 ? 0.0 : (double)(-sign) * discount * norm;
    }

    public static double gamma(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        double tmp;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return costOfCarry > 1.0E13 ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (spot > 1.0E13 * strike || spot < 1.0E-13 * strike || sigmaRootT > 1.0E13) {
            return 0.0;
        }
        double factor = Math.exp(costOfCarry * timeToExpiry);
        if (Double.isNaN(factor)) {
            factor = 1.0;
        }
        double d1 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD1 = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            tmp = coefD1 * rootT;
            d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp2 = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp2) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp2;
            d1 = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getPDF((Object)d1);
        double res = norm < 1.0E-13 ? 0.0 : coef * norm / spot / sigmaRootT;
        return Double.isNaN(res) ? Double.POSITIVE_INFINITY : res;
    }

    public static double dualGamma(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        double tmp;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        if (-interestRate > 1.0E13) {
            return costOfCarry > 1.0E13 ? 0.0 : Double.POSITIVE_INFINITY;
        }
        if (interestRate > 1.0E13) {
            return 0.0;
        }
        double discount = Math.abs(interestRate) < 1.0E-13 && timeToExpiry > 1.0E13 ? 1.0 : Math.exp(-interestRate * timeToExpiry);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (spot > 1.0E13 * strike || spot < 1.0E-13 * strike || sigmaRootT > 1.0E13) {
            return 0.0;
        }
        double factor = Math.exp(costOfCarry * timeToExpiry);
        if (Double.isNaN(factor)) {
            factor = 1.0;
        }
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD1 = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            tmp = coefD1 * rootT;
            d2 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d2 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp2 = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp2) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp2;
            d2 = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getPDF((Object)d2);
        double res = norm < 1.0E-13 ? 0.0 : discount * norm / strike / sigmaRootT;
        return Double.isNaN(res) ? Double.POSITIVE_INFINITY : res;
    }

    public static double crossGamma(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        double tmp;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        if (-interestRate > 1.0E13) {
            return costOfCarry > 1.0E13 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        if (interestRate > 1.0E13) {
            return 0.0;
        }
        double discount = Math.abs(interestRate) < 1.0E-13 && timeToExpiry > 1.0E13 ? 1.0 : Math.exp(-interestRate * timeToExpiry);
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (spot > 1.0E13 * strike || spot < 1.0E-13 * strike || sigmaRootT > 1.0E13) {
            return 0.0;
        }
        double factor = Math.exp(costOfCarry * timeToExpiry);
        if (Double.isNaN(factor)) {
            factor = 1.0;
        }
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD1 = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            tmp = coefD1 * rootT;
            d2 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d2 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp2 = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp2) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp2;
            d2 = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getPDF((Object)d2);
        double res = norm < 1.0E-13 ? 0.0 : -discount * norm / spot / sigmaRootT;
        return Double.isNaN(res) ? Double.NEGATIVE_INFINITY : res;
    }

    public static double theta(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double spotTerm;
        double discount;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        if (Math.abs(interestRate) > 1.0E13) {
            return 0.0;
        }
        double d = discount = Math.abs(interestRate) < 1.0E-13 && timeToExpiry > 1.0E13 ? 1.0 : Math.exp(-interestRate * timeToExpiry);
        if (costOfCarry > 1.0E13) {
            return isCall ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (-costOfCarry > 1.0E13) {
            double res = isCall ? 0.0 : (discount > 1.0E-13 ? strike * discount * interestRate : 0.0);
            return Double.isNaN(res) ? discount : res;
        }
        if (spot > 1.0E13 * strike) {
            double tmp = Math.exp((costOfCarry - interestRate) * timeToExpiry);
            double res = isCall ? (tmp > 1.0E-13 ? -(costOfCarry - interestRate) * spot * tmp : 0.0) : 0.0;
            return Double.isNaN(res) ? tmp : res;
        }
        if (1.0E13 * spot < strike) {
            double res = isCall ? 0.0 : (discount > 1.0E-13 ? strike * discount * interestRate : 0.0);
            return Double.isNaN(res) ? discount : res;
        }
        if (spot > 1.0E13 && strike > 1.0E13) {
            return Double.POSITIVE_INFINITY;
        }
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double d1 = 0.0;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || sigmaRootT > 1.0E13) {
            double coefD1 = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmpD1 = Math.abs(coefD1) < 1.0E-13 ? 0.0 : coefD1 * rootT;
            d1 = Double.isNaN(tmpD1) ? Math.signum(coefD1) : tmpD1;
            double coefD2 = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmpD2 = Math.abs(coefD2) < 1.0E-13 ? 0.0 : coefD2 * rootT;
            d2 = Double.isNaN(tmpD2) ? Math.signum(coefD2) : tmpD2;
        } else if (sigmaRootT < 1.0E-13) {
            d2 = d1 = (Math.log(spot / strike) / rootT + costOfCarry * rootT) / lognormalVol;
        } else {
            double tmp = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? rootT : (Math.abs(costOfCarry) < 1.0E-13 && rootT > 1.0E13 ? 1.0 / lognormalVol : costOfCarry / lognormalVol * rootT);
            d1 = Math.log(spot / strike) / sigmaRootT + tmp + 0.5 * sigmaRootT;
            d2 = d1 - sigmaRootT;
        }
        double norm = NORMAL.getPDF((Object)d1);
        double rescaledSpot = Math.exp((costOfCarry - interestRate) * timeToExpiry) * spot;
        double rescaledStrike = discount * strike;
        double normForSpot = NORMAL.getCDF((Object)((double)sign * d1));
        double normForStrike = NORMAL.getCDF((Object)((double)sign * d2));
        double d3 = normForSpot < 1.0E-13 ? 0.0 : (spotTerm = Double.isNaN(rescaledSpot) ? (double)(-sign) * Math.signum(costOfCarry - interestRate) * rescaledSpot : (double)(-sign) * ((costOfCarry - interestRate) * rescaledSpot * normForSpot));
        double strikeTerm = normForStrike < 1.0E-13 ? 0.0 : (Double.isNaN(rescaledSpot) ? (double)sign * (-Math.signum(interestRate) * discount) : (double)sign * (-interestRate * rescaledStrike * normForStrike));
        double coef = rescaledSpot * lognormalVol / rootT;
        if (Double.isNaN(coef)) {
            coef = 1.0;
        }
        double dlTerm = norm < 1.0E-13 ? 0.0 : -0.5 * norm * coef;
        double res = dlTerm + spotTerm + strikeTerm;
        return Double.isNaN(res) ? 0.0 : res;
    }

    public static double charm(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double tmp;
        double coeff;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if ((coeff = Math.exp((costOfCarry - interestRate) * timeToExpiry)) < 1.0E-13) {
            return 0.0;
        }
        if (Double.isNaN(coeff)) {
            coeff = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double d1 = 0.0;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || sigmaRootT > 1.0E13) {
            double coefD1 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmpD1 = Math.abs(coefD1) < 1.0E-13 ? 0.0 : coefD1 * rootT;
            d1 = Double.isNaN(tmpD1) ? Math.signum(coefD1) : tmpD1;
            double coefD2 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmpD2 = Math.abs(coefD2) < 1.0E-13 ? 0.0 : coefD2 * rootT;
            d2 = Double.isNaN(tmpD2) ? Math.signum(coefD2) : tmpD2;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d2 = d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp2 = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp2) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp2;
            double d1Tmp = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
            double d2Tmp = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
            d1 = Double.isNaN(d1Tmp) ? 0.0 : d1Tmp;
            d2 = Double.isNaN(d2Tmp) ? 0.0 : d2Tmp;
        }
        double cocMod = costOfCarry / sigmaRootT;
        if (Double.isNaN(cocMod)) {
            cocMod = 1.0;
        }
        tmp = Double.isNaN(tmp = d2 / timeToExpiry) ? (d2 >= 0.0 ? 1.0 : -1.0) : tmp;
        double coefPdf = cocMod - 0.5 * tmp;
        double normPdf = NORMAL.getPDF((Object)d1);
        double normCdf = NORMAL.getCDF((Object)((double)sign * d1));
        double first = normPdf < 1.0E-13 ? 0.0 : (Double.isNaN(coefPdf) ? 0.0 : normPdf * coefPdf);
        double second = normCdf < 1.0E-13 ? 0.0 : (costOfCarry - interestRate) * normCdf;
        double res = -coeff * (first + (double)sign * second);
        return Double.isNaN(res) ? 0.0 : res;
    }

    public static double dualCharm(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double discount;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if ((discount = Math.exp(-interestRate * timeToExpiry)) < 1.0E-13) {
            return 0.0;
        }
        if (Double.isNaN(discount)) {
            discount = 1.0;
        }
        int sign = isCall ? 1 : -1;
        double d1 = 0.0;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || sigmaRootT > 1.0E13) {
            double coefD1 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmpD1 = Math.abs(coefD1) < 1.0E-13 ? 0.0 : coefD1 * rootT;
            d1 = Double.isNaN(tmpD1) ? Math.signum(coefD1) : tmpD1;
            double coefD2 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmpD2 = Math.abs(coefD2) < 1.0E-13 ? 0.0 : coefD2 * rootT;
            d2 = Double.isNaN(tmpD2) ? Math.signum(coefD2) : tmpD2;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            double tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d2 = d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            double d1Tmp = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
            double d2Tmp = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
            d1 = Double.isNaN(d1Tmp) ? 0.0 : d1Tmp;
            d2 = Double.isNaN(d2Tmp) ? 0.0 : d2Tmp;
        }
        double coefPdf = 0.0;
        if (timeToExpiry < 1.0E-13) {
            coefPdf = Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 ? 1.0 / sigmaRootT : Math.log(spot / strike) / sigmaRootT / timeToExpiry;
        } else {
            double tmp;
            double cocMod = costOfCarry / sigmaRootT;
            if (Double.isNaN(cocMod)) {
                cocMod = 1.0;
            }
            tmp = Double.isNaN(tmp = d1 / timeToExpiry) ? (d1 >= 0.0 ? 1.0 : -1.0) : tmp;
            coefPdf = cocMod - 0.5 * tmp;
        }
        double normPdf = NORMAL.getPDF((Object)d2);
        double normCdf = NORMAL.getCDF((Object)((double)sign * d2));
        double first = normPdf < 1.0E-13 ? 0.0 : (Double.isNaN(coefPdf) ? 0.0 : normPdf * coefPdf);
        double second = normCdf < 1.0E-13 ? 0.0 : interestRate * normCdf;
        double res = discount * (first - (double)sign * second);
        return Double.isNaN(res) ? 0.0 : res;
    }

    public static double vega(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        double tmp;
        double factor;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return costOfCarry > 1.0E13 ? 0.0 : Double.POSITIVE_INFINITY;
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (Double.isNaN(factor = Math.exp(costOfCarry * timeToExpiry))) {
            factor = 1.0;
        }
        double d1 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || sigmaRootT > 1.0E13) {
            double coefD1 = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            tmp = coefD1 * rootT;
            d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else if (sigmaRootT < 1.0E-13 || spot > 1.0E13 * strike || strike > 1.0E13 * spot) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp2 = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp2) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp2;
            d1 = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getPDF((Object)d1);
        double res = norm < 1.0E-13 ? 0.0 : coef * norm * spot * rootT;
        return Double.isNaN(res) ? Double.POSITIVE_INFINITY : res;
    }

    public static double vanna(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        double d1 = 0.0;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || sigmaRootT > 1.0E13) {
            double coefD1 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmpD1 = Math.abs(coefD1) < 1.0E-13 ? 0.0 : coefD1 * rootT;
            d1 = Double.isNaN(tmpD1) ? Math.signum(coefD1) : tmpD1;
            double coefD2 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmpD2 = Math.abs(coefD2) < 1.0E-13 ? 0.0 : coefD2 * rootT;
            d2 = Double.isNaN(tmpD2) ? Math.signum(coefD2) : tmpD2;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            double tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d2 = d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            double d1Tmp = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
            double d2Tmp = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
            d1 = Double.isNaN(d1Tmp) ? 0.0 : d1Tmp;
            d2 = Double.isNaN(d2Tmp) ? 0.0 : d2Tmp;
        }
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return costOfCarry > 1.0E13 ? 0.0 : (d2 >= 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        double norm = NORMAL.getPDF((Object)d1);
        double tmp = d2 * coef / lognormalVol;
        if (Double.isNaN(tmp)) {
            tmp = coef;
        }
        return norm < 1.0E-13 ? 0.0 : -norm * tmp;
    }

    public static double dualVanna(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        double d1 = 0.0;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || sigmaRootT > 1.0E13) {
            double coefD1 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) + 0.5 * lognormalVol : costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmpD1 = Math.abs(coefD1) < 1.0E-13 ? 0.0 : coefD1 * rootT;
            d1 = Double.isNaN(tmpD1) ? Math.signum(coefD1) : tmpD1;
            double coefD2 = Double.isNaN(Math.abs(costOfCarry) / lognormalVol) ? Math.signum(costOfCarry) - 0.5 * lognormalVol : costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmpD2 = Math.abs(coefD2) < 1.0E-13 ? 0.0 : coefD2 * rootT;
            d2 = Double.isNaN(tmpD2) ? Math.signum(coefD2) : tmpD2;
        } else if (sigmaRootT < 1.0E-13) {
            double scnd = Math.abs(costOfCarry) > 1.0E13 && rootT < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry * rootT;
            double tmp = (Math.log(spot / strike) / rootT + scnd) / lognormalVol;
            d2 = d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            double tmp = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            double d1Tmp = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
            double d2Tmp = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
            d1 = Double.isNaN(d1Tmp) ? 0.0 : d1Tmp;
            d2 = Double.isNaN(d2Tmp) ? 0.0 : d2Tmp;
        }
        double coef = Math.exp(-interestRate * timeToExpiry);
        if (coef < 1.0E-13) {
            return 0.0;
        }
        if (Double.isNaN(coef)) {
            coef = 1.0;
        }
        double norm = NORMAL.getPDF((Object)d2);
        double tmp = d1 * coef / lognormalVol;
        if (Double.isNaN(tmp)) {
            tmp = coef;
        }
        return norm < 1.0E-13 ? 0.0 : norm * tmp;
    }

    public static double vomma(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (spot > 1.0E13 * strike || strike > 1.0E13 * spot || rootT < 1.0E-13) {
            return 0.0;
        }
        double d1 = 0.0;
        double d1d2Mod = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || rootT > 1.0E13) {
            double costOvVol = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry / lognormalVol;
            double coefD1 = costOvVol + 0.5 * lognormalVol;
            double coefD1D2Mod = costOvVol * costOvVol / lognormalVol - 0.25 * lognormalVol;
            double tmpD1 = coefD1 * rootT;
            double tmpD1d2Mod = coefD1D2Mod * rootT * timeToExpiry;
            d1 = Double.isNaN(tmpD1) ? 0.0 : tmpD1;
            d1d2Mod = Double.isNaN(tmpD1d2Mod) ? 1.0 : tmpD1d2Mod;
        } else if (lognormalVol > 1.0E13) {
            d1 = 0.5 * sigmaRootT;
            d1d2Mod = -0.25 * sigmaRootT * timeToExpiry;
        } else if (lognormalVol < 1.0E-13) {
            double d1Tmp = (Math.log(spot / strike) / rootT + costOfCarry * rootT) / lognormalVol;
            d1 = Double.isNaN(d1Tmp) ? 1.0 : d1Tmp;
            d1d2Mod = d1 * d1 * rootT / lognormalVol;
        } else {
            double tmp = Math.log(spot / strike) / sigmaRootT + costOfCarry * rootT / lognormalVol;
            d1 = tmp + 0.5 * sigmaRootT;
            d1d2Mod = (tmp * tmp - 0.25 * sigmaRootT * sigmaRootT) * rootT / lognormalVol;
        }
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return costOfCarry > 1.0E13 ? 0.0 : (d1d2Mod >= 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        double norm = NORMAL.getPDF((Object)d1);
        double tmp = d1d2Mod * spot * coef;
        if (Double.isNaN(tmp)) {
            tmp = coef;
        }
        return norm < 1.0E-13 ? 0.0 : norm * tmp;
    }

    public static double vegaBleed(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry) {
        double resLogRatio;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        if (Double.isNaN(sigmaRootT)) {
            sigmaRootT = 1.0;
        }
        if (spot > 1.0E13 * strike || strike > 1.0E13 * spot || rootT < 1.0E-13) {
            return 0.0;
        }
        double d1 = 0.0;
        double extra = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || spot > 1.0E13 && strike > 1.0E13 || rootT > 1.0E13) {
            double costOvVol = Math.abs(costOfCarry) < 1.0E-13 && lognormalVol < 1.0E-13 ? Math.signum(costOfCarry) : costOfCarry / lognormalVol;
            double coefD1 = costOvVol + 0.5 * lognormalVol;
            double tmpD1 = coefD1 * rootT;
            d1 = Double.isNaN(tmpD1) ? 0.0 : tmpD1;
            double coefExtra = interestRate - 0.5 * costOfCarry + 0.5 * costOvVol * costOvVol + 0.125 * lognormalVol * lognormalVol;
            double tmpExtra = Double.isNaN(coefExtra) ? rootT : coefExtra * rootT;
            extra = Double.isNaN(tmpExtra) ? 1.0 - 0.5 / rootT : tmpExtra - 0.5 / rootT;
        } else if (lognormalVol > 1.0E13) {
            d1 = 0.5 * sigmaRootT;
            extra = 0.125 * lognormalVol * sigmaRootT;
        } else if (lognormalVol < 1.0E-13) {
            resLogRatio = Math.log(spot / strike) / rootT;
            double d1Tmp = (resLogRatio + costOfCarry * rootT) / lognormalVol;
            d1 = Double.isNaN(d1Tmp) ? 1.0 : d1Tmp;
            double tmpExtra = (-0.5 * resLogRatio * resLogRatio / rootT + 0.5 * costOfCarry * costOfCarry * rootT) / lognormalVol / lognormalVol;
            extra = Double.isNaN(tmpExtra) ? 1.0 : extra;
        } else {
            resLogRatio = Math.log(spot / strike) / sigmaRootT;
            double tmp = resLogRatio + costOfCarry * rootT / lognormalVol;
            d1 = tmp + 0.5 * sigmaRootT;
            double pDivTmp = interestRate - 0.5 * costOfCarry * (1.0 - costOfCarry / lognormalVol / lognormalVol);
            double pDiv = Double.isNaN(pDivTmp) ? rootT : pDivTmp * rootT;
            extra = pDiv - 0.5 / rootT - 0.5 * resLogRatio * resLogRatio / rootT + 0.125 * lognormalVol * sigmaRootT;
        }
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return costOfCarry > 1.0E13 ? 0.0 : (extra >= 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        double norm = NORMAL.getPDF((Object)d1);
        double tmp = spot * coef * extra;
        if (Double.isNaN(tmp)) {
            tmp = coef;
        }
        return norm < 1.0E-13 ? 0.0 : tmp * norm;
    }

    public static double rho(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double discount = 0.0;
        if (-interestRate > 1.0E13) {
            return isCall ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (interestRate > 1.0E13) {
            return 0.0;
        }
        double d = discount = Math.abs(interestRate) < 1.0E-13 && timeToExpiry > 1.0E13 ? 1.0 : Math.exp(-interestRate * timeToExpiry);
        if (1.0E13 * spot < strike || timeToExpiry > 1.0E13) {
            double res = isCall ? 0.0 : -discount * strike * timeToExpiry;
            return Double.isNaN(res) ? -discount : res;
        }
        if (spot > 1.0E13 * strike || timeToExpiry < 1.0E-13) {
            double res = isCall ? discount * strike * timeToExpiry : 0.0;
            return Double.isNaN(res) ? discount : res;
        }
        int sign = isCall ? 1 : -1;
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        double factor = Math.exp(costOfCarry * timeToExpiry);
        double rescaledSpot = spot * factor;
        double d2 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || sigmaRootT > 1.0E13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD1 = costOfCarry / lognormalVol - 0.5 * lognormalVol;
            double tmp = coefD1 * rootT;
            d2 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            if (sigmaRootT < 1.0E-13) {
                return isCall ? (rescaledSpot > strike ? discount * strike * timeToExpiry : 0.0) : (rescaledSpot < strike ? -discount * strike * timeToExpiry : 0.0);
            }
            double tmp = costOfCarry * rootT / lognormalVol;
            double d3 = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            d2 = Math.log(spot / strike) / sigmaRootT + scnd - 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getCDF((Object)((double)sign * d2));
        double result = norm < 1.0E-13 ? 0.0 : (double)sign * discount * strike * timeToExpiry * norm;
        return Double.isNaN(result) ? (double)sign * discount : result;
    }

    public static double carryRho(double spot, double strike, double timeToExpiry, double lognormalVol, double interestRate, double costOfCarry, boolean isCall) {
        double res;
        ArgChecker.isTrue((spot >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN spot; have {}", (double)spot);
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN strike; have {}", (double)strike);
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN timeToExpiry; have {}", (double)timeToExpiry);
        ArgChecker.isTrue((lognormalVol >= 0.0 ? 1 : 0) != 0, (String)"negative/NaN lognormalVol; have {}", (double)lognormalVol);
        ArgChecker.isFalse((boolean)Double.isNaN(interestRate), (String)"interestRate is NaN");
        ArgChecker.isFalse((boolean)Double.isNaN(costOfCarry), (String)"costOfCarry is NaN");
        double coef = 0.0;
        if (interestRate > 1.0E13 && costOfCarry > 1.0E13 || -interestRate > 1.0E13 && -costOfCarry > 1.0E13 || Math.abs(costOfCarry - interestRate) < 1.0E-13) {
            coef = 1.0;
        } else {
            double rate = costOfCarry - interestRate;
            if (rate > 1.0E13) {
                return isCall ? Double.POSITIVE_INFINITY : (costOfCarry > 1.0E13 ? 0.0 : Double.NEGATIVE_INFINITY);
            }
            if (-rate > 1.0E13) {
                return 0.0;
            }
            coef = Math.exp(rate * timeToExpiry);
        }
        if (spot > 1.0E13 * strike || timeToExpiry > 1.0E13) {
            res = isCall ? coef * spot * timeToExpiry : 0.0;
            return Double.isNaN(res) ? coef : res;
        }
        if (1.0E13 * spot < strike || timeToExpiry < 1.0E-13) {
            res = isCall ? 0.0 : -coef * spot * timeToExpiry;
            return Double.isNaN(res) ? -coef : res;
        }
        int sign = isCall ? 1 : -1;
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = lognormalVol * rootT;
        double factor = Math.exp(costOfCarry * timeToExpiry);
        double rescaledSpot = spot * factor;
        double d1 = 0.0;
        if (Math.abs(spot - strike) < 1.0E-13 || sigmaRootT > 1.0E13 || spot > 1.0E13 && strike > 1.0E13) {
            double coefD1 = costOfCarry / lognormalVol + 0.5 * lognormalVol;
            double tmp = coefD1 * rootT;
            d1 = Double.isNaN(tmp) ? 0.0 : tmp;
        } else {
            double sig;
            if (sigmaRootT < 1.0E-13) {
                return isCall ? (rescaledSpot > strike ? coef * timeToExpiry * spot : 0.0) : (rescaledSpot < strike ? -coef * timeToExpiry * spot : 0.0);
            }
            double tmp = costOfCarry * rootT / lognormalVol;
            double d = sig = costOfCarry >= 0.0 ? 1.0 : -1.0;
            double scnd = Double.isNaN(tmp) ? (lognormalVol < 1.0E13 && lognormalVol > 1.0E-13 ? sig / lognormalVol : sig * rootT) : tmp;
            d1 = Math.log(spot / strike) / sigmaRootT + scnd + 0.5 * sigmaRootT;
        }
        double norm = NORMAL.getCDF((Object)((double)sign * d1));
        double result = norm < 1.0E-13 ? 0.0 : (double)sign * coef * timeToExpiry * spot * norm;
        return Double.isNaN(result) ? (double)sign * coef : result;
    }
}

